/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.report2.logical;

import com.elixirtech.report2.logical.LogicalRenderContext;
import com.elixirtech.report2.logical.RenderStackFrame;
import com.elixirtech.report2.raw.model.DataSource;
import com.elixirtech.report2.raw.model.IResourceProvider;
import com.elixirtech.report2.raw.model.PageSetup;
import com.elixirtech.report2.raw.model.Section;
import com.elixirtech.report2.raw.model.Style;
import com.elixirtech.report2.script.JSEngine;
import com.elixirtech.report2.script.ScriptEngine;
import com.elixirtech.repository.RMLFileObject;
import java.util.LinkedList;
import java.util.List;

public class RenderStack
implements IResourceProvider {
    private List<RenderStackFrame> m_Frames = new LinkedList<RenderStackFrame>();
    private RenderStackFrame m_Root;
    private RenderStackFrame m_Last;
    private final ScriptEngine m_ScriptEngine;
    private static ThreadLocal<RenderStack> m_Current = new ThreadLocal();

    public static RenderStack current() {
        return m_Current.get();
    }

    public static void install(RenderStack renderStack) {
        if (m_Current.get() != null) {
            throw new IllegalThreadStateException("This thread already has a RenderStack");
        }
        m_Current.set(renderStack);
    }

    public static void release() {
        m_Current.set(null);
    }

    public RenderStack(IResourceProvider iResourceProvider, LogicalRenderContext logicalRenderContext) {
        if (m_Current.get() != null) {
            throw new IllegalThreadStateException("This thread already has a RenderStack");
        }
        m_Current.set(this);
        this.m_Last = this.m_Root = new RenderStackFrame(iResourceProvider, logicalRenderContext, null);
        this.m_Frames.add(this.m_Root);
        this.m_ScriptEngine = new ScriptEngine(new JSEngine());
        logicalRenderContext.setRenderStack(this);
    }

    public void push(IResourceProvider iResourceProvider, LogicalRenderContext logicalRenderContext) {
        RenderStackFrame renderStackFrame = new RenderStackFrame(iResourceProvider, logicalRenderContext, null);
        this.m_Last.setNext(renderStackFrame);
        this.m_Last = renderStackFrame;
        this.m_Frames.add(renderStackFrame);
        this.m_ScriptEngine.pushScope();
        logicalRenderContext.setRenderStack(this);
    }

    public void pop() {
        int n = this.m_Frames.size();
        this.m_Frames.remove(n - 1);
        this.m_Last = this.m_Frames.get(n - 2);
        this.m_Last.setNext(null);
        this.m_ScriptEngine.popScope();
    }

    public ScriptEngine getScriptEngine() {
        return this.m_ScriptEngine;
    }

    @Override
    public DataSource getDataSource(String string) {
        return this.m_Root.getDataSource(string);
    }

    @Override
    public Style getStyle(String string) {
        return this.m_Root.getStyle(string);
    }

    @Override
    public PageSetup getPageSetup(String string) {
        return this.m_Root.getPageSetup(string);
    }

    @Override
    public RMLFileObject getFile(String string) {
        return this.m_Root.getFile(string);
    }

    @Override
    public Section getSection(String string) {
        return this.m_Root.getSection(string);
    }

    @Override
    public String getProperty(String string) {
        return this.m_Root.getProperty(string);
    }

    @Override
    public String resolveRepositoryURL(String string) {
        return this.m_Root.resolveRepositoryURL(string);
    }

    @Override
    public String getRelativeRepositoryURL(String string) {
        return this.m_Root.getRelativeRepositoryURL(string);
    }

    public LogicalRenderContext getContext() {
        return this.m_Last.getContext();
    }

    public void dispose() {
        m_Current.set(null);
    }
}

