/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.report2.logical.callback.html2;

import com.elixirtech.arch.LoggingHelper2;
import com.elixirtech.arch.LoggingInterface;
import com.elixirtech.report2.logical.callback.html2.AttributedStringBuilder;
import com.elixirtech.report2.logical.callback.html2.HTMLCallback2$;
import com.elixirtech.report2.logical.callback.html2.LayoutBlock;
import com.typesafe.config.Config;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.commons.codec.binary.Base64;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.w3c.tidy.Tidy;
import org.w3c.tidy.TidyMessage;
import org.w3c.tidy.TidyMessageListener;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.collection.IterableOnceOps;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Set;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.runtime.BooleanRef;
import scala.runtime.LambdaDeserialize;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction1;
import sourcecode.FullName$;
import sourcecode.Line$;

public final class HTMLToAttributedString$
implements LoggingHelper2,
Serializable {
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(HTMLToAttributedString$.class.getDeclaredField("log$lzy1"));
    private volatile Object log$lzy1;
    private static final scala.collection.immutable.Set<String> BlockTags;
    private static final scala.collection.immutable.Set<String> HasTopBottomMarginTags;
    private static final Map<String, String> PredefStyles;
    public static final HTMLToAttributedString$ MODULE$;

    private HTMLToAttributedString$() {
    }

    static {
        MODULE$ = new HTMLToAttributedString$();
        BlockTags = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"div", "p", "ul", "ol", "hr", "h1", "h2", "h3", "h4", "h5", "h6", "tr", "td"}));
        HasTopBottomMarginTags = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"h1", "h2", "h3", "h4", "u", "ol"}));
        Config styles = HTMLCallback2$.MODULE$.html2Config().getConfig("styles");
        Set keys = CollectionConverters$.MODULE$.SetHasAsScala(HTMLCallback2$.MODULE$.html2Config().getObject("styles").keySet()).asScala();
        PredefStyles = ((IterableOnceOps)keys.map((Function1 & Serializable)s -> {
            String string = (String)Predef$.MODULE$.ArrowAssoc(s);
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)styles.getString(s));
        })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public LoggingInterface log() {
        Object object = this.log$lzy1;
        if (object instanceof LoggingInterface) {
            return (LoggingInterface)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (LoggingInterface)this.log$lzyINIT1();
    }

    private Object log$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.log$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    LoggingInterface loggingInterface = null;
                    try {
                        loggingInterface = LoggingHelper2.log$((LoggingHelper2)this);
                        object2 = loggingInterface == null ? LazyVals.NullValue$.MODULE$ : loggingInterface;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.log$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return loggingInterface;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(HTMLToAttributedString$.class);
    }

    public List<LayoutBlock> run(String text) {
        Tidy tidy = new Tidy();
        tidy.setQuiet(true);
        tidy.setShowWarnings(false);
        BooleanRef foundError = BooleanRef.create((boolean)false);
        tidy.setMessageListener(new TidyMessageListener(foundError){
            private final BooleanRef foundError$1;
            {
                this.foundError$1 = foundError$2;
            }

            public void messageReceived(TidyMessage msg) {
                TidyMessage.Level level = msg.getLevel();
                TidyMessage.Level level2 = TidyMessage.Level.ERROR;
                if (!(level != null ? !level.equals(level2) : level2 != null)) {
                    HTMLToAttributedString$.MODULE$.log().warn(() -> HTMLToAttributedString$.com$elixirtech$report2$logical$callback$html2$HTMLToAttributedString$$anon$1$$_$messageReceived$$anonfun$1(msg), Line$.MODULE$.apply(33), FullName$.MODULE$.apply("com.elixirtech.report2.logical.callback.html2.HTMLToAttributedString.$anon.messageReceived"));
                    this.foundError$1.elem = true;
                    return;
                }
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{com$elixirtech$report2$logical$callback$html2$HTMLToAttributedString$$anon$1$$_$messageReceived$$anonfun$1(org.w3c.tidy.TidyMessage )}, serializedLambda);
            }
        });
        Document dom = tidy.parseDOM((Reader)new StringReader(text), null);
        if (!foundError.elem) {
            AttributedStringBuilder builder = new AttributedStringBuilder();
            Element root = dom.getDocumentElement();
            this.render(root, builder);
            builder.newline();
            return builder.layoutBlocks().toList();
        }
        return package$.MODULE$.Nil();
    }

    public void render(Element e, AttributedStringBuilder builder) {
        int origDepth = builder.styleDepth();
        this.renderBegin(e, builder);
        NodeList children = e.getChildNodes();
        int len = children.getLength();
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), len).foreach((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            Node node = children.item(i);
            if (node instanceof Element) {
                Element e = (Element)node;
                MODULE$.render(e, builder);
                return;
            }
            if (node instanceof Text) {
                Text x = (Text)node;
                builder.addText(x.getData());
                return;
            }
        });
        this.renderEnd(e, builder);
        int endDepth = builder.styleDepth();
        if (origDepth != endDepth) {
            this.log().error(() -> HTMLToAttributedString$.render$$anonfun$2(origDepth, endDepth, e), Line$.MODULE$.apply(64), FullName$.MODULE$.apply("com.elixirtech.report2.logical.callback.html2.HTMLToAttributedString.render"));
            return;
        }
    }

    public void renderBegin(Element e, AttributedStringBuilder builder) {
        String string;
        String tagName = e.getTagName();
        if (this.isBlock(tagName)) {
            builder.newline();
        }
        PredefStyles.get((Object)tagName).foreach((Function1)(JProcedure1 & Serializable)s -> builder.pushStyle(tagName + " predef", (String)s));
        Option$.MODULE$.apply((Object)e.getAttribute("style")).foreach((Function1)(JProcedure1 & Serializable)s -> builder.pushStyle(tagName + " style", (String)s));
        if (this.hasTopBottomMargins(tagName)) {
            builder.setTopBottomMargins(HTMLCallback2$.MODULE$.TBMargin());
        }
        switch ((string = tagName) == null ? 0 : string.hashCode()) {
            case 112: {
                if (!"p".equals(string)) break;
                Option$.MODULE$.apply((Object)e.getNodeValue()).foreach((Function1)(JProcedure1 & Serializable)txt -> builder.addText((String)txt));
                return;
            }
            case 3152: {
                if (!"br".equals(string)) break;
                return;
            }
            case 3338: {
                if (!"hr".equals(string)) break;
                builder.addHR();
                return;
            }
            case 3453: {
                if (!"li".equals(string)) break;
                Option$.MODULE$.apply((Object)e.getNodeValue()).foreach((Function1)(JProcedure1 & Serializable)txt -> builder.addText((String)txt));
                return;
            }
            case 3549: {
                if (!"ol".equals(string)) break;
                builder.startOL();
                return;
            }
            case 3696: {
                if (!"td".equals(string)) break;
                builder.startTD();
                return;
            }
            case 3710: {
                if (!"tr".equals(string)) break;
                builder.startTR();
                return;
            }
            case 3735: {
                if (!"ul".equals(string)) break;
                builder.startUL();
                return;
            }
            case 99473: {
                if (!"div".equals(string)) break;
                Option$.MODULE$.apply((Object)e.getNodeValue()).foreach((Function1)(JProcedure1 & Serializable)txt -> builder.addText((String)txt));
                return;
            }
            case 104387: {
                if (!"img".equals(string)) break;
                this.renderImage(e, builder);
                return;
            }
            case 3536714: {
                if (!"span".equals(string)) break;
                Option$.MODULE$.apply((Object)e.getNodeValue()).foreach((Function1)(JProcedure1 & Serializable)txt -> builder.addText((String)txt));
                return;
            }
            case 1303202319: {
                if (!"blockquote".equals(string)) break;
                builder.indent();
                return;
            }
        }
    }

    public boolean isBlock(String tagName) {
        return BlockTags.contains((Object)tagName);
    }

    public boolean hasTopBottomMargins(String tagName) {
        return HasTopBottomMarginTags.contains((Object)tagName);
    }

    public void renderImage(Element e, AttributedStringBuilder builder) {
        String src = e.getAttribute("src");
        if (src.startsWith("data:")) {
            String s1 = StringOps$.MODULE$.stripPrefix$extension(Predef$.MODULE$.augmentString(src), "data:");
            String s2 = s1.substring(s1.indexOf(","));
            byte[] bytes = Base64.decodeBase64((String)s2);
            builder.addImage(bytes);
            return;
        }
        builder.addImage(src);
    }

    public void renderEnd(Element e, AttributedStringBuilder builder) {
        String string;
        String tagName = e.getTagName();
        if (this.isBlock(tagName)) {
            builder.newline();
        }
        switch ((string = tagName) == null ? 0 : string.hashCode()) {
            case 3152: {
                if (!"br".equals(string)) break;
                builder.newline();
                break;
            }
            case 3453: {
                if (!"li".equals(string)) break;
                builder.newline();
                break;
            }
            case 3549: {
                if (!"ol".equals(string)) break;
                builder.endOL();
                break;
            }
            case 3696: {
                if (!"td".equals(string)) break;
                builder.endTD();
                break;
            }
            case 3710: {
                if (!"tr".equals(string)) break;
                builder.endTR();
                break;
            }
            case 3735: {
                if (!"ul".equals(string)) break;
                builder.endUL();
                break;
            }
            case 1303202319: {
                if (!"blockquote".equals(string)) break;
                builder.outdent();
                break;
            }
        }
        if (this.hasTopBottomMargins(tagName)) {
            builder.popStyle(tagName + " tbmargins");
        }
        Option$.MODULE$.apply((Object)e.getAttribute("style")).foreach((Function1)(JProcedure1 & Serializable)_$1 -> builder.popStyle(tagName + " style"));
        PredefStyles.get((Object)tagName).foreach((Function1)(JProcedure1 & Serializable)_$2 -> builder.popStyle("tagName predef"));
    }

    public static final Object com$elixirtech$report2$logical$callback$html2$HTMLToAttributedString$$anon$1$$_$messageReceived$$anonfun$1(TidyMessage msg$1) {
        return "line: " + msg$1.getLine() + " col: " + msg$1.getColumn() + " " + msg$1.getMessage();
    }

    private static final Object render$$anonfun$2(int origDepth$1, int endDepth$1, Element e$1) {
        return "origDepth=" + origDepth$1 + " endDepth=" + endDepth$1 + " for " + e$1.getTagName() + " with " + e$1.getTextContent();
    }
}

