/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.report2.logical.layout;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.report2.logical.model.ILogicalElementHolder;
import com.elixirtech.report2.logical.model.LogicalElement;
import com.elixirtech.report2.raw.model.RawElement;
import com.elixirtech.report2.raw.model.RawModelElement;
import com.elixirtech.report2.util.ElementUtil;
import com.elixirtech.report2.util.MetricConvertor;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class LayoutElement {
    protected RawModelElement m_Element;
    protected String m_Id;
    protected Rectangle m_Rect;
    protected List<Link> m_Above = new ArrayList<Link>();
    protected LogicalElement m_Output;
    protected int m_OutputHeight;
    protected int m_OutputTop;
    protected boolean m_Normalized = false;
    private static final ElxLoggerJ m_Log = ElxLoggerJ.getLogger(LayoutElement.class);

    public LayoutElement(RawModelElement rawModelElement) {
        this.m_Element = rawModelElement;
        this.m_Id = rawModelElement instanceof RawElement ? ((RawElement)rawModelElement).getName() : rawModelElement.getTagName();
        this.m_Rect = ElementUtil.getRect(rawModelElement);
        int n = this.m_Rect.x + this.m_Rect.width;
        this.m_Rect.x = MetricConvertor.twipToPoint(this.m_Rect.x);
        this.m_Rect.width = MetricConvertor.twipToPoint(n) - this.m_Rect.x;
        this.m_OutputTop = this.m_Rect.y;
        this.m_OutputHeight = 0;
    }

    public LayoutElement(String string, Rectangle rectangle) {
        this.m_Id = string;
        this.m_Rect = rectangle;
    }

    public void determineThoseAbove(List<LayoutElement> list) {
        for (LayoutElement layoutElement : list) {
            if (layoutElement == this || !this.dependsOn(layoutElement) || this.alreadyDependentOn(layoutElement)) continue;
            Rectangle rectangle = layoutElement.getRect();
            int n = this.getGap(rectangle, this.m_Rect);
            this.m_Above.add(new Link(layoutElement, n));
        }
    }

    public boolean dependsOn(LayoutElement layoutElement) {
        Rectangle rectangle = layoutElement.getRect();
        return this.intersectsX(rectangle, this.m_Rect) && rectangle.y < this.m_Rect.y && rectangle.y + rectangle.height <= this.m_Rect.y;
    }

    protected boolean alreadyDependentOn(LayoutElement layoutElement) {
        for (Link link : this.m_Above) {
            if (!link.element.dependsOn(layoutElement)) continue;
            return true;
        }
        return false;
    }

    protected void normalizeDependencies() {
        HashSet<LayoutElement> hashSet = new HashSet<LayoutElement>();
        HashSet<LayoutElement> hashSet2 = new HashSet<LayoutElement>();
        for (Link link : this.m_Above) {
            link.element.buildDependenciesAbove(hashSet, hashSet2);
        }
        this.removeFromAbove(hashSet);
        this.m_Normalized = true;
    }

    protected void buildDependenciesAbove(Set<LayoutElement> set, Set<LayoutElement> set2) {
        if (this.m_Normalized) {
            m_Log.debug((Object)"Normalize sequence error - dependents should be normalized first");
        }
        set2.add(this);
        Iterator<Link> iterator = this.m_Above.iterator();
        while (iterator.hasNext()) {
            LayoutElement layoutElement = iterator.next().element;
            set.add(layoutElement);
            if (set2.contains(layoutElement)) continue;
            layoutElement.buildDependenciesAbove(set, set2);
        }
    }

    protected void removeFromAbove(Set<LayoutElement> set) {
        ArrayList<Link> arrayList = new ArrayList<Link>();
        for (Link link : this.m_Above) {
            if (!set.contains(link.element)) continue;
            arrayList.add(link);
        }
        this.m_Above.removeAll(arrayList);
    }

    public String getId() {
        return this.m_Id;
    }

    public RawModelElement getElement() {
        return this.m_Element;
    }

    public Rectangle getRect() {
        return this.m_Rect;
    }

    public void setOutput(LogicalElement logicalElement) {
        this.m_Output = logicalElement;
        this.m_OutputTop = logicalElement.getTop();
        this.m_OutputHeight = logicalElement.getHeight();
    }

    public LogicalElement getOutput() {
        return this.m_Output;
    }

    public int getOutputTop() {
        return this.m_OutputTop;
    }

    public void setOutputTop(int n) {
        int n2 = this.m_OutputTop;
        this.m_Output.setTop(n);
        this.m_OutputTop = n;
        if (this.m_Output instanceof ILogicalElementHolder) {
            this.moveTop((ILogicalElementHolder)((Object)this.m_Output), n - n2);
        }
    }

    private void moveTop(ILogicalElementHolder iLogicalElementHolder, int n) {
        Iterator<LogicalElement> iterator = iLogicalElementHolder.getLogicalElementIterator();
        while (iterator.hasNext()) {
            LogicalElement logicalElement = iterator.next();
            logicalElement.setTop(logicalElement.getTop() + n);
            if (!(logicalElement instanceof ILogicalElementHolder)) continue;
            this.moveTop((ILogicalElementHolder)((Object)logicalElement), n);
        }
    }

    public int getOutputHeight() {
        return this.m_OutputHeight;
    }

    public List<Link> aboveLinks() {
        return this.m_Above;
    }

    public String debugString() {
        StringBuffer stringBuffer = new StringBuffer(this.m_Id);
        stringBuffer.append(" [");
        Iterator<Link> iterator = this.m_Above.iterator();
        while (iterator.hasNext()) {
            Link link = iterator.next();
            stringBuffer.append(link.element.getId());
            stringBuffer.append(':');
            stringBuffer.append(link.gap);
            if (!iterator.hasNext()) continue;
            stringBuffer.append(",");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    protected int getGap(Rectangle rectangle, Rectangle rectangle2) {
        return rectangle2.y - (rectangle.y + rectangle.height);
    }

    protected boolean intersectsX(Rectangle rectangle, Rectangle rectangle2) {
        if (rectangle.x <= rectangle2.x && rectangle.x + rectangle.width > rectangle2.x) {
            return true;
        }
        return rectangle2.x <= rectangle.x && rectangle2.x + rectangle2.width > rectangle.x;
    }

    public static class Link {
        public LayoutElement element;
        public int gap;

        public Link(LayoutElement layoutElement, int n) {
            this.element = layoutElement;
            this.gap = n;
        }
    }

    public static class ReverseYOrderComparator
    implements Comparator<LayoutElement> {
        @Override
        public int compare(LayoutElement layoutElement, LayoutElement layoutElement2) {
            Rectangle rectangle = layoutElement.getRect();
            Rectangle rectangle2 = layoutElement2.getRect();
            int n = rectangle.y + rectangle.height;
            int n2 = rectangle2.y + rectangle2.height;
            if (n > n2) {
                return -1;
            }
            if (n < n2) {
                return 1;
            }
            return 0;
        }

        @Override
        public boolean equals(Object object) {
            return object instanceof ReverseYOrderComparator;
        }
    }
}

