/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.report2.logical.model;

import com.elixirtech.report2.logical.model.Glint;
import com.elixirtech.report2.logical.model.GlintSAX;
import com.elixirtech.report2.logical.model.Image;
import com.elixirtech.report2.logical.model.ImageSAX;
import com.elixirtech.report2.logical.model.Line;
import com.elixirtech.report2.logical.model.LineSAX;
import com.elixirtech.report2.logical.model.LogicalElementHolder;
import com.elixirtech.report2.logical.model.PageBreak;
import com.elixirtech.report2.logical.model.PageBreakSAX;
import com.elixirtech.report2.logical.model.RTF;
import com.elixirtech.report2.logical.model.RTFSAX;
import com.elixirtech.report2.logical.model.Rectangle;
import com.elixirtech.report2.logical.model.RectangleSAX;
import com.elixirtech.report2.logical.model.Reference;
import com.elixirtech.report2.logical.model.ReferenceSAX;
import com.elixirtech.report2.logical.model.SVG;
import com.elixirtech.report2.logical.model.SVGSAX;
import com.elixirtech.report2.logical.model.SizableElementSAX;
import com.elixirtech.report2.logical.model.Text;
import com.elixirtech.report2.logical.model.TextSAX;
import org.xml.sax.Attributes;

public class LogicalElementHolderSAX
extends SizableElementSAX {
    protected LogicalElementHolder m_LogicalElementHolder;
    private String m_Tag;

    protected void setLogicalElementHolder(LogicalElementHolder logicalElementHolder) {
        this.m_LogicalElementHolder = logicalElementHolder;
        this.setSizableElement(logicalElementHolder);
    }

    @Override
    public Object getObject() {
        return this.m_LogicalElementHolder;
    }

    @Override
    protected void doStart(String string, Attributes attributes) {
        if (!this.m_AttributesInitialized && string.equals(this.m_Tag)) {
            this.initAttributes(attributes);
        } else if (string.equals("text")) {
            this.m_Delegate = new TextSAX("text");
        } else if (string.equals("image")) {
            this.m_Delegate = new ImageSAX("image");
        } else if (string.equals("rect")) {
            this.m_Delegate = new RectangleSAX("rect");
        } else if (string.equals("line")) {
            this.m_Delegate = new LineSAX("line");
        } else if (string.equals("glint")) {
            this.m_Delegate = new GlintSAX("glint");
        } else if (string.equals("svg")) {
            this.m_Delegate = new SVGSAX("svg");
        } else if (string.equals("page-break")) {
            this.m_Delegate = new PageBreakSAX("page-break");
        } else if (string.equals("rtf")) {
            this.m_Delegate = new RTFSAX("rtf");
        } else if (string.equals("reference")) {
            this.m_Delegate = new ReferenceSAX("reference");
        } else {
            super.doStart(string, attributes);
        }
    }

    @Override
    protected void initAttributes(Attributes attributes) {
        this.m_LogicalElementHolder.setBackgroundColor(attributes.getValue("Back_Color"));
        String string = attributes.getValue("Width");
        if (string != null) {
            int n;
            block5: {
                n = 0;
                try {
                    n = Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {
                    if (!string.endsWith("pt")) break block5;
                    string = string.substring(0, string.length() - 2).trim();
                    try {
                        n = Integer.parseInt(string) * 20;
                    }
                    catch (NumberFormatException numberFormatException2) {
                        m_Log.error((Object)("Can't process Width : " + attributes.getValue("Width")));
                    }
                }
            }
            this.m_LogicalElementHolder.setWidth(n);
        }
        this.m_LogicalElementHolder.setURL(attributes.getValue("URL"));
        this.m_LogicalElementHolder.setURLDescription(attributes.getValue("URL_Description"));
        this.m_LogicalElementHolder.setURLTarget(attributes.getValue("URL_Target"));
        super.initAttributes(attributes);
    }

    @Override
    protected void doEnd(String string) {
        if (string.equals("text")) {
            Text text = (Text)this.m_Delegate.getObject();
            this.m_LogicalElementHolder.addLogicalElement(text);
        } else if (string.equals("image")) {
            Image image = (Image)this.m_Delegate.getObject();
            this.m_LogicalElementHolder.addLogicalElement(image);
        } else if (string.equals("rect")) {
            Rectangle rectangle = (Rectangle)this.m_Delegate.getObject();
            this.m_LogicalElementHolder.addLogicalElement(rectangle);
        } else if (string.equals("line")) {
            Line line = (Line)this.m_Delegate.getObject();
            this.m_LogicalElementHolder.addLogicalElement(line);
        } else if (string.equals("glint")) {
            Glint glint = (Glint)this.m_Delegate.getObject();
            this.m_LogicalElementHolder.addLogicalElement(glint);
        } else if (string.equals("svg")) {
            SVG sVG = (SVG)this.m_Delegate.getObject();
            this.m_LogicalElementHolder.addLogicalElement(sVG);
        } else if (string.equals("page-break")) {
            PageBreak pageBreak = (PageBreak)this.m_Delegate.getObject();
            this.m_LogicalElementHolder.addLogicalElement(pageBreak);
        } else if (string.equals("rtf")) {
            RTF rTF = (RTF)this.m_Delegate.getObject();
            this.m_LogicalElementHolder.addLogicalElement(rTF);
        } else if (string.equals("reference")) {
            Reference reference = (Reference)this.m_Delegate.getObject();
            this.m_LogicalElementHolder.addLogicalElement(reference);
        } else {
            super.doEnd(string);
        }
    }
}

