/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.report2.logical.renderer;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.barcode.BasicBarcodeRenderer;
import com.elixirtech.report2.RenderException;
import com.elixirtech.report2.data.ControlSourceProcessor;
import com.elixirtech.report2.logical.LogicalRenderContext;
import com.elixirtech.report2.logical.model.Image;
import com.elixirtech.report2.logical.model.Rectangle;
import com.elixirtech.report2.logical.renderer.BasicLogicalRenderer;
import com.elixirtech.report2.raw.constants.Alignment;
import com.elixirtech.report2.raw.model.Barcode;
import com.elixirtech.report2.raw.model.RawModelElement;

public class BarcodeRenderer
extends BasicLogicalRenderer {
    private static int m_ImageId = 1;
    public static ElxLoggerJ m_Log = ElxLoggerJ.getLogger(BarcodeRenderer.class);

    @Override
    public void render(LogicalRenderContext logicalRenderContext, RawModelElement rawModelElement) throws RenderException {
        Barcode barcode = (Barcode)rawModelElement;
        if (barcode.isVisible()) {
            new BasicBarcodeRenderer().render(barcode, this.getValue(logicalRenderContext, barcode));
            java.awt.Image image = barcode.getImage();
            if (image != null) {
                Image image2 = new Image();
                image2.setImage(image);
                this.insetBorder(barcode, image2);
                Rectangle rectangle = BarcodeRenderer.buildRect(barcode);
                rectangle.setCurvedClip(true);
                rectangle.setPaddedClip(true);
                image2.setRaw(barcode);
                image2.setPicture("Barcode_" + m_ImageId++);
                image2.setSizeMode("Clip");
                image2.setHorizontalAlign(Alignment.CENTER.NAME);
                image2.setVerticalAlign(Alignment.CENTER.NAME);
                rectangle.addLogicalElement(image2);
                logicalRenderContext.addElement(rectangle);
            }
        }
    }

    protected String getValue(LogicalRenderContext logicalRenderContext, Barcode barcode) {
        Object object = ControlSourceProcessor.getData(barcode.getControlSource());
        if (object != null) {
            return String.valueOf(object);
        }
        return null;
    }

    @Override
    protected ElxLoggerJ getLog() {
        return m_Log;
    }
}

