/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.report2.logical.renderer;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.arch.StringUtil;
import com.elixirtech.chart2.data.ChartDataFactory;
import com.elixirtech.chart2.model.Chart;
import com.elixirtech.chart2.model.ChartSAX;
import com.elixirtech.chart2.model.IChart;
import com.elixirtech.chart2.renderer.AbstractChartRenderer;
import com.elixirtech.chart2.renderer.ChartRenderFactory;
import com.elixirtech.chart2.renderer.DatasetHolder;
import com.elixirtech.data2.ArgumentMap;
import com.elixirtech.data2.Data;
import com.elixirtech.data2.DataException;
import com.elixirtech.data2.DataRecord;
import com.elixirtech.data2.DataTable;
import com.elixirtech.data2.GroupNode;
import com.elixirtech.jdom.Document;
import com.elixirtech.jdom.JDOMException;
import com.elixirtech.jdom.output.SAXOutputter;
import com.elixirtech.report2.RenderContainer;
import com.elixirtech.report2.RenderException;
import com.elixirtech.report2.data.IDataCache;
import com.elixirtech.report2.data.IDataCacheManager;
import com.elixirtech.report2.logical.DataHolder;
import com.elixirtech.report2.logical.LogicalRenderContext;
import com.elixirtech.report2.logical.RenderUtil;
import com.elixirtech.report2.logical.ReportSubstitution;
import com.elixirtech.report2.logical.model.Image;
import com.elixirtech.report2.logical.model.Rectangle;
import com.elixirtech.report2.logical.renderer.BasicLogicalRenderer;
import com.elixirtech.report2.raw.constants.Alignment;
import com.elixirtech.report2.raw.model.RawModelElement;
import com.elixirtech.report2.raw.model.Section;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.jfree.chart.JFreeChart;

public class ChartRenderer
extends BasicLogicalRenderer {
    private static int m_ImageId = 1;
    private static ElxLoggerJ m_Log = ElxLoggerJ.getLogger(ChartRenderer.class);

    @Override
    public void render(LogicalRenderContext logicalRenderContext, RawModelElement rawModelElement) throws RenderException {
        com.elixirtech.report2.raw.model.Chart chart = (com.elixirtech.report2.raw.model.Chart)rawModelElement;
        if (chart.isVisible()) {
            Rectangle rectangle = ChartRenderer.buildRect(chart);
            rectangle.setCurvedClip(true);
            rectangle.setPaddedClip(true);
            Chart chart2 = ChartRenderer.getChartModel(chart);
            if (chart2 == null) {
                return;
            }
            AbstractChartRenderer abstractChartRenderer = ChartRenderFactory.getRenderer(chart2);
            try {
                DataTable dataTable = ChartRenderer.getDataTable(logicalRenderContext, chart);
                DatasetHolder datasetHolder = ChartDataFactory.getDatasetHolder(dataTable, (IChart)chart2);
                JFreeChart jFreeChart = abstractChartRenderer.getChart((Object)logicalRenderContext, datasetHolder);
                java.awt.Rectangle rectangle2 = this.getInsetBorder(chart);
                int n = rectangle2.width / 20;
                int n2 = rectangle2.height / 20;
                double d = (double)chart.getImageResolution() / 72.0;
                int n3 = (int)((double)n * d);
                int n4 = (int)((double)n2 * d);
                if (n3 > 0 && n4 > 0) {
                    BufferedImage bufferedImage = new BufferedImage(n3, n4, 2);
                    Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
                    Color color = chart2.getBackgroundColor();
                    if (color != null) {
                        graphics2D.setColor(color);
                        graphics2D.fill(new java.awt.Rectangle(0, 0, n3, n4));
                    }
                    graphics2D.scale(d, d);
                    jFreeChart.draw(graphics2D, (Rectangle2D)new java.awt.Rectangle(0, 0, n, n2));
                    graphics2D.dispose();
                    this.setImage(rectangle, chart, rectangle2, bufferedImage);
                }
            }
            catch (Exception exception) {
                m_Log.warn((Object)("Error in chart rendering: " + exception), (Throwable)exception);
            }
            RenderUtil.growShrinkRectangle(rectangle);
            logicalRenderContext.addElement(rectangle);
        }
    }

    private static DataTable getDataTable(LogicalRenderContext logicalRenderContext, com.elixirtech.report2.raw.model.Chart chart) throws DataException {
        DataTable dataTable;
        String string = chart.getDataSource();
        String string2 = chart.getDataRange();
        Section section = chart.getChunk().getSection();
        String string3 = section.getDataSource();
        if (StringUtil.isEmpty(string) || string.equals(string3)) {
            Data data = logicalRenderContext.getData();
            if ("All".equals(string2)) {
                dataTable = data.getDataTable();
            } else if ("Group".equals(string2)) {
                DataTable dataTable2 = data.getDataTable();
                GroupNode groupNode = data.getGroup();
                int n = groupNode.getStart();
                int n2 = groupNode.getStop();
                dataTable = dataTable2.subTable(n, n2 - n + 1);
            } else {
                DataTable dataTable3 = data.getDataTable();
                int n = data.getRecordIndex();
                dataTable = dataTable3.subTable(n, 1);
            }
        } else {
            DataRecord[] dataRecordArray;
            IDataCacheManager iDataCacheManager = RenderContainer.get(IDataCacheManager.class);
            Object object = iDataCacheManager.getCacheName(string);
            IDataCache iDataCache = null;
            boolean bl = false;
            if (iDataCacheManager.hasCache(object)) {
                iDataCache = iDataCacheManager.getCache(object);
                bl = true;
            } else {
                dataRecordArray = new DataHolder((String)object);
                iDataCache = iDataCacheManager.loadCache((String)object, dataRecordArray.getProperties());
            }
            if ("All".equals(string2) || "Group".equals(string2)) {
                dataTable = DataTable.build(iDataCache);
            } else {
                dataRecordArray = new DataRecord[]{iDataCache.getRecord()};
                dataTable = new DataTable(string, iDataCache.getSchema(), dataRecordArray);
            }
            if (!bl && iDataCache.hasParameters()) {
                iDataCacheManager.removeCache(object);
            }
        }
        return dataTable;
    }

    public static JFreeChart buildChart(final LogicalRenderContext logicalRenderContext, final com.elixirtech.report2.raw.model.Chart chart) {
        return AccessController.doPrivileged(new PrivilegedAction<JFreeChart>(){

            @Override
            public JFreeChart run() {
                Chart chart2 = ChartRenderer.getChartModel(chart);
                if (chart2 != null) {
                    try {
                        AbstractChartRenderer abstractChartRenderer = ChartRenderFactory.getRenderer(chart2);
                        DataTable dataTable = ChartRenderer.getDataTable(logicalRenderContext, chart);
                        DatasetHolder datasetHolder = ChartDataFactory.getDatasetHolder(dataTable, (IChart)chart2);
                        JFreeChart jFreeChart = abstractChartRenderer.getChart((Object)logicalRenderContext, datasetHolder);
                        return jFreeChart;
                    }
                    catch (Exception exception) {
                        m_Log.error((Object)("Error building chart: " + exception), (Throwable)exception);
                    }
                }
                return null;
            }
        });
    }

    public static Chart getChartModel(com.elixirtech.report2.raw.model.Chart chart) {
        Chart chart2 = chart.getCachedChart();
        if (chart2 == null) {
            Document document = chart.getDocument();
            ChartSAX chartSAX = new ChartSAX();
            SAXOutputter sAXOutputter = new SAXOutputter(chartSAX);
            try {
                sAXOutputter.output(document);
            }
            catch (JDOMException jDOMException) {
                m_Log.error((Object)("Unable to prepare chart: " + jDOMException), (Throwable)jDOMException);
                return null;
            }
            chart2 = (Chart)chartSAX.getObject();
            chart2.loaded();
            chart.setCachedChart(chart2);
        }
        return chart2;
    }

    protected void setImage(Rectangle rectangle, com.elixirtech.report2.raw.model.Chart chart, java.awt.Rectangle rectangle2, BufferedImage bufferedImage) {
        Image image = new Image();
        image.setLeft(rectangle2.x);
        image.setTop(rectangle2.y);
        image.setWidth(rectangle2.width);
        image.setHeight(rectangle2.height);
        image.setRaw(chart);
        image.setPicture("CallbackImage" + m_ImageId);
        image.setSizeMode("Zoom");
        image.setHorizontalAlign(Alignment.CENTER.NAME);
        image.setVerticalAlign(Alignment.CENTER.NAME);
        ReportSubstitution reportSubstitution = new ReportSubstitution();
        image.setURL(ArgumentMap.substitute(chart.getURL(), reportSubstitution));
        image.setURLDescription(ArgumentMap.substitute(chart.getURLDescription(), reportSubstitution));
        image.setURLTarget(ArgumentMap.substitute(chart.getURLTarget(), reportSubstitution));
        ++m_ImageId;
        image.setImage(bufferedImage);
        rectangle.addLogicalElement(image);
    }

    @Override
    protected ElxLoggerJ getLog() {
        return m_Log;
    }
}

