/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.report2.logical.renderer;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.arch.StringUtil;
import com.elixirtech.chart2.data.ChartDataFactory;
import com.elixirtech.chart2.data.DataUtil;
import com.elixirtech.chart2.model.CategoryType;
import com.elixirtech.chart2.model.ChartType;
import com.elixirtech.chart2.model.CompositeChart;
import com.elixirtech.chart2.model.CompositeChartSAX;
import com.elixirtech.chart2.model.CompositeChartType;
import com.elixirtech.chart2.model.Legend;
import com.elixirtech.chart2.model.SubPlot;
import com.elixirtech.chart2.model.Title;
import com.elixirtech.chart2.renderer.AbstractChartRenderer;
import com.elixirtech.chart2.renderer.ComboChartRenderer;
import com.elixirtech.chart2.renderer.DatasetHolders;
import com.elixirtech.chart2.renderer.MultiAxisChartRenderer;
import com.elixirtech.data2.ArgumentMap;
import com.elixirtech.data2.Data;
import com.elixirtech.data2.DataException;
import com.elixirtech.data2.DataRecord;
import com.elixirtech.data2.DataTable;
import com.elixirtech.data2.GroupNode;
import com.elixirtech.jdom.Document;
import com.elixirtech.jdom.JDOMException;
import com.elixirtech.jdom.output.SAXOutputter;
import com.elixirtech.js.JavaScriptEngine;
import com.elixirtech.report2.RenderContainer;
import com.elixirtech.report2.RenderException;
import com.elixirtech.report2.data.IDataCache;
import com.elixirtech.report2.data.IDataCacheManager;
import com.elixirtech.report2.logical.DataHolder;
import com.elixirtech.report2.logical.LogicalRenderContext;
import com.elixirtech.report2.logical.RenderUtil;
import com.elixirtech.report2.logical.ReportSubstitution;
import com.elixirtech.report2.logical.model.Image;
import com.elixirtech.report2.logical.model.Rectangle;
import com.elixirtech.report2.logical.renderer.BasicLogicalRenderer;
import com.elixirtech.report2.raw.constants.Alignment;
import com.elixirtech.report2.raw.model.DataScope;
import com.elixirtech.report2.raw.model.IControlSourceHolder;
import com.elixirtech.report2.raw.model.RawModelElement;
import com.elixirtech.report2.raw.model.Section;
import com.elixirtech.sax.IBean;
import com.elixirtech.util.FileUtil;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.List;
import org.apache.batik.dom.GenericDOMImplementation;
import org.apache.batik.svggen.SVGGraphics2D;
import org.jfree.chart.JFreeChart;
import org.w3c.dom.DOMImplementation;

public class CompositeChartRenderer
extends BasicLogicalRenderer {
    private static int m_ImageId = 1000;
    private static ElxLoggerJ m_Log = ElxLoggerJ.getLogger(CompositeChartRenderer.class);

    @Override
    public void render(LogicalRenderContext logicalRenderContext, RawModelElement rawModelElement) throws RenderException {
        com.elixirtech.report2.raw.model.CompositeChart compositeChart = (com.elixirtech.report2.raw.model.CompositeChart)rawModelElement;
        if (compositeChart.isVisible()) {
            Rectangle rectangle = CompositeChartRenderer.buildRect(compositeChart);
            rectangle.setCurvedClip(true);
            rectangle.setPaddedClip(true);
            CompositeChart compositeChart2 = this.getChart(compositeChart);
            if (compositeChart2 == null) {
                m_Log.error((Object)"No Composite Chart extracted");
                throw new RenderException("No Composite Chart extracted");
            }
            String string = compositeChart2.getCategory();
            DatasetHolders datasetHolders = new DatasetHolders();
            try {
                Object object;
                IBean iBean;
                IBean iBean2;
                String string2;
                Object object2;
                DataTable[] dataTableArray = CompositeChartRenderer.getDataTables(logicalRenderContext, compositeChart, compositeChart2);
                CompositeChartType compositeChartType = (CompositeChartType)compositeChart2.getChartType();
                boolean bl = compositeChartType.isInverted();
                boolean bl2 = compositeChartType.isRetainKeyOrder();
                for (int i = 0; i < dataTableArray.length; ++i) {
                    object2 = compositeChart2.getSubPlot(i);
                    string2 = ((SubPlot)object2).getType();
                    iBean2 = ((SubPlot)object2).getChartType();
                    if (iBean2 instanceof CategoryType) {
                        iBean = (CategoryType)iBean2;
                        ((CategoryType)iBean).setInverted(bl);
                        ((CategoryType)iBean).setRetainKeyOrder(bl2);
                    }
                    datasetHolders.add(ChartDataFactory.getDatasetHolder(dataTableArray[i], string2, (ChartType)iBean2));
                }
                ChartType chartType = compositeChart2.getChartType();
                object2 = "";
                string2 = "";
                iBean2 = chartType.getTitle();
                iBean = chartType.getLegend();
                if (dataTableArray.length > 0) {
                    object = JavaScriptEngine.getInstance();
                    object2 = DataUtil.buildChartText((JavaScriptEngine)object, dataTableArray[0], (IControlSourceHolder)((Object)iBean2));
                    string2 = DataUtil.buildChartText((JavaScriptEngine)object, dataTableArray[0], (IControlSourceHolder)((Object)iBean));
                } else {
                    object2 = ((Title)iBean2).getControlSource().getText();
                    string2 = ((Legend)iBean).getControlSource().getText();
                }
                datasetHolders.setTitle((String)object2);
                datasetHolders.setLegend(string2);
                object = null;
                if ("Combo".equals(string)) {
                    object = new ComboChartRenderer(compositeChart2);
                } else if ("MultiAxis".equals(string)) {
                    object = new MultiAxisChartRenderer(compositeChart2);
                }
                JFreeChart jFreeChart = ((AbstractChartRenderer)object).getChart((Object)logicalRenderContext, datasetHolders);
                if (jFreeChart == null) {
                    m_Log.error((Object)"No Composite Chart created");
                    throw new RenderException("No Composite Chart created");
                }
                java.awt.Rectangle rectangle2 = this.getInsetBorder(compositeChart);
                int n = rectangle2.width / 20;
                int n2 = rectangle2.height / 20;
                double d = (double)compositeChart.getImageResolution() / 72.0;
                int n3 = (int)((double)n * d);
                int n4 = (int)((double)n2 * d);
                if (n3 > 0 && n4 > 0) {
                    BufferedImage bufferedImage = new BufferedImage(n3, n4, 2);
                    Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
                    Color color = compositeChart2.getBackgroundColor();
                    if (color != null) {
                        graphics2D.setColor(color);
                        graphics2D.setColor(Color.YELLOW);
                        graphics2D.fill(new java.awt.Rectangle(0, 0, n3, n4));
                    }
                    graphics2D.fill(new java.awt.Rectangle(0, 0, n3, n4));
                    graphics2D.scale(d, d);
                    jFreeChart.draw(graphics2D, (Rectangle2D)new java.awt.Rectangle(0, 0, n, n2));
                    graphics2D.dispose();
                    this.setImage(rectangle, compositeChart, rectangle2, bufferedImage);
                }
                RenderUtil.growShrinkRectangle(rectangle);
                logicalRenderContext.addElement(rectangle);
            }
            catch (Exception exception) {
                m_Log.warn((Object)("Error in chart rendering: " + exception), (Throwable)exception);
            }
        }
    }

    protected void setImage(Rectangle rectangle, com.elixirtech.report2.raw.model.CompositeChart compositeChart, java.awt.Rectangle rectangle2, BufferedImage bufferedImage) {
        Image image = new Image();
        image.setLeft(rectangle2.x);
        image.setTop(rectangle2.y);
        image.setWidth(rectangle2.width);
        image.setHeight(rectangle2.height);
        image.setRaw(compositeChart);
        image.setPicture("CCI" + m_ImageId);
        image.setSizeMode("Zoom");
        image.setHorizontalAlign(Alignment.CENTER.NAME);
        image.setVerticalAlign(Alignment.CENTER.NAME);
        ReportSubstitution reportSubstitution = new ReportSubstitution();
        image.setURL(ArgumentMap.substitute(compositeChart.getURL(), reportSubstitution));
        image.setURLDescription(ArgumentMap.substitute(compositeChart.getURLDescription(), reportSubstitution));
        image.setURLTarget(ArgumentMap.substitute(compositeChart.getURLTarget(), reportSubstitution));
        ++m_ImageId;
        image.setImage(bufferedImage);
        rectangle.addLogicalElement(image);
    }

    private static DataTable getDataTable(LogicalRenderContext logicalRenderContext, String string, DataScope dataScope) throws DataException {
        DataTable dataTable = null;
        String string2 = dataScope.getDataSourceName();
        String string3 = dataScope.getRange();
        if (StringUtil.isEmpty(string2) || string2.equals(string)) {
            Data data = logicalRenderContext.getData();
            DataTable dataTable2 = data.getDataTable();
            if ("All".equals(string3)) {
                dataTable = dataTable2;
            } else if ("Group".equals(string3)) {
                GroupNode groupNode = data.getGroup();
                int n = groupNode.getStart();
                int n2 = groupNode.getStop();
                dataTable = dataTable2.subTable(n, n2 - n + 1);
            } else {
                int n = data.getRecordIndex();
                dataTable = dataTable2.subTable(n, 1);
            }
        } else {
            DataRecord[] dataRecordArray;
            IDataCacheManager iDataCacheManager = RenderContainer.get(IDataCacheManager.class);
            Object object = iDataCacheManager.getCacheName(string2);
            IDataCache iDataCache = null;
            boolean bl = false;
            if (iDataCacheManager.hasCache(object)) {
                iDataCache = iDataCacheManager.getCache(object);
                bl = true;
            } else {
                dataRecordArray = new DataHolder((String)object);
                iDataCache = iDataCacheManager.loadCache((String)object, dataRecordArray.getProperties());
            }
            if ("All".equals(string3) || "Group".equals(string3)) {
                dataTable = DataTable.build(iDataCache);
            } else {
                dataRecordArray = new DataRecord[]{iDataCache.getRecord()};
                dataTable = new DataTable(string2, iDataCache.getSchema(), dataRecordArray);
            }
            if (!bl && iDataCache.hasParameters()) {
                iDataCacheManager.removeCache(object);
            }
        }
        return dataTable;
    }

    private static DataTable[] getDataTables(LogicalRenderContext logicalRenderContext, com.elixirtech.report2.raw.model.CompositeChart compositeChart, CompositeChart compositeChart2) throws DataException {
        Section section = compositeChart.getChunk().getSection();
        String string = section.getDataSource();
        List<SubPlot> list = compositeChart2.getSubPlotList();
        int n = list.size();
        DataTable[] dataTableArray = new DataTable[n];
        for (int i = 0; i < n; ++i) {
            SubPlot subPlot = list.get(i);
            DataScope dataScope = subPlot.getDataScope();
            dataTableArray[i] = CompositeChartRenderer.getDataTable(logicalRenderContext, string, dataScope);
        }
        return dataTableArray;
    }

    public CompositeChart getChart(com.elixirtech.report2.raw.model.CompositeChart compositeChart) {
        CompositeChart compositeChart2 = compositeChart.getCachedCompositeChart();
        if (compositeChart2 == null) {
            Document document = compositeChart.getDocument();
            CompositeChartSAX compositeChartSAX = new CompositeChartSAX();
            SAXOutputter sAXOutputter = new SAXOutputter(compositeChartSAX);
            try {
                sAXOutputter.output(document);
            }
            catch (JDOMException jDOMException) {
                m_Log.error((Object)("Unable to prepare chart: " + jDOMException), (Throwable)jDOMException);
                return null;
            }
            compositeChart2 = (CompositeChart)compositeChartSAX.getObject();
            compositeChart2.loaded();
            compositeChart.setCachedCompositeChart(compositeChart2);
        }
        return compositeChart2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void renderChart(JFreeChart jFreeChart, File file) {
        DOMImplementation dOMImplementation = GenericDOMImplementation.getDOMImplementation();
        org.w3c.dom.Document document = dOMImplementation.createDocument("http://www.w3.org/2000/svg", "svg", null);
        SVGGraphics2D sVGGraphics2D = new SVGGraphics2D(document);
        Rectangle2D.Double double_ = new Rectangle2D.Double(0.0, 0.0, 400.0, 300.0);
        OutputStreamWriter outputStreamWriter = null;
        try {
            jFreeChart.draw((Graphics2D)sVGGraphics2D, (Rectangle2D)double_);
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, "UTF-8");
            sVGGraphics2D.stream((Writer)outputStreamWriter, true);
        }
        catch (IOException iOException) {
            FileUtil.close(outputStreamWriter);
            catch (Throwable throwable) {
                FileUtil.close(outputStreamWriter);
                throw throwable;
            }
        }
        FileUtil.close(outputStreamWriter);
    }

    @Override
    protected ElxLoggerJ getLog() {
        return m_Log;
    }
}

