/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.report2.logical.renderer;

import com.elixirtech.report2.logical.model.LogicalElement;
import com.elixirtech.report2.logical.model.Text;
import com.elixirtech.report2.raw.model.Field;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;

public class FieldCache {
    private Map<Field, FieldInfo> m_Map = new WeakHashMap<Field, FieldInfo>();
    private static final int MAX_ENTRIES = 10;

    public void store(Field field, String string, List<LogicalElement> list) {
        if (this.dontCache(string)) {
            return;
        }
        FieldInfo fieldInfo = this.m_Map.get(field);
        if (fieldInfo != null && fieldInfo.getModificationCount() == field.getModificationCount()) {
            fieldInfo.add(string, list);
        } else {
            fieldInfo = new FieldInfo(field);
            fieldInfo.add(string, list);
            this.m_Map.put(field, fieldInfo);
        }
    }

    public void remove(Field field) {
        this.m_Map.remove(field);
    }

    public List<LogicalElement> lookup(Field field, String string) {
        if (this.dontCache(string)) {
            return null;
        }
        FieldInfo fieldInfo = this.m_Map.get(field);
        if (fieldInfo != null && fieldInfo.getModificationCount() == field.getModificationCount()) {
            return fieldInfo.getTextList(string);
        }
        return null;
    }

    public void dispose() {
        this.m_Map.clear();
        this.m_Map = null;
    }

    protected boolean dontCache(String string) {
        return string.contains("${#}") || string.contains("${##}");
    }

    private static List<LogicalElement> cloneList(List<LogicalElement> list) {
        ArrayList<LogicalElement> arrayList = new ArrayList<LogicalElement>();
        for (LogicalElement logicalElement : list) {
            Text text = (Text)logicalElement;
            Text text2 = new Text();
            text2.copyEssentialsFrom(text);
            arrayList.add(text2);
        }
        return arrayList;
    }

    private static class FieldInfo {
        private int m_ModificationCount;
        private Map<String, List<LogicalElement>> m_StringMap = new LRUMap();

        public FieldInfo(Field field) {
            this.m_ModificationCount = field.getModificationCount();
        }

        public void add(String string, List<LogicalElement> list) {
            this.m_StringMap.put(string, FieldCache.cloneList(list));
        }

        public List<LogicalElement> getTextList(String string) {
            List<LogicalElement> list = this.m_StringMap.get(string);
            if (list != null) {
                list = FieldCache.cloneList(list);
            }
            return list;
        }

        public int getModificationCount() {
            return this.m_ModificationCount;
        }
    }

    private static class LRUMap
    extends LinkedHashMap<String, List<LogicalElement>> {
        LRUMap() {
            super(10, 0.75f, true);
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, List<LogicalElement>> entry) {
            return this.size() > 10;
        }
    }
}

