/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.report2.logical.renderer;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.report2.data.ControlSourceProcessor;
import com.elixirtech.report2.logical.LogicalRenderContext;
import com.elixirtech.report2.logical.RenderStack;
import com.elixirtech.report2.logical.model.Empty;
import com.elixirtech.report2.logical.model.Grid;
import com.elixirtech.report2.logical.renderer.BasicLogicalRenderer;
import com.elixirtech.report2.raw.model.ControlSource;
import com.elixirtech.report2.raw.model.Format;
import com.elixirtech.report2.raw.model.FormatUtil;
import com.elixirtech.report2.raw.model.RawModelElement;
import com.elixirtech.report2.script.ScriptEngine;
import java.awt.Rectangle;
import java.util.Locale;

public class GridRenderer
extends BasicLogicalRenderer {
    private static ElxLoggerJ m_Log = ElxLoggerJ.getLogger(GridRenderer.class);

    @Override
    public void render(LogicalRenderContext logicalRenderContext, RawModelElement rawModelElement) {
        com.elixirtech.report2.raw.model.Grid grid = (com.elixirtech.report2.raw.model.Grid)rawModelElement;
        if (grid.isVisible()) {
            boolean bl;
            String string = this.getValue(logicalRenderContext, grid);
            boolean bl2 = bl = string != null && string.length() > 0;
            if (!bl) {
                Rectangle rectangle = this.getInsetBorder(grid);
                Empty empty = new Empty();
                empty.setRaw(grid);
                empty.setId(grid.getName());
                empty.setLeft(rectangle.x);
                empty.setWidth(rectangle.width);
                empty.setTop(rectangle.y);
                if (!grid.isShrinkable()) {
                    empty.setHeight(rectangle.height);
                }
                logicalRenderContext.addElement(empty);
                return;
            }
            com.elixirtech.report2.logical.model.Rectangle rectangle = GridRenderer.buildRect(grid);
            if (bl) {
                Grid grid2 = new Grid();
                this.insetBorder(grid, grid2);
                grid2.setRaw(grid);
                grid2.setWritingMode(grid.getWritingMode());
                grid2.setGlyphOrientation(grid.getGlyphOrientation());
                grid2.setLineGridMode(grid.getLineGridMode());
                grid2.setLineGridProgression(grid.getLineGridProgression());
                grid2.setFontBold(grid.isFontBold());
                grid2.setFontColor(grid.getFontColor());
                grid2.setFontItalic(grid.isFontItalic());
                grid2.setFontName(grid.getFontName());
                grid2.setFontSize(grid.getFontSize());
                grid2.setFontUnderline(grid.isFontUnderline());
                grid2.setFontStrikethrough(grid.isFontStrikethrough());
                grid2.setTextAlign(grid.getTextAlign());
                grid2.setText(string);
                grid2.setURL(grid.getURL());
                grid2.setURLTarget(grid.getURLTarget());
                grid2.setURLDescription(grid.getURLDescription());
                grid2.setBoxBorderColor(grid.getBoxBorderColor());
                grid2.setBoxBorderSide(grid.isBoxBorderSide());
                grid2.setBoxBorderTop(grid.isBoxBorderTop());
                grid2.setBoxBorderBottom(grid.isBoxBorderBottom());
                grid2.setBoxBorderHeight(grid.getBoxBorderHeight());
                grid2.setCharacterOffsetX(grid.getCharacterOffsetX());
                grid2.setCharacterOffsetY(grid.getCharacterOffsetY());
                rectangle.addLogicalElement(grid2);
            }
            logicalRenderContext.addElement(rectangle);
        } else {
            ControlSource controlSource = grid.getControlSource();
            if ("Script".equals(controlSource.getType())) {
                ScriptEngine scriptEngine = RenderStack.current().getScriptEngine();
                scriptEngine.evaluate(controlSource.getText());
            }
        }
    }

    protected String getValue(LogicalRenderContext logicalRenderContext, com.elixirtech.report2.raw.model.Grid grid) {
        Format format;
        Object object = ControlSourceProcessor.getData(grid.getControlSource());
        if (object != null && (format = grid.getFormat()) != null && format.getType() != "None") {
            java.text.Format format2 = format.getFormatter();
            if (format2 == null) {
                Locale locale = grid.getLocale();
                format2 = FormatUtil.buildFormatter(format, locale);
                format.setFormatter(format2);
            }
            if (format2 != null) {
                object = format2.format(object);
            }
        }
        if (object != null) {
            return String.valueOf(object);
        }
        return null;
    }

    @Override
    protected ElxLoggerJ getLog() {
        return m_Log;
    }
}

