/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.report2.logical.renderer;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.data2.ArgumentMap;
import com.elixirtech.report2.logical.LogicalRenderContext;
import com.elixirtech.report2.logical.ReportSubstitution;
import com.elixirtech.report2.logical.model.BodyPart;
import com.elixirtech.report2.logical.model.GroupHeader;
import com.elixirtech.report2.logical.renderer.IChunkRenderer;
import com.elixirtech.report2.logical.renderer.TOCElementRenderer;
import com.elixirtech.report2.raw.model.Chunk;

public class GroupHeaderRenderer
implements IChunkRenderer {
    private static ElxLoggerJ m_Log = ElxLoggerJ.getLogger(GroupHeaderRenderer.class);

    @Override
    public BodyPart render(LogicalRenderContext logicalRenderContext, Chunk chunk) {
        com.elixirtech.report2.raw.model.GroupHeader groupHeader = (com.elixirtech.report2.raw.model.GroupHeader)chunk;
        if (groupHeader.isVisible()) {
            GroupHeader groupHeader2 = new GroupHeader();
            groupHeader2.setRaw(groupHeader);
            groupHeader2.setWidth(logicalRenderContext.getColumnWidth());
            groupHeader2.setHeight(groupHeader.getHeight());
            groupHeader2.setBackgroundColor(groupHeader.getBackgroundColor());
            groupHeader2.setKeepTogether(groupHeader.isKeepTogether());
            groupHeader2.setKeepWithNext(groupHeader.isKeepWithNext());
            groupHeader2.setTableOfContents(groupHeader.getRepeatNo() == 1 ? groupHeader.isTableOfContents() : false);
            ReportSubstitution reportSubstitution = new ReportSubstitution();
            String string = ArgumentMap.substitute(groupHeader.getURL(), reportSubstitution);
            String string2 = ArgumentMap.substitute(groupHeader.getURLDescription(), reportSubstitution);
            String string3 = ArgumentMap.substitute(groupHeader.getURLTarget(), reportSubstitution);
            groupHeader2.setURL(string);
            groupHeader2.setURLDescription(string2);
            groupHeader2.setURLTarget(string3);
            groupHeader2.setRepeatSection(groupHeader.isRepeatSection());
            groupHeader2.setForceNewPage(groupHeader.getForceNewPage());
            if (groupHeader2.isTableOfContents()) {
                groupHeader2.setTOCTitle(TOCElementRenderer.processControlSource(logicalRenderContext, groupHeader));
                groupHeader2.setTOCLevel(logicalRenderContext.getTOCLevel());
                logicalRenderContext.incTOCLevel();
            }
            groupHeader2.setCaption(groupHeader.getCaption());
            groupHeader2.setVerticalAlign(groupHeader.getVerticalAlign());
            logicalRenderContext.renderChildren(groupHeader, groupHeader2);
            return groupHeader2;
        }
        return null;
    }

    protected ElxLoggerJ getLog() {
        return m_Log;
    }
}

