/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.report2.logical.renderer;

import com.elixirtech.graphics.font.IFontMeasurer;
import com.elixirtech.report2.logical.model.Image;
import com.elixirtech.report2.logical.model.LogicalElement;
import com.elixirtech.report2.logical.model.Rectangle;
import com.elixirtech.report2.logical.model.Text;
import com.elixirtech.report2.raw.model.RawModelElement;
import com.elixirtech.ui.StandardColor;
import java.awt.Color;

public class Label {
    private Rectangle m_Rectangle = new Rectangle();
    private Text m_Text;
    private Image m_Image;
    private String m_IconAlignment;

    public static int pixelRound(double d) {
        double d2 = d / 20.0;
        d2 = Math.ceil(d2);
        return (int)d2 * 20;
    }

    public Rectangle getRectangle() {
        return this.m_Rectangle;
    }

    public LogicalElement getLogicalElement(RawModelElement rawModelElement) {
        this.m_Rectangle.setRaw(rawModelElement);
        if (this.m_Text != null) {
            this.m_Text.setRaw(rawModelElement);
        }
        if (this.m_Image != null) {
            this.m_Image.setRaw(rawModelElement);
        }
        return this.m_Rectangle;
    }

    public void setTop(int n) {
        this.m_Rectangle.setTop(n);
        int n2 = this.m_Rectangle.getTopMargin();
        if (this.m_Text != null) {
            this.m_Text.setTop(n + n2);
        }
        if (this.m_Image != null) {
            this.m_Image.setTop(n + n2);
        }
    }

    public int getHeight() {
        return this.m_Rectangle.getHeight();
    }

    public int getWidth() {
        return this.m_Rectangle.getWidth();
    }

    public void setLeft(int n) {
        int n2 = this.m_Rectangle.getLeft();
        int n3 = n - n2;
        this.m_Rectangle.setLeft(n);
        if (this.m_Text != null) {
            this.m_Text.setLeft(this.m_Text.getLeft() + n3);
        }
        if (this.m_Image != null) {
            this.m_Image.setLeft(this.m_Image.getLeft() + n3);
        }
    }

    public int getLeft() {
        return this.m_Rectangle.getLeft();
    }

    public void setBackgroundColor(String string) {
        this.m_Rectangle.setBackgroundColor(string);
    }

    public void setBackgroundColor(Color color) {
        this.m_Rectangle.setBackgroundColor(StandardColor.getColorName(color));
    }

    public void setFontColor(String string) {
        if (this.m_Text != null) {
            this.m_Text.setFontColor(string);
        }
    }

    public void setFontColor(Color color) {
        if (this.m_Text != null) {
            this.m_Text.setFontColor(StandardColor.getColorName(color));
        }
    }

    public void setFontName(String string) {
        if (this.m_Text != null) {
            this.m_Text.setFontName(string);
        }
    }

    public void setFontBold(boolean bl) {
        if (this.m_Text != null) {
            this.m_Text.setFontBold(bl);
        }
    }

    public void setFontItalic(boolean bl) {
        if (this.m_Text != null) {
            this.m_Text.setFontItalic(bl);
        }
    }

    public void setFontSize(int n) {
        if (this.m_Text != null) {
            this.m_Text.setFontSize(n);
        }
    }

    public void setFontUnderline(boolean bl) {
        if (this.m_Text != null) {
            this.m_Text.setFontUnderline(bl);
        }
    }

    public void setFontStrikethrough(boolean bl) {
        if (this.m_Text != null) {
            this.m_Text.setFontStrikethrough(bl);
        }
    }

    public void setText(IFontMeasurer iFontMeasurer, String string, String string2) {
        this.m_Text = new Text();
        this.m_Text.setText(string);
        this.m_Text.setWidth(Label.pixelRound(iFontMeasurer.getWidth(string)));
        this.m_Text.setHeight((int)iFontMeasurer.getHeight());
        this.m_Text.setAscent((int)iFontMeasurer.getAscent());
        this.m_Text.setFontName("SansSerif");
        this.m_Text.setFontSize(12);
        this.m_Text.setFontColor("Black");
        this.m_Text.setTextAlign(string2);
    }

    public void setImage(String string, String string2) {
        this.m_Image = new Image();
        this.m_Image.setPicture(string);
        this.m_Image.setSizeMode("Zoom");
        this.m_Image.setWidth(320);
        this.m_Image.setHeight(320);
        this.m_IconAlignment = string2;
    }

    public void layout() {
        int n = 0;
        int n2 = 0;
        if (this.m_Text != null) {
            this.m_Rectangle.addLogicalElement(this.m_Text);
            n += this.m_Text.getWidth();
            n2 = Math.max(n2, this.m_Text.getHeight());
        }
        if (this.m_Image != null) {
            this.m_Rectangle.addLogicalElement(this.m_Image);
            n += this.m_Image.getWidth();
            n2 = Math.max(n2, this.m_Image.getHeight());
        }
        int n3 = this.m_Rectangle.getBorderWidth();
        if ("None".equals(this.m_Rectangle.getBorderStyle())) {
            n3 = 0;
        }
        int n4 = this.m_Rectangle.getPaddingLeft();
        int n5 = this.m_Rectangle.getPaddingRight();
        int n6 = this.m_Rectangle.getPaddingTop();
        int n7 = this.m_Rectangle.getPaddingBottom();
        if (n3 > 0) {
            if (this.m_Rectangle.isBorderLeft()) {
                n4 += n3;
            }
            if (this.m_Rectangle.isBorderRight()) {
                n5 += n3;
            }
            if (this.m_Rectangle.isBorderTop()) {
                n6 += n3;
            }
            if (this.m_Rectangle.isBorderBottom()) {
                n7 += n3;
            }
        }
        this.m_Rectangle.setWidth(n += n4 + n5);
        this.m_Rectangle.setHeight(n2 += n6 + n7);
        if (this.m_Image != null) {
            this.m_Image.setTop(n6);
            if (this.m_Text != null) {
                this.m_Text.setTop(n6);
                if ("Left".equals(this.m_IconAlignment)) {
                    this.m_Image.setLeft(n4);
                    this.m_Text.setLeft(n4 + this.m_Image.getWidth());
                } else {
                    this.m_Text.setLeft(n4);
                    this.m_Image.setLeft(n4 + this.m_Text.getWidth());
                }
            } else if ("Right".equals(this.m_IconAlignment)) {
                this.m_Image.setLeft(n - n5 - this.m_Image.getWidth());
            }
        } else if (this.m_Text != null) {
            this.m_Text.setTop(n6);
            this.m_Text.setLeft(n4);
        }
    }

    public void setWidth(int n) {
        int n2 = this.m_Rectangle.getWidth();
        int n3 = n - n2;
        this.m_Rectangle.setWidth(n);
        if (this.m_Text != null) {
            this.m_Text.setWidth(this.m_Text.getWidth() + n3);
        }
        if ("Right".equals(this.m_IconAlignment)) {
            this.m_Image.setLeft(this.m_Image.getLeft() + n3);
        }
    }

    public void setHeight(int n) {
        this.m_Rectangle.setHeight(n);
    }
}

