/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.report2.logical.renderer;

import com.elixirtech.arch.Elixir;
import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.report2.IRenderFactory;
import com.elixirtech.report2.RenderException;
import com.elixirtech.report2.logical.LogicalRenderContext;
import com.elixirtech.report2.logical.renderer.BasicLogicalRenderer;
import com.elixirtech.report2.logical.renderer.ILogicalRenderer;
import com.elixirtech.report2.logical.renderer.IModelViewRenderer;
import com.elixirtech.report2.raw.model.ModelView;
import com.elixirtech.report2.raw.model.RawElement;
import com.elixirtech.report2.raw.model.RawModelElement;

public class ModelViewRenderer
extends BasicLogicalRenderer {
    private static ElxLoggerJ m_Log = ElxLoggerJ.getLogger(ModelViewRenderer.class);

    @Override
    public void render(LogicalRenderContext logicalRenderContext, RawModelElement rawModelElement) throws RenderException {
        ModelView modelView = (ModelView)rawModelElement;
        if (modelView.isVisible()) {
            RawElement rawElement = modelView.getModel();
            if (rawElement != null) {
                IRenderFactory iRenderFactory = (IRenderFactory)Elixir.get(IRenderFactory.class);
                ILogicalRenderer iLogicalRenderer = iRenderFactory.getLogicalRenderer(((RawModelElement)rawElement).getTagName());
                if (iLogicalRenderer instanceof IModelViewRenderer) {
                    ((IModelViewRenderer)((Object)iLogicalRenderer)).renderViews(logicalRenderContext, modelView);
                } else {
                    iLogicalRenderer.render(logicalRenderContext, rawElement);
                }
            } else {
                m_Log.warn((Object)("ModelView " + modelView.getName() + " contains no Model"));
            }
        }
    }

    @Override
    protected ElxLoggerJ getLog() {
        return m_Log;
    }
}

