/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.report2.logical.renderer;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.arch.StringUtil;
import com.elixirtech.i18n.Name;
import com.elixirtech.property.IStyle;
import com.elixirtech.report2.RenderException;
import com.elixirtech.report2.data.IDataCacheManager;
import com.elixirtech.report2.engine.SectionEngine;
import com.elixirtech.report2.logical.DataHolder;
import com.elixirtech.report2.logical.LogicalRenderContext;
import com.elixirtech.report2.logical.RenderStack;
import com.elixirtech.report2.logical.RenderUtil;
import com.elixirtech.report2.logical.model.Body;
import com.elixirtech.report2.logical.model.BodyPart;
import com.elixirtech.report2.logical.model.Column;
import com.elixirtech.report2.logical.model.Columns;
import com.elixirtech.report2.logical.model.ILogicalElementHolder;
import com.elixirtech.report2.logical.model.ITOCElement;
import com.elixirtech.report2.logical.model.LogicalElement;
import com.elixirtech.report2.logical.model.LogicalModelElement;
import com.elixirtech.report2.logical.model.LogicalReport;
import com.elixirtech.report2.logical.model.Page;
import com.elixirtech.report2.logical.model.PageSequence;
import com.elixirtech.report2.logical.model.Rectangle;
import com.elixirtech.report2.logical.renderer.BasicLogicalRenderer;
import com.elixirtech.report2.raw.RMLUtil;
import com.elixirtech.report2.raw.model.DataSource;
import com.elixirtech.report2.raw.model.IResourceProvider;
import com.elixirtech.report2.raw.model.IStyledElement;
import com.elixirtech.report2.raw.model.PageSetup;
import com.elixirtech.report2.raw.model.RawModelElement;
import com.elixirtech.report2.raw.model.RawReport;
import com.elixirtech.report2.raw.model.Section;
import com.elixirtech.report2.raw.model.Style;
import com.elixirtech.report2.raw.model.SubReport;
import com.elixirtech.repository.RMLFileObject;
import java.util.Iterator;

public class SubReportRenderer
extends BasicLogicalRenderer {
    private static ElxLoggerJ m_Log = ElxLoggerJ.getLogger(SubReportRenderer.class);

    @Override
    public void render(LogicalRenderContext logicalRenderContext, RawModelElement rawModelElement) throws RenderException {
        try {
            SubReport subReport = (SubReport)rawModelElement;
            if (subReport.isVisible()) {
                Object object;
                Rectangle rectangle = SubReportRenderer.buildRect(subReport);
                rectangle.setCurvedClip(true);
                RenderStack renderStack = RenderStack.current();
                RawReport rawReport = null;
                Section section = null;
                IResourceProvider iResourceProvider = subReport.getResourceProvider();
                String string = subReport.getReportName();
                if (StringUtil.isEmpty(string)) {
                    section = iResourceProvider.getSection(subReport.getSectionName());
                } else {
                    object = renderStack.getFile(string);
                    if (object != null) {
                        rawReport = RMLUtil.readRML((RMLFileObject)object);
                        if (rawReport != null) {
                            rawReport = RMLUtil.deepCopy(rawReport);
                            section = rawReport.getSection(subReport.getSectionName());
                        }
                    } else {
                        throw new RenderException("Unable to locate subreport: " + string);
                    }
                }
                if (section == null) {
                    throw new RenderException("Report " + string + " has no section named " + subReport.getSectionName());
                }
                object = subReport.getDataSourceName();
                if (StringUtil.isEmpty((String)object)) {
                    object = section.getDataSource();
                }
                DataHolder dataHolder = null;
                IDataCacheManager iDataCacheManager = logicalRenderContext.getDataCacheManager();
                boolean bl = false;
                if (iDataCacheManager.hasCache(object)) {
                    dataHolder = new DataHolder(iDataCacheManager.getCache(object));
                    bl = true;
                } else {
                    dataHolder = new DataHolder((String)object);
                }
                SectionEngine sectionEngine = new SectionEngine();
                SubReportAdapter subReportAdapter = new SubReportAdapter(subReport);
                LogicalReport logicalReport = sectionEngine.render(subReportAdapter, section, dataHolder);
                this.dispose(rawReport, section);
                if (!bl) {
                    iDataCacheManager.removeCache(object);
                }
                if (logicalReport != null) {
                    LogicalModelElement logicalModelElement;
                    int n = rectangle.getLeft() + subReport.getPaddingLeft();
                    int n2 = rectangle.getLeft() + rectangle.getWidth() - subReport.getPaddingRight();
                    int n3 = rectangle.getTop() + subReport.getPaddingTop();
                    int n4 = RenderUtil.getBorderWidth(subReport);
                    if (subReport.isBorderLeft()) {
                        n += n4;
                    }
                    if (subReport.isBorderRight()) {
                        n2 -= n4;
                    }
                    if (subReport.isBorderTop()) {
                        n3 += n4;
                    }
                    int n5 = n2 - n;
                    Page page = null;
                    if (logicalReport.getPageSequenceCount() > 0 && ((PageSequence)(logicalModelElement = logicalReport.getPageSequence(0))).getPageCount() > 0) {
                        page = ((PageSequence)logicalModelElement).getPage(0);
                    }
                    if (page != null) {
                        logicalModelElement = page.getBody();
                        if (logicalModelElement != null) {
                            Iterator<BodyPart> iterator = ((Body)logicalModelElement).getBodyPartIterator();
                            while (iterator.hasNext()) {
                                BodyPart bodyPart = iterator.next();
                                if (bodyPart instanceof ITOCElement) {
                                    ITOCElement iTOCElement = (ITOCElement)((Object)bodyPart);
                                    iTOCElement.setTOCLevel(logicalRenderContext.getTOCLevel() + iTOCElement.getTOCLevel());
                                }
                                this.addBodyPart(subReport, rectangle, bodyPart, n, n3, n5);
                                n3 += this.getHeight(bodyPart);
                            }
                        } else {
                            m_Log.warn((Object)"Body is null");
                        }
                    }
                    RenderUtil.growShrinkRectangle(rectangle);
                }
                logicalRenderContext.addElement(rectangle);
            }
        }
        catch (RenderException renderException) {
            throw renderException;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    private int getHeight(BodyPart bodyPart) {
        if (bodyPart instanceof Columns) {
            int n = 0;
            Columns columns = (Columns)bodyPart;
            int n2 = columns.getColumnCount();
            for (int i = 0; i < n2; ++i) {
                n = Math.max(n, this.getHeight(columns.getColumn(i)));
            }
            return n;
        }
        return bodyPart.getHeight();
    }

    private int getHeight(Column column) {
        int n = 0;
        for (BodyPart bodyPart : column.getBodyPartList()) {
            n += bodyPart.getHeight() + bodyPart.getSpaceAfter();
        }
        return n;
    }

    private void dispose(RawReport rawReport, Section section) {
        if (rawReport != null) {
            section.setRawReport(null);
        }
    }

    protected void addBodyPart(SubReport subReport, Rectangle rectangle, BodyPart bodyPart, int n, int n2, int n3) {
        if (bodyPart instanceof Columns) {
            Columns columns = (Columns)bodyPart;
            int n4 = columns.getColumnCount();
            int n5 = n2;
            for (int i = 0; i < n4; ++i) {
                Column column = columns.getColumn(i);
                Iterator<BodyPart> iterator = column.getBodyPartIterator();
                while (iterator.hasNext()) {
                    int n6 = n + i * (column.getWidth() + column.getSpaceAfter());
                    BodyPart bodyPart2 = iterator.next();
                    this.addBodyPart(subReport, rectangle, bodyPart2, n6, n5, column.getWidth());
                }
            }
        } else {
            Object object;
            Rectangle rectangle2 = new Rectangle();
            rectangle2.setRaw(subReport);
            rectangle2.setLeft(n);
            rectangle2.setTop(n2);
            rectangle2.setWidth(n3);
            rectangle2.setHeight(bodyPart.getHeight());
            rectangle2.setBackgroundColor(bodyPart.getBackgroundColor());
            rectangle2.setKeepTogether(bodyPart.isKeepTogether());
            if (bodyPart instanceof ITOCElement && (object = (ITOCElement)((Object)bodyPart)).isTableOfContents()) {
                rectangle2.setTableOfContents(true);
                rectangle2.setTOCTitle(object.getTOCTitle());
                rectangle2.setTOCLevel(object.getTOCLevel());
            }
            object = bodyPart.getLogicalElementIterator();
            while (object.hasNext()) {
                LogicalElement logicalElement = (LogicalElement)object.next();
                this.shift(logicalElement, n, n2);
                rectangle2.addLogicalElement(logicalElement);
            }
            rectangle.addLogicalElement(rectangle2);
        }
    }

    protected void shift(LogicalElement logicalElement, int n, int n2) {
        logicalElement.setTop(logicalElement.getTop() + n2);
        logicalElement.setLeft(logicalElement.getLeft() + n);
        if (logicalElement instanceof ILogicalElementHolder) {
            Iterator<LogicalElement> iterator = ((ILogicalElementHolder)((Object)logicalElement)).getLogicalElementIterator();
            while (iterator.hasNext()) {
                this.shift(iterator.next(), n, n2);
            }
        }
    }

    @Override
    protected ElxLoggerJ getLog() {
        return m_Log;
    }

    private static class SubReportAdapter
    implements IResourceProvider,
    IStyledElement {
        private SubReport m_SubReport;
        private IResourceProvider m_ResourceProvider;

        public SubReportAdapter(SubReport subReport) {
            this.m_SubReport = subReport;
            this.m_ResourceProvider = this.m_SubReport.getResourceProvider();
        }

        @Override
        public DataSource getDataSource(String string) {
            return this.m_ResourceProvider.getDataSource(string);
        }

        @Override
        public Style getStyle(String string) {
            return this.m_ResourceProvider.getStyle(string);
        }

        @Override
        public PageSetup getPageSetup(String string) {
            return this.m_ResourceProvider.getPageSetup(string);
        }

        @Override
        public RMLFileObject getFile(String string) {
            return this.m_ResourceProvider.getFile(string);
        }

        @Override
        public Section getSection(String string) {
            return this.m_ResourceProvider.getSection(string);
        }

        @Override
        public String getProperty(String string) {
            return this.m_ResourceProvider.getProperty(string);
        }

        @Override
        public String resolveRepositoryURL(String string) {
            return this.m_ResourceProvider.resolveRepositoryURL(string);
        }

        @Override
        public String getRelativeRepositoryURL(String string) {
            return this.m_ResourceProvider.getRelativeRepositoryURL(string);
        }

        @Override
        public IStyle getStyle() {
            return this.m_SubReport.getStyle();
        }

        @Override
        public IResourceProvider getResourceProvider() {
            return this.m_ResourceProvider;
        }

        @Override
        public IStyledElement getParentStyledElement() {
            return this.m_SubReport.getParentStyledElement();
        }

        @Override
        public Object getPropertyValue(Name name) {
            return this.m_SubReport.getPropertyValue(name);
        }
    }
}

