/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.report2.logical.renderer;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.arch.StringUtil;
import com.elixirtech.data2.ArgumentMap;
import com.elixirtech.data2.olap.Measure;
import com.elixirtech.data2.olap.RootTreeNode;
import com.elixirtech.data2.olap.TreeNode;
import com.elixirtech.ensemble.cube.ITableStyle;
import com.elixirtech.ensemble.cube.TableStyle;
import com.elixirtech.graphics.font.IFontMeasurer;
import com.elixirtech.report2.logical.model.Rectangle;
import com.elixirtech.report2.logical.model.Text;
import com.elixirtech.report2.logical.renderer.Label;
import com.elixirtech.report2.raw.model.CubeColumn;
import com.elixirtech.report2.raw.model.CubeHeader;
import com.elixirtech.ui.StandardColor;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class TextTree {
    private static final int HORIZONTAL = 1;
    private static final int VERTICAL = 2;
    private String[] m_LevelTitles;
    private String m_GrandTotalTitle;
    private CubeHeader m_CubeHeader;
    private RootTreeNode m_Root;
    private IFontMeasurer m_FontMeasurer;
    private boolean m_TotalsAfter;
    private Measure[] m_Measures;
    private TextEx m_TextRoot;
    private List<TextEx> m_AllText;
    private List<TextEx> m_TextLeaves;
    private int m_Orientation;
    private boolean m_ShowHeaders = true;
    private int m_LevelCount = -1;
    static final ElxLoggerJ m_Log = ElxLoggerJ.getLogger(TextTree.class);

    public TextTree(CubeHeader cubeHeader, String string, RootTreeNode rootTreeNode, IFontMeasurer iFontMeasurer, String string2, String[] stringArray, boolean bl) {
        this(cubeHeader, string, rootTreeNode, iFontMeasurer, stringArray, bl, null);
    }

    public TextTree(CubeHeader cubeHeader, String string, RootTreeNode rootTreeNode, IFontMeasurer iFontMeasurer, String[] stringArray, boolean bl, Measure[] measureArray) {
        this.m_CubeHeader = cubeHeader;
        this.m_Root = rootTreeNode;
        this.m_FontMeasurer = iFontMeasurer;
        this.m_TotalsAfter = bl;
        this.m_Measures = measureArray;
        this.m_LevelTitles = stringArray;
        this.m_TextRoot = this.buildRootNode(this.m_Root, string);
        this.buildAll();
        this.buildLeafNodes();
        this.applyStyles();
    }

    public TextEx getRoot() {
        return this.m_TextRoot;
    }

    public void adjustColumns(int[] nArray, int[] nArray2) {
        Iterator<TextEx> iterator = this.m_TextLeaves.iterator();
        for (int i = 0; i < nArray.length; ++i) {
            TextEx textEx = iterator.next();
            textEx.setLeft(nArray[i]);
            textEx.setWidth(nArray2[i]);
        }
        this.growParents(this.m_TextRoot);
        this.constrainText();
    }

    public void mergeBorders() {
        if (this.m_Orientation == 1) {
            if (this.m_TextRoot.isBorderLeft() && this.m_TextRoot.isBorderRight()) {
                this.m_TextRoot.mergeLeftRightBorders();
            }
        } else if (this.m_TextRoot.isBorderTop() && this.m_TextRoot.isBorderBottom()) {
            this.m_TextRoot.mergeTopBottomBorders();
        }
    }

    public TableStyle getTableStyle() {
        String string = this.m_CubeHeader.getBackgroundTopLeft();
        String string2 = this.m_CubeHeader.getBackgroundBottomRight();
        Color color = null;
        Color color2 = null;
        if (StringUtil.notEmpty(string)) {
            color = StandardColor.lookup(string);
        }
        if (StringUtil.notEmpty(string2)) {
            color2 = StandardColor.lookup(string2);
        }
        if (color != null || color2 != null) {
            if (color == null) {
                assert (color2 != null);
                color = new Color(color2.getRed(), color2.getGreen(), color2.getBlue(), 0);
            } else if (color2 == null) {
                color2 = new Color(color.getRed(), color.getGreen(), color.getBlue(), 0);
            }
        }
        int n = this.m_Root.getMaxDepth();
        if (this.m_CubeHeader instanceof CubeColumn) {
            ++n;
        }
        return new TableStyle(color, color2, n);
    }

    protected void applyStyles() {
        TableStyle tableStyle = this.getTableStyle();
        if (StringUtil.isEmpty(this.m_CubeHeader.getFontColor())) {
            this.m_CubeHeader.setFontColor("Black");
        }
        this.m_TextRoot.applyStyles(this.m_CubeHeader, tableStyle, 0);
    }

    private void verify() {
        for (TextEx textEx : this.m_AllText) {
            textEx.verify();
        }
    }

    public void showHeaders(boolean bl) {
        this.m_ShowHeaders = bl;
    }

    public int getDepth() {
        int n = 0;
        Iterator<TextEx> iterator = this.m_TextLeaves.iterator();
        while (iterator.hasNext()) {
            n = Math.max(n, iterator.next().getDepth());
        }
        return n;
    }

    public void layoutHorizontal(int n) {
        this.m_Orientation = 1;
        String string = this.m_CubeHeader.getTitle();
        if (StringUtil.isEmpty(string)) {
            this.m_TextRoot.hide();
        }
        if (!this.m_ShowHeaders) {
            this.m_TextRoot.hideHeaders();
        }
        this.m_TextRoot.layoutHorizontal(0, 0, n);
        this.positionLeafNodes();
        this.growParents(this.m_TextRoot);
        this.constrainText();
    }

    public void layoutVertical(int n, int n2, int n3) {
        this.m_Orientation = 2;
        this.m_TextRoot.layoutVertical(n, n2, n3);
        int n4 = 0;
        for (TextEx textEx : this.m_TextLeaves) {
            int n5 = textEx.getLeft() + textEx.getWidth();
            if (n5 <= n4) continue;
            n4 = n5;
        }
        for (TextEx textEx : this.m_TextLeaves) {
            textEx.setLeft(n4 - textEx.getWidth());
        }
        this.constrainText();
        this.growParents(this.m_TextRoot);
    }

    private void growParents(TextEx textEx) {
        textEx.growParents(this.m_Orientation);
    }

    public Iterator<TextEx> getTextIterator() {
        this.verify();
        return this.m_AllText.iterator();
    }

    private void constrainText() {
        for (TextEx textEx : this.m_AllText) {
            textEx.constrainText();
        }
    }

    private void buildAll() {
        this.m_AllText = new ArrayList<TextEx>();
        this.m_TextRoot.buildAll(this.m_AllText);
    }

    private void buildLeafNodes() {
        this.m_TextLeaves = new ArrayList<TextEx>();
        this.m_TextRoot.buildLeaves(this.m_TextLeaves);
        for (TextEx textEx : this.m_TextLeaves) {
            textEx.setKeepTogether(true);
        }
    }

    private void positionLeafNodes() {
        if (this.m_Measures != null) {
            int n = 0;
            for (TextEx textEx : this.m_TextLeaves) {
                if (textEx.getTop() <= n) continue;
                n = textEx.getTop();
            }
            for (TextEx textEx : this.m_TextLeaves) {
                textEx.setTop(n);
                TextEx textEx2 = textEx.getParent();
                textEx2.setHeight(n - textEx2.getTop());
            }
        }
    }

    public Iterator<TextEx> getLeafIterator() {
        return this.m_TextLeaves.iterator();
    }

    public void setColumnWidth(int n, int n2, int n3) {
        TextEx textEx = this.m_TextLeaves.get(n);
        textEx.setWidth(n2);
        for (TextEx textEx2 = textEx.getParent(); textEx2 != null; textEx2 = textEx2.getParent()) {
            textEx2.setWidth(0);
        }
        this.layoutHorizontal(n3);
    }

    protected TextEx buildRootNode(TreeNode treeNode, String string) {
        TextEx textEx = this.createText(string);
        List<TreeNode> list = treeNode.getChildren();
        if (list.isEmpty()) {
            this.buildDetail(textEx, treeNode);
        } else {
            this.buildLevelDetailNode(list, textEx, treeNode);
        }
        return textEx;
    }

    protected TextEx buildNode(TreeNode treeNode, String string) {
        TextEx textEx = this.createText(string);
        List<TreeNode> list = treeNode.getChildren();
        if (list.isEmpty()) {
            this.buildDetail(textEx, treeNode);
        } else {
            this.buildLevelDetailNode(list, textEx, treeNode);
        }
        return textEx;
    }

    protected void buildDetail(TextEx textEx, TreeNode treeNode) {
        if (this.m_Measures != null) {
            for (int i = 0; i < this.m_Measures.length; ++i) {
                TextEx textEx2 = this.buildNode(treeNode, this.m_Measures[i]);
                textEx.addChild(textEx2);
            }
        }
    }

    protected void buildLevelDetailNode(List<TreeNode> list, TextEx textEx, TreeNode treeNode) {
        boolean bl = treeNode.isShowTotals();
        if (!this.m_TotalsAfter && bl) {
            this.buildLevelResultNode(textEx, treeNode);
        }
        for (TreeNode treeNode2 : list) {
            TextEx textEx2 = this.buildNode(treeNode2, treeNode2.getName());
            textEx.addChild(textEx2);
        }
        if (this.m_TotalsAfter && bl) {
            this.buildLevelResultNode(textEx, treeNode);
        }
    }

    protected void buildLevelResultNode(TextEx textEx, TreeNode treeNode) {
        int n = treeNode.getDepth();
        TextEx textEx2 = this.createText(this.m_LevelTitles[n]);
        textEx2.setSignificant(true);
        textEx.addChild(textEx2);
        if (this.m_Measures != null) {
            for (int i = 0; i < this.m_Measures.length; ++i) {
                TextEx textEx3 = this.buildNode(treeNode, this.m_Measures[i]);
                textEx2.addChild(textEx3);
            }
        }
    }

    protected TextEx buildNode(TreeNode treeNode, Measure measure) {
        String string;
        String string2 = measure.getColumnNamePattern();
        if (StringUtil.notEmpty(string2)) {
            ArgumentMap.CallbackMap callbackMap = new ArgumentMap.CallbackMap();
            StringBuffer stringBuffer = new StringBuffer();
            TreeNode[] treeNodeArray = treeNode.getPath();
            for (int i = 0; i < treeNodeArray.length; ++i) {
                callbackMap.put(String.valueOf(i), treeNodeArray[i].getName());
                stringBuffer.append(treeNodeArray[i].getName());
                stringBuffer.append("/");
            }
            callbackMap.put("hierarchy", stringBuffer.toString());
            callbackMap.put("field", measure.getName());
            callbackMap.put("measure", measure.getResultName());
            callbackMap.put("fn", measure.getFunction().getName());
            callbackMap.put("*", stringBuffer.toString() + measure.getResultName());
            string = ArgumentMap.substitute(string2, callbackMap);
        } else {
            string = measure.getResultName();
        }
        return this.createText(string);
    }

    public TextEx createText(String string) {
        Text text = null;
        if (StringUtil.notEmpty(string)) {
            text = new Text();
            if ("null".equals(string)) {
                string = "";
            }
            text.setText(string);
            text.setWidth(Label.pixelRound(this.m_FontMeasurer.getWidth(string)));
            text.setHeight((int)this.m_FontMeasurer.getHeight());
            text.setAscent((int)this.m_FontMeasurer.getAscent());
            TextEx textEx = new TextEx(text);
            textEx.setSignificant(true);
            textEx.setWidth(text.getWidth() + this.m_CubeHeader.getLeftMargin() + this.m_CubeHeader.getRightMargin());
            textEx.setHeight(text.getHeight() + this.m_CubeHeader.getTopMargin() + this.m_CubeHeader.getBottomMargin());
            return textEx;
        }
        TextEx textEx = new TextEx();
        textEx.setHeight((int)this.m_FontMeasurer.getHeight());
        return textEx;
    }

    public static class TextEx
    extends Rectangle {
        private TextEx m_Parent;
        private Text m_Text;
        private List<TextEx> m_Children = new ArrayList<TextEx>();
        private boolean m_Significant;

        public TextEx() {
        }

        public TextEx(Text text) {
            this.m_Text = text;
            if (this.m_Text != null) {
                this.addLogicalElement(this.m_Text);
            }
        }

        public void constrainText() {
            if (this.m_Text != null) {
                int n = this.getLeftMargin();
                int n2 = this.getRightMargin();
                int n3 = this.getTopMargin();
                this.m_Text.setLeft(this.getLeft() + n);
                this.m_Text.setWidth(this.getWidth() - n - n2);
                this.m_Text.setTop(this.getTop() + n3);
            }
        }

        public void hide() {
            this.m_Text = null;
            this.m_Width = 0;
            this.m_Height = 0;
        }

        public void hideHeaders() {
            if (!this.m_Children.isEmpty()) {
                this.hide();
                Iterator<TextEx> iterator = this.m_Children.iterator();
                while (iterator.hasNext()) {
                    iterator.next().hideHeaders();
                }
            }
        }

        public void setSignificant(boolean bl) {
            this.m_Significant = bl;
        }

        public boolean isSignificant() {
            return this.m_Text != null && StringUtil.notEmpty(this.m_Text.getText()) || this.m_Significant;
        }

        public void verify() {
            if (this.m_Text != null) {
                if (StringUtil.isEmpty(this.m_Text.getFontName())) {
                    m_Log.error((Object)("Empty text fontname for text " + this.m_Text.getText()));
                }
                if (this.m_Text.getHeight() == 0) {
                    m_Log.error((Object)("text height is 0 for text " + this.m_Text.getText()));
                }
            }
        }

        public void addChild(TextEx textEx) {
            this.m_Children.add(textEx);
            textEx.m_Parent = this;
        }

        public TextEx getParent() {
            return this.m_Parent;
        }

        public int getDepth() {
            if (this.m_Parent != null) {
                return this.m_Parent.getDepth() + 1;
            }
            return 1;
        }

        public void buildAll(List<TextEx> list) {
            if (this.isSignificant()) {
                list.add(this);
            }
            for (TextEx textEx : this.m_Children) {
                textEx.buildAll(list);
            }
        }

        public void buildLeaves(List<TextEx> list) {
            if (this.m_Children.isEmpty()) {
                list.add(this);
            } else {
                for (TextEx textEx : this.m_Children) {
                    textEx.buildLeaves(list);
                }
            }
        }

        public int layoutHorizontal(int n, int n2, int n3) {
            this.m_Left = n;
            this.m_Top = n2;
            if (this.m_Height != 0) {
                this.m_Height = n3;
            }
            if (!this.m_Children.isEmpty()) {
                for (TextEx textEx : this.m_Children) {
                    n = textEx.layoutHorizontal(n, n2 + this.m_Height, n3);
                }
                if (n > this.m_Left + this.m_Width) {
                    this.m_Width = n - this.m_Left;
                } else {
                    this.setChildWidth();
                }
            }
            return this.m_Left + this.m_Width;
        }

        public int layoutVertical(int n, int n2, int n3) {
            this.m_Left = n;
            this.m_Top = n2;
            this.m_Height = n3;
            for (TextEx textEx : this.m_Children) {
                n2 = textEx.layoutVertical(n + this.m_Width, n2, n3);
            }
            if (n2 > this.m_Top + this.m_Height) {
                this.m_Height = n2 - this.m_Top;
            }
            return this.m_Top + this.m_Height;
        }

        public void applyStyles(CubeHeader cubeHeader, ITableStyle iTableStyle, int n) {
            if (!this.hasText()) {
                this.setBackgroundColor(StandardColor.getColorName(iTableStyle.getTreeColor(Math.max(0, n - 1))));
            } else {
                this.setBackgroundColor(StandardColor.getColorName(iTableStyle.getTreeColor(n)));
            }
            this.setPaddingLeft(cubeHeader.getPaddingLeft());
            this.setPaddingTop(cubeHeader.getPaddingTop());
            this.setPaddingRight(cubeHeader.getPaddingRight());
            this.setPaddingBottom(cubeHeader.getPaddingBottom());
            this.setBorderLeft(cubeHeader.isBorderLeft());
            this.setBorderTop(cubeHeader.isBorderTop());
            this.setBorderRight(cubeHeader.isBorderRight());
            this.setBorderBottom(cubeHeader.isBorderBottom());
            this.setBorderStyle(cubeHeader.getBorderStyle());
            this.setBorderWidth(cubeHeader.getBorderWidth());
            this.setBorderColor(cubeHeader.getBorderColor());
            if (this.m_Text != null) {
                this.m_Text.setFontColor(cubeHeader.getFontColor());
                this.m_Text.setFontName(cubeHeader.getFontName());
                this.m_Text.setFontBold(cubeHeader.isFontBold());
                this.m_Text.setFontItalic(cubeHeader.isFontItalic());
                this.m_Text.setFontSize(cubeHeader.getFontSize());
                this.m_Text.setFontUnderline(cubeHeader.isFontUnderline());
                this.m_Text.setFontStrikethrough(cubeHeader.isFontStrikethrough());
                this.m_Text.setTextAlign(cubeHeader.getTextAlign());
            }
            for (TextEx textEx : this.m_Children) {
                textEx.applyStyles(cubeHeader, iTableStyle, n + 1);
            }
        }

        public void growParents(int n) {
            if (!this.m_Children.isEmpty()) {
                for (TextEx textEx : this.m_Children) {
                    textEx.growParents(n);
                }
                java.awt.Rectangle rectangle = this.getChildRect(true);
                if (n == 1) {
                    this.m_Left = rectangle.x;
                    this.m_Width = rectangle.width;
                } else {
                    this.m_Top = rectangle.y;
                    this.m_Height = rectangle.height;
                }
            }
        }

        public java.awt.Rectangle getChildRect(boolean bl) {
            int n = Integer.MAX_VALUE;
            int n2 = Integer.MAX_VALUE;
            int n3 = 0;
            int n4 = 0;
            for (TextEx textEx : this.m_Children) {
                if (!bl && textEx.isEmpty()) continue;
                int n5 = textEx.getLeft();
                int n6 = textEx.getTop();
                int n7 = n5 + textEx.getWidth();
                int n8 = n6 + textEx.getHeight();
                if (n5 < n) {
                    n = n5;
                }
                if (n6 < n2) {
                    n2 = n6;
                }
                if (n7 > n3) {
                    n3 = n7;
                }
                if (n8 <= n4) continue;
                n4 = n8;
            }
            return new java.awt.Rectangle(n, n2, n3 - n, n4 - n2);
        }

        public java.awt.Rectangle getChildRectNoMeasures() {
            int n = Integer.MAX_VALUE;
            int n2 = Integer.MAX_VALUE;
            int n3 = 0;
            int n4 = 0;
            for (TextEx textEx : this.m_Children) {
                if (!textEx.hasChildren() || !textEx.hasText()) continue;
                int n5 = textEx.getLeft();
                int n6 = textEx.getTop();
                int n7 = n5 + textEx.getWidth();
                int n8 = n6 + textEx.getHeight();
                if (n5 < n) {
                    n = n5;
                }
                if (n6 < n2) {
                    n2 = n6;
                }
                if (n7 > n3) {
                    n3 = n7;
                }
                if (n8 <= n4) continue;
                n4 = n8;
            }
            return new java.awt.Rectangle(n, n2, n3 - n, n4 - n2);
        }

        public void mergeLeftRightBorders() {
            int n = this.m_Children.size();
            if (n > 0) {
                for (int i = 0; i < n; ++i) {
                    TextEx textEx = this.m_Children.get(i);
                    TextEx textEx2 = textEx.getPreviousText();
                    if (textEx2 == null) continue;
                    int n2 = textEx2.getLeft() + textEx2.getWidth();
                    int n3 = textEx.getLeft();
                    int n4 = n3 - n2;
                    if (n4 != 0) continue;
                    textEx.setBorderLeft(false);
                }
                Iterator<TextEx> iterator = this.m_Children.iterator();
                while (iterator.hasNext()) {
                    iterator.next().mergeLeftRightBorders();
                }
            }
        }

        public void mergeTopBottomBorders() {
            int n = this.m_Children.size();
            if (n > 0) {
                for (int i = 0; i < n; ++i) {
                    TextEx textEx = this.m_Children.get(i);
                    TextEx textEx2 = textEx.getPreviousText();
                    if (textEx2 == null) continue;
                    textEx.setBorderTop(false);
                }
                Iterator<TextEx> iterator = this.m_Children.iterator();
                while (iterator.hasNext()) {
                    iterator.next().mergeTopBottomBorders();
                }
            }
        }

        protected TextEx getPreviousText() {
            if (this.m_Parent == null) {
                return null;
            }
            int n = this.m_Parent.getIndexOfChild(this);
            if (n > 0) {
                return this.m_Parent.getChild(n - 1);
            }
            return this.m_Parent.getPreviousText();
        }

        protected TextEx getNextText() {
            if (this.m_Parent == null) {
                return null;
            }
            int n = this.m_Parent.getIndexOfChild(this);
            if (n + 1 < this.m_Parent.getChildCount()) {
                return this.m_Parent.getChild(n + 1);
            }
            return this.m_Parent.getNextText();
        }

        public boolean hasChildren() {
            return !this.m_Children.isEmpty();
        }

        public boolean hasText() {
            return this.m_Text != null;
        }

        public int getChildCount() {
            return this.m_Children.size();
        }

        public int getIndexOfChild(TextEx textEx) {
            return this.m_Children.indexOf(textEx);
        }

        public TextEx getChild(int n) {
            return this.m_Children.get(n);
        }

        public Iterator<TextEx> getChildIterator() {
            return this.m_Children.iterator();
        }

        protected void setChildWidth() {
            int n;
            int n2;
            if (!this.m_Children.isEmpty() && (n2 = this.m_Width - (n = this.getChildWidth())) > 0) {
                int n3 = this.m_Children.size();
                int n4 = this.m_Children.get(0).getLeft();
                for (int i = 0; i < n3; ++i) {
                    TextEx textEx = this.m_Children.get(i);
                    int n5 = n2 / (n3 - i);
                    n2 -= n5;
                    textEx.setLeft(n4);
                    textEx.setWidth(textEx.getWidth() + n5);
                    textEx.setChildWidth();
                    n4 += textEx.getWidth();
                }
            }
        }

        protected int getChildWidth() {
            int n = 0;
            Iterator<TextEx> iterator = this.m_Children.iterator();
            while (iterator.hasNext()) {
                n += iterator.next().getWidth();
            }
            return n;
        }

        public boolean isEmpty() {
            return this.m_Children.isEmpty() && this.m_Text == null;
        }

        @Override
        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            this.buildString(stringBuilder, 0);
            return stringBuilder.toString();
        }

        @Override
        public void setWidth(int n) {
            super.setWidth(n);
        }

        private void buildString(StringBuilder stringBuilder, int n) {
            for (int i = 0; i < n; ++i) {
                stringBuilder.append("  ");
            }
            if (this.m_Text != null) {
                stringBuilder.append(this.m_Text.getText());
            } else {
                stringBuilder.append("Null Text");
            }
            stringBuilder.append("(");
            stringBuilder.append(this.getLeft());
            stringBuilder.append(",");
            stringBuilder.append(this.getTop());
            stringBuilder.append(",");
            stringBuilder.append(this.getWidth());
            stringBuilder.append(",");
            stringBuilder.append(this.getHeight());
            stringBuilder.append(")");
            stringBuilder.append("\n");
            Iterator<TextEx> iterator = this.m_Children.iterator();
            while (iterator.hasNext()) {
                iterator.next().buildString(stringBuilder, n + 1);
            }
        }

        public void setText(String string) {
            this.m_Text.setText(string);
        }
    }
}

