/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.report2.physical;

import com.elixirtech.report2.logical.model.Page;
import com.elixirtech.report2.physical.PhysicalRenderContext;
import com.elixirtech.report2.physical.PhysicalRenderer;
import com.elixirtech.report2.raw.model.PageSetup;
import com.elixirtech.report2.util.MetricConvertor;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Map;

public class GraphicalRenderContext
extends PhysicalRenderContext {
    protected Graphics m_Graphics;
    protected Rectangle m_ClipRect;
    protected Point m_Offset = new Point();

    public GraphicalRenderContext(PhysicalRenderer physicalRenderer, Graphics graphics, int n, Page page, Map<String, Object> map) {
        super(physicalRenderer, n, page, map);
        PageSetup pageSetup = page.getPageSetup();
        int n2 = MetricConvertor.twipToPoint(pageSetup.getLeft());
        int n3 = MetricConvertor.twipToPoint(pageSetup.getRight());
        int n4 = MetricConvertor.twipToPoint(pageSetup.getTop());
        int n5 = MetricConvertor.twipToPoint(pageSetup.getBottom());
        int n6 = MetricConvertor.twipToPoint(pageSetup.getWidth());
        int n7 = MetricConvertor.twipToPoint(pageSetup.getHeight());
        this.m_ClipRect = new Rectangle(n2, n4, n6 - n2 - n3, n7 - n4 - n5);
        this.m_Graphics = graphics;
        this.translate(-this.m_HShift / 20, 0);
        graphics.setClip(this.m_ClipRect);
        this.m_Offset.y = 0;
    }

    @Override
    public void dispose() {
        this.translate(this.m_HShift / 20, 0);
        super.dispose();
    }

    public Graphics getGraphics() {
        return this.m_Graphics;
    }

    public void translate(int n, int n2) {
        this.m_Offset.x += n;
        this.m_Offset.y += n2;
        this.m_ClipRect.x -= n;
        this.m_ClipRect.y -= n2;
        this.m_Graphics.translate(n, n2);
    }

    @Override
    public Point getOffset() {
        return this.m_Offset;
    }

    public Rectangle getClipBounds() {
        Rectangle rectangle = this.m_Graphics.getClipBounds();
        if (rectangle.width < 0) {
            rectangle.width = 0;
        }
        return this.m_ClipRect;
    }

    public void setClip(Rectangle rectangle) {
        this.m_Graphics.setClip(rectangle);
        this.m_ClipRect = rectangle;
    }

    public void clipRect(int n, int n2, int n3, int n4) {
        if (n3 < 0) {
            n3 = 0;
        }
        this.m_Graphics.clipRect(n, n2, n3, n4);
        this.m_ClipRect = this.m_ClipRect.intersection(new Rectangle(n, n2, n3, n4));
    }
}

