/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.report2.physical;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.arch.StringUtil;
import com.elixirtech.glint.GlintInput;
import com.elixirtech.glint.g2d.GlintGraphics2D;
import com.elixirtech.graphics.BorderStyle;
import com.elixirtech.graphics.GRectangle;
import com.elixirtech.report2.logical.model.Glint;
import com.elixirtech.report2.logical.model.Rectangle;
import com.elixirtech.report2.logical.model.SVG;
import com.elixirtech.report2.raw.constants.Alignment;
import com.elixirtech.report2.raw.model.RTF;
import com.elixirtech.report2.raw.model.RawModelElement;
import com.elixirtech.svg.SVGToImage;
import com.elixirtech.ui.StandardColor;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;

public class ImageUtil {
    private static final ElxLoggerJ m_Log = ElxLoggerJ.getLogger(ImageUtil.class);

    public static BufferedImage clip(BufferedImage bufferedImage, Dimension dimension, String string) {
        int n = bufferedImage.getWidth();
        int n2 = bufferedImage.getHeight();
        if (n <= dimension.width && n2 <= dimension.height) {
            return bufferedImage;
        }
        int n3 = 0;
        int n4 = 0;
        if ("Top Right".equals(string)) {
            n3 = Math.max(0, n - dimension.width);
        } else if ("Bottom Left".equals(string)) {
            n4 = Math.max(0, n2 - dimension.height);
        } else if ("Bottom Right".equals(string)) {
            n3 = Math.max(0, n - dimension.width);
            n4 = Math.max(0, n2 - dimension.height);
        } else if ("Center".equals(string)) {
            n3 = Math.max(0, n - dimension.width) / 2;
            n4 = Math.max(0, n2 - dimension.height) / 2;
        }
        int n5 = Math.min(n, dimension.width);
        int n6 = Math.min(n2, dimension.height);
        return bufferedImage.getSubimage(n3, n4, n5, n6);
    }

    public static Point getTopLeft(Dimension dimension, Dimension dimension2, int n) {
        int n2 = 0;
        int n3 = 0;
        if ((n & 2) != 0) {
            n2 = (dimension2.width - dimension.width) / 2;
        } else if ((n & 4) != 0) {
            n2 = dimension2.width - dimension.width;
        }
        if ((n & 0x10) != 0) {
            n3 = (dimension2.height - dimension.height) / 2;
        } else if ((n & 0x20) != 0) {
            n3 = dimension2.height - dimension.height;
        }
        return new Point(n2, n3);
    }

    public static BufferedImage getImage(Rectangle rectangle, int n) {
        int n2 = rectangle.getWidth() * n / 1440;
        int n3 = rectangle.getHeight() * n / 1440;
        BufferedImage bufferedImage = new BufferedImage(n2, n3, 2);
        Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
        GRectangle gRectangle = new GRectangle(new java.awt.Rectangle(0, 0, rectangle.getWidth(), rectangle.getHeight()));
        gRectangle.setBackground(StandardColor.lookup(rectangle.getBackgroundColor(), (Color)null));
        int n4 = 0;
        if (rectangle.isBorderLeft()) {
            n4 |= 1;
        }
        if (rectangle.isBorderTop()) {
            n4 |= 2;
        }
        if (rectangle.isBorderRight()) {
            n4 |= 4;
        }
        if (rectangle.isBorderBottom()) {
            n4 |= 8;
        }
        BorderStyle borderStyle = BorderStyle.get(rectangle.getBorderStyle());
        Color color = StandardColor.lookup(rectangle.getBorderColor(), (Color)null);
        gRectangle.setBorder(borderStyle, rectangle.getBorderWidth(), color, n4);
        graphics2D.scale(20.0, 20.0);
        graphics2D.scale((double)n / 72.0, (double)n / 72.0);
        gRectangle.draw(graphics2D);
        graphics2D.dispose();
        return bufferedImage;
    }

    public static ImageHolder getImage2(Rectangle rectangle, int n) {
        int n2 = rectangle.getWidth() * n / 1440;
        int n3 = rectangle.getHeight() * n / 1440;
        BufferedImage bufferedImage = new BufferedImage(n2, n3, 2);
        Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
        GRectangle gRectangle = new GRectangle(new java.awt.Rectangle(0, 0, rectangle.getWidth(), rectangle.getHeight()));
        gRectangle.setBackground(StandardColor.lookup(rectangle.getBackgroundColor(), Color.white));
        int n4 = 0;
        if (rectangle.isBorderLeft()) {
            n4 |= 1;
        }
        if (rectangle.isBorderTop()) {
            n4 |= 2;
        }
        if (rectangle.isBorderRight()) {
            n4 |= 4;
        }
        if (rectangle.isBorderBottom()) {
            n4 |= 8;
        }
        BorderStyle borderStyle = BorderStyle.get(rectangle.getBorderStyle());
        Color color = StandardColor.lookup(rectangle.getBorderColor(), (Color)null);
        gRectangle.setBorder(borderStyle, rectangle.getBorderWidth(), color, n4);
        graphics2D.scale(0.05, 0.05);
        graphics2D.scale((double)n / 72.0, (double)n / 72.0);
        gRectangle.draw(graphics2D);
        graphics2D.dispose();
        return new ImageHolder(bufferedImage, gRectangle);
    }

    public static BufferedImage getImage(Rectangle rectangle, com.elixirtech.report2.logical.model.Image image, int n) {
        int n2;
        int n3;
        int n4;
        int n5;
        Object object;
        BufferedImage bufferedImage;
        Object object2;
        if (rectangle != null) {
            object2 = ImageUtil.getImage2(rectangle, n);
            bufferedImage = ((ImageHolder)object2).im;
            object = ((ImageHolder)object2).grc.getChildRect();
            n5 = ((ImageHolder)object2).im.getWidth();
            n4 = ((ImageHolder)object2).im.getHeight();
            n3 = ((java.awt.Rectangle)object).x / 20;
            n2 = ((java.awt.Rectangle)object).y / 20;
        } else {
            n5 = image.getWidth() * n / 1440;
            n4 = image.getHeight() * n / 1440;
            bufferedImage = new BufferedImage(n5, n4, 2);
            n3 = 0;
            n2 = 0;
        }
        object2 = bufferedImage.createGraphics();
        object = image.getSizeMode();
        Image image2 = image.getImage();
        if (image2 != null) {
            if ("Stretch".equals(object)) {
                ((Graphics)object2).drawImage(image2, n3, n2, n5, n4, null);
            } else if ("Zoom".equals(object)) {
                Dimension dimension = new Dimension(image2.getWidth(null), image2.getHeight(null));
                Dimension dimension2 = new Dimension(dimension.width, dimension.height);
                double d = (double)n5 / (double)dimension2.width;
                double d2 = (double)n4 / (double)dimension2.height;
                if (d >= d2) {
                    dimension2.width = (int)(d2 * (double)dimension2.width);
                    dimension2.height = n4;
                } else {
                    dimension2.width = n5;
                    dimension2.height = (int)(d * (double)dimension2.height);
                }
                java.awt.Rectangle rectangle2 = new java.awt.Rectangle(n3, n2, n5, n4);
                int n6 = Alignment.getAlignmentId(image.getHorizontalAlign(), image.getVerticalAlign());
                rectangle2 = Alignment.positionRect(rectangle2, dimension2, n6);
                ((Graphics)object2).drawImage(image2, rectangle2.x, rectangle2.y, rectangle2.x + rectangle2.width, rectangle2.y + rectangle2.height, 0, 0, dimension.width, dimension.height, null);
            } else if ("Clip".equals(object)) {
                java.awt.Rectangle rectangle3 = new java.awt.Rectangle(0, 0, image2.getWidth(null), image2.getHeight(null));
                rectangle3.width = rectangle3.width * n / 72;
                rectangle3.height = rectangle3.height * n / 72;
                java.awt.Rectangle rectangle4 = new java.awt.Rectangle(n3, n2, n5, n4);
                int n7 = Alignment.getAlignmentId(image.getHorizontalAlign(), image.getVerticalAlign());
                Alignment.clipImageRect(rectangle3, rectangle4, n7);
                rectangle4.width = rectangle3.width;
                rectangle4.height = rectangle3.height;
                rectangle3.x = rectangle3.x * 72 / n;
                rectangle3.y = rectangle3.y * 72 / n;
                rectangle3.width = rectangle3.width * 72 / n;
                rectangle3.height = rectangle3.height * 72 / n;
                ((Graphics)object2).drawImage(image2, rectangle4.x, rectangle4.y, rectangle4.x + rectangle4.width, rectangle4.y + rectangle4.height, rectangle3.x, rectangle3.y, rectangle3.x + rectangle3.width, rectangle3.y + rectangle3.height, null);
            } else {
                m_Log.error((Object)("Unknown size mode: " + (String)object));
            }
        }
        ((Graphics)object2).dispose();
        return bufferedImage;
    }

    public static BufferedImage getImage(Glint glint, int n) {
        RTF rTF;
        String string;
        int n2 = glint.getWidth() * n / 1440;
        int n3 = glint.getHeight() * n / 1440;
        BufferedImage bufferedImage = new BufferedImage(n2, n3, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        RawModelElement rawModelElement = glint.getRaw();
        if (rawModelElement instanceof RTF && StringUtil.notEmpty(string = (rTF = (RTF)rawModelElement).getBackgroundColor())) {
            graphics2D.setColor(StandardColor.lookup(string));
            graphics2D.fillRect(0, 0, n2, n3);
        }
        double d = n;
        graphics2D.scale(d / 72.0, d / 72.0);
        GlintGraphics2D glintGraphics2D = new GlintGraphics2D(graphics2D);
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(glint.getByteArray().getBytes());
            GlintInput.read(byteArrayInputStream, true, glintGraphics2D);
            graphics2D.dispose();
            return bufferedImage;
        }
        catch (Throwable throwable) {
            m_Log.error((Object)("Glint Render error: " + throwable));
            return null;
        }
    }

    public static BufferedImage getImage(Rectangle rectangle, SVG sVG, int n) {
        int n2 = sVG.getWidth() * n / 1440;
        int n3 = sVG.getHeight() * n / 1440;
        try {
            BufferedImage bufferedImage = SVGToImage.convert(sVG.getDocument(), new Dimension(n2, n3));
            if (rectangle == null) {
                return bufferedImage;
            }
            BufferedImage bufferedImage2 = ImageUtil.getImage(rectangle, n);
            int n4 = rectangle.getBorderWidth() * n / 1440;
            Graphics2D graphics2D = bufferedImage2.createGraphics();
            graphics2D.drawImage((Image)bufferedImage, n4, n4, null);
            graphics2D.dispose();
            return bufferedImage2;
        }
        catch (Throwable throwable) {
            m_Log.error((Object)("Image Render error: " + throwable));
            return null;
        }
    }

    public static class ImageHolder {
        public BufferedImage im;
        public GRectangle grc;

        public ImageHolder(BufferedImage bufferedImage, GRectangle gRectangle) {
            this.im = bufferedImage;
            this.grc = gRectangle;
        }
    }
}

