/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.report2.physical.docx;

import com.elixirtech.report2.logical.model.ILogicalElementHolder;
import com.elixirtech.report2.logical.model.LogicalElement;
import com.elixirtech.report2.logical.model.LogicalElementHolder;
import com.elixirtech.report2.logical.model.Rectangle;
import com.elixirtech.report2.physical.docx.ChunkAnalysis$;
import com.elixirtech.report2.physical.docx.Dimensions;
import java.awt.Point;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple4$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.ListBuffer;
import scala.math.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.Scala3RunTime$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction1;

public class ChunkAnalysis {
    private final LogicalElementHolder holder;
    private final List elements;
    private final Dimensions dims;

    public static ChunkAnalysis apply(LogicalElementHolder logicalElementHolder) {
        return ChunkAnalysis$.MODULE$.apply(logicalElementHolder);
    }

    public static java.awt.Rectangle buildRect(LogicalElement logicalElement) {
        return ChunkAnalysis$.MODULE$.buildRect(logicalElement);
    }

    public static int constrain(HashMap<Object, Object> hashMap, int n) {
        return ChunkAnalysis$.MODULE$.constrain(hashMap, n);
    }

    public static int constrain(Map<Object, Object> map, int n) {
        return ChunkAnalysis$.MODULE$.constrain(map, n);
    }

    public static boolean containsHolder(ILogicalElementHolder iLogicalElementHolder) {
        return ChunkAnalysis$.MODULE$.containsHolder(iLogicalElementHolder);
    }

    public static boolean containsText(ILogicalElementHolder iLogicalElementHolder) {
        return ChunkAnalysis$.MODULE$.containsText(iLogicalElementHolder);
    }

    public static List<LogicalElement> getLayoutElements(ILogicalElementHolder iLogicalElementHolder) {
        return ChunkAnalysis$.MODULE$.getLayoutElements(iLogicalElementHolder);
    }

    public static List<Rectangle> getTopLevelRects(ILogicalElementHolder iLogicalElementHolder) {
        return ChunkAnalysis$.MODULE$.getTopLevelRects(iLogicalElementHolder);
    }

    public static Tuple2<Map<Object, Object>, Map<Object, Object>> mergeAdjacentPixels(Dimensions dimensions) {
        return ChunkAnalysis$.MODULE$.mergeAdjacentPixels(dimensions);
    }

    public static void propagateBackground(ILogicalElementHolder iLogicalElementHolder) {
        ChunkAnalysis$.MODULE$.propagateBackground(iLogicalElementHolder);
    }

    public ChunkAnalysis(LogicalElementHolder holder) {
        this.holder = holder;
        this.elements = this.adjustToAvoidOverlaps();
        this.ensureNoOverlaps(this.elements());
        this.dims = this.buildDims();
    }

    public LogicalElementHolder holder() {
        return this.holder;
    }

    public List<LogicalElement> elements() {
        return this.elements;
    }

    public Dimensions dims() {
        return this.dims;
    }

    public Dimensions buildDims() {
        Dimensions overall = new Dimensions((Set<Object>)((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.holder().getWidth()}))), (Set<Object>)((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.holder().getHeight()}))));
        Dimensions dims = this.buildDims(this.holder(), overall);
        Tuple2<Map<Object, Object>, Map<Object, Object>> tuple2 = ChunkAnalysis$.MODULE$.mergeAdjacentPixels(dims);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Map xmap = (Map)tuple2._1();
        Map ymap = (Map)tuple2._2();
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)xmap, (Object)ymap);
        Map xmap2 = (Map)tuple22._1();
        Map ymap2 = (Map)tuple22._2();
        this.updateElements((Map<Object, Object>)xmap2, (Map<Object, Object>)ymap2);
        return this.updateDimensions(dims, (Map<Object, Object>)xmap2, (Map<Object, Object>)ymap2);
    }

    public Dimensions buildDims(ILogicalElementHolder h, Dimensions dims) {
        Dimensions d2 = dims.add(h.getLeft(), h.getTop()).add(h.getLeft() + h.getWidth(), h.getTop() + h.getHeight());
        return (Dimensions)ChunkAnalysis$.MODULE$.getLayoutElements(h).foldLeft((Object)d2, (Function2 & Serializable)(ds, e) -> {
            LogicalElement logicalElement = e;
            if (logicalElement instanceof ILogicalElementHolder) {
                LogicalElement h = (LogicalElement)((Object)((ILogicalElementHolder)((Object)logicalElement)));
                return this.buildDims((ILogicalElementHolder)((Object)h), (Dimensions)ds);
            }
            return ds;
        });
    }

    public void updateElements(Map<Object, Object> xmap, Map<Object, Object> ymap) {
        this.elements().foreach((Function1)(JProcedure1 & Serializable)e -> {
            int newx = ChunkAnalysis$.MODULE$.constrain(xmap, e.getLeft());
            int right = ChunkAnalysis$.MODULE$.constrain(xmap, e.getLeft() + e.getWidth());
            e.setLeft(newx);
            e.setWidth(right - newx);
            int newy = ChunkAnalysis$.MODULE$.constrain(ymap, e.getTop());
            int bottom = ChunkAnalysis$.MODULE$.constrain(ymap, e.getTop() + e.getHeight());
            e.setTop(newy);
            e.setHeight(bottom - newy);
        });
    }

    public Dimensions updateDimensions(Dimensions dims, Map<Object, Object> xmap, Map<Object, Object> ymap) {
        Set xs = (Set)dims.xsSet().map((Function1)(JFunction1.mcII.sp & Serializable)x -> BoxesRunTime.unboxToInt((Object)xmap.getOrElse((Object)BoxesRunTime.boxToInteger((int)x), () -> ChunkAnalysis.$anonfun$1$$anonfun$1(x))));
        Set ys = (Set)dims.ysSet().map((Function1)(JFunction1.mcII.sp & Serializable)y -> BoxesRunTime.unboxToInt((Object)ymap.getOrElse((Object)BoxesRunTime.boxToInteger((int)y), () -> ChunkAnalysis.$anonfun$2$$anonfun$1(y))));
        return new Dimensions((Set<Object>)xs, (Set<Object>)ys);
    }

    public List<LogicalElement> adjustToAvoidOverlaps() {
        ListBuffer rcs = new ListBuffer();
        List<LogicalElement> list = ChunkAnalysis$.MODULE$.getLayoutElements(this.holder());
        return list.flatMap((Function1 & Serializable)_$3 -> this.adjustToAvoidOverlaps((ListBuffer<java.awt.Rectangle>)rcs, (LogicalElement)_$3));
    }

    public Option<LogicalElement> adjustToAvoidOverlaps(ListBuffer<java.awt.Rectangle> rcs, LogicalElement e) {
        java.awt.Rectangle rc = ChunkAnalysis$.MODULE$.buildRect(e);
        ListBuffer intersects = (ListBuffer)rcs.filter((Function1 & Serializable)r -> rc.intersects((java.awt.Rectangle)r));
        if (intersects.isEmpty()) {
            rcs.$plus$eq((Object)rc);
            return Some$.MODULE$.apply((Object)e);
        }
        return intersects.headOption().flatMap(arg_0 -> this.adjustToAvoidOverlaps$$anonfun$2(rc, e, rcs, arg_0));
    }

    public Option<LogicalElement> moveTopLeft(LogicalElement e, java.awt.Rectangle rc) {
        int dy;
        int dx = package$.MODULE$.abs(e.getLeft() - this.right(rc));
        if (dx <= (dy = package$.MODULE$.abs(e.getTop() - this.bottom(rc)))) {
            if (e.getWidth() > dx) {
                e.setLeft(e.getLeft() + dx);
                e.setWidth(e.getWidth() - dx);
                Some$.MODULE$.apply((Object)e);
            }
        }
        if (e.getHeight() > dy) {
            e.setTop(e.getTop() + dy);
            e.setHeight(e.getHeight() - dy);
            return Some$.MODULE$.apply((Object)e);
        }
        return None$.MODULE$;
    }

    public Option<LogicalElement> moveTopRight(LogicalElement e, java.awt.Rectangle rc) {
        int dy;
        int dx = package$.MODULE$.abs(this.right(e) - rc.x);
        if (dx <= (dy = package$.MODULE$.abs(e.getTop() - this.bottom(rc)))) {
            if (e.getWidth() > dx) {
                e.setWidth(e.getWidth() - dx);
                Some$.MODULE$.apply((Object)e);
            }
        }
        if (e.getHeight() > dy) {
            e.setTop(e.getTop() + dy);
            e.setHeight(e.getHeight() - dy);
            return Some$.MODULE$.apply((Object)e);
        }
        return None$.MODULE$;
    }

    public Option<LogicalElement> moveBottomLeft(LogicalElement e, java.awt.Rectangle rc) {
        int dy;
        int dx = package$.MODULE$.abs(e.getLeft() - this.right(rc));
        if (dx <= (dy = package$.MODULE$.abs(this.bottom(e) - rc.y))) {
            if (e.getWidth() > dx) {
                e.setLeft(e.getLeft() + dx);
                e.setWidth(e.getWidth() - dx);
                Some$.MODULE$.apply((Object)e);
            }
        }
        if (e.getHeight() > dy) {
            e.setHeight(e.getHeight() - dy);
            return Some$.MODULE$.apply((Object)e);
        }
        return None$.MODULE$;
    }

    public Option<LogicalElement> moveBottomRight(LogicalElement e, java.awt.Rectangle rc) {
        int dy;
        int dx = package$.MODULE$.abs(this.right(e) - rc.x);
        if (dx <= (dy = package$.MODULE$.abs(this.bottom(e) - rc.y))) {
            if (e.getWidth() > dx) {
                e.setWidth(e.getWidth() - dx);
                Some$.MODULE$.apply((Object)e);
            }
        }
        if (e.getHeight() > dy) {
            e.setHeight(e.getHeight() - dy);
            return Some$.MODULE$.apply((Object)e);
        }
        return None$.MODULE$;
    }

    public Option<LogicalElement> moveTop(LogicalElement e, java.awt.Rectangle rc) {
        int d = package$.MODULE$.abs(this.bottom(rc) - e.getTop());
        e.setTop(e.getTop() + d);
        e.setHeight(e.getHeight() - d);
        return Some$.MODULE$.apply((Object)e);
    }

    public Option<LogicalElement> moveLeft(LogicalElement e, java.awt.Rectangle rc) {
        int d = package$.MODULE$.abs(this.right(rc) - e.getLeft());
        e.setLeft(e.getLeft() + d);
        e.setWidth(e.getWidth() - d);
        return Some$.MODULE$.apply((Object)e);
    }

    public Option<LogicalElement> moveRight(LogicalElement e, java.awt.Rectangle rc) {
        int d = package$.MODULE$.abs(this.right(e) - rc.x);
        e.setWidth(e.getWidth() - d);
        return Some$.MODULE$.apply((Object)e);
    }

    public Option<LogicalElement> moveBottom(LogicalElement e, java.awt.Rectangle rc) {
        int d = package$.MODULE$.abs(this.bottom(e) - rc.y);
        e.setHeight(e.getHeight() - d);
        return Some$.MODULE$.apply((Object)e);
    }

    public void ensureNoOverlaps(List<LogicalElement> es) {
        this.doEnsureNoOverlaps((List<java.awt.Rectangle>)es.map((Function1 & Serializable)e -> ChunkAnalysis$.MODULE$.buildRect((LogicalElement)e)).toList());
    }

    public final void doEnsureNoOverlaps(List<java.awt.Rectangle> list) {
        List list2;
        while (true) {
            java.awt.Rectangle head;
            list2 = list;
            Nil$ nil$ = scala.package$.MODULE$.Nil();
            List list3 = list2;
            if (!(nil$ != null ? !nil$.equals(list3) : list3 != null)) {
                return;
            }
            if (!(list2 instanceof .colon.colon)) break;
            .colon.colon colon2 = (.colon.colon)list2;
            List list4 = colon2.next$access$1();
            List tail = list4;
            if (!tail.forall(arg_0 -> ChunkAnalysis.doEnsureNoOverlaps$$anonfun$1(head = (java.awt.Rectangle)colon2.head(), arg_0))) {
                throw Scala3RunTime$.MODULE$.assertFailed();
            }
            list = tail;
        }
        throw new MatchError(list2);
    }

    private int right(LogicalElement e) {
        return e.getLeft() + e.getWidth();
    }

    private int bottom(LogicalElement e) {
        return e.getTop() + e.getHeight();
    }

    private int right(java.awt.Rectangle rc) {
        return rc.x + rc.width;
    }

    private int bottom(java.awt.Rectangle rc) {
        return rc.y + rc.height;
    }

    private static final int $anonfun$1$$anonfun$1(int x$1) {
        return x$1;
    }

    private static final int $anonfun$2$$anonfun$1(int y$1) {
        return y$1;
    }

    private final /* synthetic */ Option adjustToAvoidOverlaps$$anonfun$2$$anonfun$1(ListBuffer rcs$3, LogicalElement _$4) {
        return this.adjustToAvoidOverlaps((ListBuffer<java.awt.Rectangle>)rcs$3, _$4);
    }

    /*
     * Unable to fully structure code
     */
    private final /* synthetic */ Option adjustToAvoidOverlaps$$anonfun$2(java.awt.Rectangle rc$2, LogicalElement e$1, ListBuffer rcs$2, java.awt.Rectangle i) {
        block5: {
            block9: {
                block10: {
                    block6: {
                        block8: {
                            block7: {
                                block4: {
                                    tl = new Point(rc$2.x, rc$2.y);
                                    tr = new Point(rc$2.x + rc$2.width, rc$2.y);
                                    bl = new Point(rc$2.x, rc$2.y + rc$2.height);
                                    br = new Point(rc$2.x + rc$2.width, rc$2.y + rc$2.height);
                                    var10_9 = Tuple4$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)i.contains(tl)), (Object)BoxesRunTime.boxToBoolean((boolean)i.contains(tr)), (Object)BoxesRunTime.boxToBoolean((boolean)i.contains(bl)), (Object)BoxesRunTime.boxToBoolean((boolean)i.contains(br)));
                                    if (var10_9 == null) ** GOTO lbl-1000
                                    var11_10 = BoxesRunTime.unboxToBoolean((Object)var10_9._1());
                                    var12_11 = BoxesRunTime.unboxToBoolean((Object)var10_9._2());
                                    var13_12 = BoxesRunTime.unboxToBoolean((Object)var10_9._3());
                                    var14_13 = BoxesRunTime.unboxToBoolean((Object)var10_9._4());
                                    if (!var11_10 || var12_11 || var13_12 || var14_13) break block4;
                                    v0 = this.moveTopLeft(e$1, i);
                                    break block5;
                                }
                                if (var11_10) break block6;
                                if (!var12_11 || var13_12 || var14_13) break block7;
                                v0 = this.moveTopRight(e$1, i);
                                break block5;
                            }
                            if (var12_11) break block6;
                            if (!var13_12 || var14_13) break block8;
                            v0 = this.moveBottomLeft(e$1, i);
                            break block5;
                        }
                        if (var13_12 || !var14_13) break block6;
                        v0 = this.moveBottomRight(e$1, i);
                        break block5;
                    }
                    if (!var11_10) break block9;
                    if (!var12_11 || var13_12 || !var14_13) break block10;
                    v0 = this.moveTop(e$1, i);
                    break block5;
                }
                if (var12_11 || !var13_12 || !var14_13) break block9;
                v0 = this.moveLeft(e$1, i);
                break block5;
            }
            if (var11_10) ** GOTO lbl-1000
            if (var12_11 && !var13_12 && var14_13) {
                v0 = this.moveRight(e$1, i);
            } else if (!var12_11 && var13_12 && var14_13) {
                v0 = this.moveBottom(e$1, i);
            } else lbl-1000:
            // 3 sources

            {
                v0 = None$.MODULE$;
            }
        }
        adjustedE = v0;
        return adjustedE.flatMap((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, adjustToAvoidOverlaps$$anonfun$2$$anonfun$1(scala.collection.mutable.ListBuffer com.elixirtech.report2.logical.model.LogicalElement ), (Lcom/elixirtech/report2/logical/model/LogicalElement;)Lscala/Option;)((ChunkAnalysis)this, (ListBuffer)rcs$2));
    }

    private static final /* synthetic */ boolean doEnsureNoOverlaps$$anonfun$1(java.awt.Rectangle head$1, java.awt.Rectangle r2) {
        return !head$1.intersects(r2);
    }
}

