/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.report2.physical.glint;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.glint.Color;
import com.elixirtech.glint.ColorManager;
import com.elixirtech.glint.GlintRenderContext;
import com.elixirtech.glint.IGlint;
import com.elixirtech.glint.Pen;
import com.elixirtech.graphics.BorderStyle;
import com.elixirtech.graphics.GLine;
import com.elixirtech.report2.logical.model.Line;
import com.elixirtech.report2.logical.model.LogicalElement;
import com.elixirtech.report2.physical.PhysicalRenderContext;
import com.elixirtech.report2.physical.glint.BasicPhysicalRenderer;
import com.elixirtech.ui.StandardColor;
import java.awt.Point;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Path2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;

public class LineRenderer
extends BasicPhysicalRenderer {
    private static ElxLoggerJ m_Log = ElxLoggerJ.getLogger(LineRenderer.class);

    @Override
    public void render(PhysicalRenderContext physicalRenderContext, LogicalElement logicalElement) {
        Line line = (Line)logicalElement;
        GlintRenderContext glintRenderContext = (GlintRenderContext)physicalRenderContext;
        IGlint iGlint = glintRenderContext.getGlint();
        int n = line.getLeft();
        int n2 = line.getTop();
        int n3 = line.getWidth();
        int n4 = line.getHeight();
        int n5 = line.getDivisor();
        int n6 = n + line.getX1() * n3 / n5;
        int n7 = n2 + line.getY1() * n4 / n5;
        int n8 = n + line.getX2() * n3 / n5;
        int n9 = n2 + line.getY2() * n4 / n5;
        int n10 = GLine.insetArrow(line.getArrowStyle1(), line.getArrowWidth1());
        int n11 = GLine.insetArrow(line.getArrowStyle2(), line.getArrowWidth2());
        int n12 = n6;
        int n13 = n8;
        int n14 = n7;
        int n15 = n9;
        if (n10 > 0 || n11 > 0) {
            double d = Math.atan2(n7 - n9, n6 - n8);
            if (n10 > 0) {
                n12 = (int)((double)n12 - Math.cos(d) * (double)n10);
                n14 = (int)((double)n14 - Math.sin(d) * (double)n10);
            }
            if (n11 > 0) {
                n13 = (int)((double)n13 + Math.cos(d) * (double)n11);
                n15 = (int)((double)n15 + Math.sin(d) * (double)n11);
            }
        }
        Pen pen = Pen.NONE;
        BorderStyle borderStyle = BorderStyle.get(line.getLineStyle());
        String string = line.getLineColor();
        Color color = string != null ? ColorManager.lookup(string) : Color.BLACK;
        int n16 = line.getLineWidth();
        if (n16 < 0) {
            n16 = 0;
        }
        if (borderStyle != BorderStyle.NONE && n16 > 0) {
            pen = Pen.newInstance(color, n16, this.glintPenId(borderStyle.ID));
            iGlint.drawLine(iGlint.definePen(pen), n12, n14, n13, n15);
        }
        this.drawArrows(iGlint, line, color, n6, n7, n8, n9);
    }

    private int glintPenId(int n) {
        switch (n) {
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 3;
            }
            case 9: {
                return 4;
            }
            case 10: {
                return 5;
            }
            case 11: {
                return 6;
            }
            case 4: {
                return 7;
            }
        }
        return 0;
    }

    private void drawArrows(IGlint iGlint, Line line, Color color, int n, int n2, int n3, int n4) {
        int n5;
        String string = line.getArrowStyle1();
        String string2 = line.getArrowStyle2();
        double d = Math.atan2(n2 - n4, n - n3);
        if (string != null && !"None".equals(string)) {
            n5 = line.getArrowWidth1();
            this.drawEndShape(iGlint, string, 1, n5, line, color, n, n2, d + Math.PI);
        }
        if (string2 != null && !"None".equals(string2)) {
            n5 = line.getArrowWidth2();
            this.drawEndShape(iGlint, string2, 2, n5, line, color, n3, n4, d);
        }
    }

    protected void drawEndShape(IGlint iGlint, String string, int n, int n2, Line line, Color color, int n3, int n4, double d) {
        Object object;
        Object object2;
        Object object3 = null;
        IGlint.PenId penId = new IGlint.PenId(0);
        float f = n2 / 2;
        if ("Symmetric-Arrow".equals(string)) {
            GeneralPath generalPath = new GeneralPath();
            generalPath.moveTo(-20.0f, 0.0f);
            generalPath.lineTo(n2, -f);
            generalPath.lineTo(n2, f);
            generalPath.closePath();
            object3 = generalPath;
        } else if ("Arrow".equals(string)) {
            GeneralPath generalPath = new GeneralPath();
            generalPath.moveTo(-20.0f, 0.0f);
            generalPath.lineTo(n2 * 2, -f);
            generalPath.lineTo(n2 * 2, f);
            generalPath.closePath();
            object3 = generalPath;
        } else if ("Diamond".equals(string)) {
            GeneralPath generalPath = new GeneralPath();
            generalPath.moveTo(-20.0f, 0.0f);
            generalPath.lineTo(f, -f);
            generalPath.lineTo(n2, 0.0f);
            generalPath.lineTo(f, f);
            generalPath.closePath();
            object3 = generalPath;
        } else if ("Open-Arrow".equals(string)) {
            int n5 = line.getLineWidth();
            if (n5 > 0) {
                object2 = new GeneralPath();
                String string2 = n == 1 ? line.getArrowColor1() : line.getArrowColor2();
                penId = iGlint.definePen(Pen.newInstance(Color.newInstance(StandardColor.lookup(string2, StandardColor.black)), n5));
                ((Path2D.Float)object2).moveTo(n2 * 2, -f);
                ((Path2D.Float)object2).lineTo(0.0f, 0.0f);
                ((Path2D.Float)object2).lineTo(n2 * 2, f);
                object3 = object2;
            }
        } else if ("Square".equals(string)) {
            object3 = new Rectangle2D.Double(-20.0, -f, n2, n2);
        } else if ("Line".equals(string)) {
            object3 = new Rectangle2D.Double(-20.0, -f, n2 / 6, n2);
        } else if ("Round".equals(string)) {
            GeneralPath generalPath = new GeneralPath();
            generalPath.moveTo(-20.0f, 0.0f);
            for (double d2 = 0.0; d2 < Math.PI * 2; d2 += 0.5235987755982988) {
                float f2 = f + (float)(Math.sin(d2) * (double)f - 20.0);
                float f3 = (float)(Math.cos(d2) * (double)f);
                if (d2 == 0.0) {
                    generalPath.moveTo(f2, f3);
                    continue;
                }
                generalPath.lineTo(f2, f3);
            }
            generalPath.closePath();
            object3 = generalPath;
        }
        if (object3 == null) {
            return;
        }
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.rotate(d);
        object2 = new float[6];
        boolean bl = false;
        ArrayList<Point> arrayList = new ArrayList<Point>();
        PathIterator pathIterator = object3.getPathIterator(affineTransform);
        while (!pathIterator.isDone()) {
            int n6 = pathIterator.currentSegment((float[])object2);
            if (n6 == 4) {
                bl = true;
            } else {
                arrayList.add(new Point((int)object2[0] + n3, (int)object2[1] + n4));
            }
            pathIterator.next();
        }
        int[] nArray = new int[arrayList.size()];
        int[] nArray2 = new int[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            object = (Point)arrayList.get(i);
            nArray[i] = ((Point)object).x;
            nArray2[i] = ((Point)object).y;
        }
        if (bl) {
            String string3 = n == 1 ? line.getArrowColor1() : line.getArrowColor2();
            object = iGlint.defineColor(Color.newInstance(StandardColor.lookup(string3, StandardColor.black)));
            iGlint.drawPolygon(penId, (IGlint.ColorId)object, nArray, nArray2);
        } else {
            iGlint.drawPolyline(penId, nArray, nArray2);
        }
    }

    protected ElxLoggerJ getLog() {
        return m_Log;
    }
}

