/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.report2.physical.glint;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.glint.GlintRenderContext;
import com.elixirtech.glint.IGlint;
import com.elixirtech.glint.Image;
import com.elixirtech.report2.logical.model.LogicalElement;
import com.elixirtech.report2.logical.model.SVG;
import com.elixirtech.report2.physical.PhysicalRenderContext;
import com.elixirtech.report2.physical.glint.BasicPhysicalRenderer;
import com.elixirtech.report2.util.MetricConvertor;
import com.elixirtech.svg.SVGToImage;
import com.elixirtech.ui.StandardColor;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.image.BufferedImage;

public final class SVGRenderer
extends BasicPhysicalRenderer {
    private GlintRenderContext m_Context;
    private SVG m_Element;
    private int m_Width;
    private int m_Height;
    private BufferedImage m_BufferedImage;
    private int m_KeyId;
    private static ElxLoggerJ m_Log = ElxLoggerJ.getLogger(SVGRenderer.class);

    @Override
    public void render(PhysicalRenderContext physicalRenderContext, LogicalElement logicalElement) {
        SVG sVG = (SVG)logicalElement;
        this.m_Context = (GlintRenderContext)physicalRenderContext;
        this.m_Element = sVG;
        this.m_Width = MetricConvertor.twipToPoint(sVG.getWidth());
        this.m_Height = MetricConvertor.twipToPoint(sVG.getHeight());
        this.refreshBufferImage(sVG);
        this.paint(this.m_Context.getGlint(), sVG);
    }

    public void paint(IGlint iGlint, SVG sVG) {
        if (this.m_BufferedImage != null) {
            IGlint.ImageId imageId = iGlint.defineImage(Image.getInstance(this.m_BufferedImage, "SVG" + this.m_KeyId));
            ++this.m_KeyId;
            iGlint.drawScaledImage(imageId, sVG.getLeft(), sVG.getTop(), sVG.getWidth(), sVG.getHeight());
        }
    }

    public void refreshBufferImage(SVG sVG) {
        try {
            this.m_BufferedImage = SVGToImage.convert(sVG.getDocument(), new Dimension(this.m_Width, this.m_Height));
            BufferedImage bufferedImage = new BufferedImage(this.m_Width, this.m_Height, this.m_BufferedImage.getType());
            Graphics graphics = bufferedImage.getGraphics();
            Color color = new Color(255, 255, 255, 0);
            if ("Normal".equals(this.m_Element.getBackgroundStyle())) {
                color = StandardColor.lookup(this.m_Element.getBackgroundColor());
            }
            graphics.setColor(color);
            graphics.fillRect(0, 0, this.m_Width, this.m_Height);
            graphics.drawImage(this.m_BufferedImage, 0, 0, null);
            graphics.dispose();
            this.m_BufferedImage.flush();
            this.m_BufferedImage = bufferedImage;
        }
        catch (Exception exception) {
            m_Log.error((Object)("Exception: " + exception));
        }
    }
}

