/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.report2.physical.lpt;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.arch.StringUtil;
import com.elixirtech.report2.RenderConstants;
import com.elixirtech.report2.RenderException;
import com.elixirtech.report2.logical.model.Body;
import com.elixirtech.report2.logical.model.BodyPart;
import com.elixirtech.report2.logical.model.Column;
import com.elixirtech.report2.logical.model.Columns;
import com.elixirtech.report2.logical.model.IBody;
import com.elixirtech.report2.logical.model.ILogicalElementHolder;
import com.elixirtech.report2.logical.model.LogicalElement;
import com.elixirtech.report2.logical.model.Page;
import com.elixirtech.report2.logical.model.PageFooter;
import com.elixirtech.report2.logical.model.PageHeader;
import com.elixirtech.report2.logical.model.Text;
import com.elixirtech.report2.physical.PhysicalRenderer;
import com.elixirtech.report2.raw.model.RenderDetails;
import com.elixirtech.report2.util.VariableSubstitution;
import java.awt.Dimension;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class LPTRenderer
extends PhysicalRenderer {
    protected VariableSubstitution m_VariableSubstitution = new VariableSubstitution();
    protected Dimension m_CharSize;
    protected String m_LineFeed = new String(new char[]{'\r', '\n'});
    protected String m_FormFeed = new String(new char[]{'\r', '\f'});
    private LPTPage m_Page;
    protected int m_X = 0;
    protected int m_Y = 0;
    protected String m_PageNumber;
    protected String m_PageCount;
    private static final ElxLoggerJ m_Log = ElxLoggerJ.getLogger(LPTRenderer.class);

    public LPTRenderer(RenderDetails renderDetails) throws RenderException {
        super(null);
        try {
            int n = 150;
            int n2 = 300;
            String string = renderDetails.getParameterValue("CharacterWidth");
            String string2 = renderDetails.getParameterValue("CharacterHeight");
            try {
                if (string != null) {
                    n = Integer.parseInt(string);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            try {
                if (string2 != null) {
                    n2 = Integer.parseInt(string2);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            this.m_CharSize = new Dimension(n, n2);
        }
        catch (Throwable throwable) {
            throw new RenderException("LPTRenderer: " + throwable, throwable);
        }
    }

    public void renderPage(Page page, OutputStream outputStream) throws IOException {
        PageFooter pageFooter;
        Body body;
        Map<String, String> map = this.m_VariableSubstitution.getMap();
        this.m_PageNumber = Integer.toString(page.getPageNumber());
        this.m_PageCount = Integer.toString(page.getPageCount());
        map.put("#", this.m_PageNumber);
        map.put("##", this.m_PageCount);
        map.put("@", this.m_PageNumber + " of " + this.m_PageCount);
        this.m_Page = new LPTPage();
        this.m_X = 0;
        this.m_Y = 0;
        PageHeader pageHeader = page.getPageHeader();
        if (pageHeader != null) {
            this.renderChunk(pageHeader);
            this.m_Y += pageHeader.getHeight();
        }
        if ((body = page.getBody()) != null) {
            this.renderBody(body);
        }
        if ((pageFooter = page.getPageFooter()) != null) {
            this.renderChunk(pageFooter);
            this.m_Y += pageFooter.getHeight();
        }
        this.m_Page.write(outputStream);
    }

    private void renderBody(IBody iBody) {
        for (BodyPart bodyPart : iBody.getBodyPartList()) {
            if (bodyPart instanceof Columns) {
                int n;
                int n2 = n = this.m_Y;
                Columns columns = (Columns)bodyPart;
                int n3 = columns.getColumnCount();
                for (int i = 0; i < n3; ++i) {
                    Column column = columns.getColumn(i);
                    this.renderBody(column);
                    this.m_X += column.getWidth() + column.getSpaceAfter();
                    n2 = Math.max(n2, this.m_Y);
                    this.m_Y = n;
                }
                this.m_X = 0;
                this.m_Y = n2;
                continue;
            }
            this.renderChunk(bodyPart);
            this.m_Y = this.m_Y + bodyPart.getHeight() + bodyPart.getSpaceAfter();
        }
    }

    private void renderChunk(ILogicalElementHolder iLogicalElementHolder) {
        for (LogicalElement logicalElement : iLogicalElementHolder.getLogicalElementList()) {
            if (logicalElement instanceof Text) {
                Text text = (Text)logicalElement;
                int n = text.getLeft();
                int n2 = text.getTop();
                int n3 = text.getWidth();
                String string = this.substituteVariables(text.getText());
                this.m_Page.addLine(string, this.m_X + n, this.m_Y + n2, n3, text.getTextAlign());
                continue;
            }
            if (!(logicalElement instanceof ILogicalElementHolder)) continue;
            this.renderChunk((ILogicalElementHolder)((Object)logicalElement));
        }
    }

    private String substituteVariables(String string) {
        string = StringUtil.findAndReplace(string, RenderConstants.PAGE_NUMBER_STRING, this.m_PageNumber);
        string = StringUtil.findAndReplace(string, RenderConstants.PAGE_COUNT_STRING, this.m_PageCount);
        return this.m_VariableSubstitution.substitute(string);
    }

    private class LPTPage {
        private List<LPTLine> m_Lines = new ArrayList<LPTLine>();

        private LPTPage() {
        }

        public void addLine(String string, int n, int n2, int n3, String string2) {
            LPTLine lPTLine = this.getLine(n2 / LPTRenderer.this.m_CharSize.height);
            int n4 = n / LPTRenderer.this.m_CharSize.width;
            int n5 = string.length();
            int n6 = n3 / LPTRenderer.this.m_CharSize.width;
            if ("Left".equals(string2)) {
                if (n5 > n6) {
                    string = string.substring(0, n6);
                }
                lPTLine.putString(string, n4);
            } else if ("Right".equals(string2)) {
                if (n5 > n6) {
                    string = string.substring(n5 - n6);
                    n5 = n6;
                }
                lPTLine.putString(string, n4 + n6 - n5);
            } else if ("Center".equals(string2)) {
                if (n5 > n6) {
                    int n7 = (n5 - n6) / 2;
                    string = string.substring(n7, n6);
                } else if (n5 < n6) {
                    n4 += (n6 - n5) / 2;
                }
                lPTLine.putString(string, n4);
            } else {
                m_Log.warn((Object)("Unsupported alignment: " + string2));
            }
        }

        public void write(OutputStream outputStream) throws IOException {
            Iterator<LPTLine> iterator = this.m_Lines.iterator();
            while (iterator.hasNext()) {
                int n;
                LPTLine lPTLine = iterator.next();
                char[] cArray = lPTLine.getChars();
                for (n = 0; n < cArray.length; ++n) {
                    outputStream.write(cArray[n]);
                }
                if (!iterator.hasNext()) continue;
                n = LPTRenderer.this.m_LineFeed.length();
                for (int i = 0; i < n; ++i) {
                    outputStream.write(LPTRenderer.this.m_LineFeed.charAt(i));
                }
            }
            int n = LPTRenderer.this.m_FormFeed.length();
            for (int i = 0; i < n; ++i) {
                outputStream.write(LPTRenderer.this.m_FormFeed.charAt(i));
            }
        }

        private LPTLine getLine(int n) {
            while (n >= this.m_Lines.size()) {
                this.m_Lines.add(new LPTLine());
            }
            return this.m_Lines.get(n);
        }
    }

    private static class LPTLine {
        private char[] m_Line = new char[0];

        private LPTLine() {
        }

        public void putString(String string, int n) {
            int n2 = string.length();
            if (this.m_Line.length < n + n2) {
                int n3;
                char[] cArray = new char[n + n2];
                for (n3 = 0; n3 < this.m_Line.length; ++n3) {
                    cArray[n3] = this.m_Line[n3];
                }
                for (n3 = this.m_Line.length; n3 < n; ++n3) {
                    cArray[n3] = 32;
                }
                this.m_Line = cArray;
            }
            for (int i = 0; i < n2; ++i) {
                this.m_Line[n + i] = string.charAt(i);
            }
        }

        public char[] getChars() {
            return this.m_Line;
        }
    }
}

