/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.report2.physical.odf;

import com.elixirtech.arch.LoggingHelper;
import com.elixirtech.arch.StringUtil;
import com.elixirtech.arch.XMLUtil;
import com.elixirtech.arch.logging.SLF4J;
import com.elixirtech.odf.AbstractDataStyle$;
import com.elixirtech.odf.CurrencyStyle$;
import com.elixirtech.odf.DateStyle;
import com.elixirtech.odf.NumberStyle$;
import com.elixirtech.odf.PercentageStyle$;
import com.elixirtech.odf.PresentationStyle;
import com.elixirtech.odf.PresentationStyle$;
import com.elixirtech.odf.PresentationStyle$BackgroundColor$;
import com.elixirtech.odf.PresentationStyle$BorderBottom$;
import com.elixirtech.odf.PresentationStyle$BorderLeft$;
import com.elixirtech.odf.PresentationStyle$BorderRight$;
import com.elixirtech.odf.PresentationStyle$BorderTop$;
import com.elixirtech.odf.PresentationStyle$FontColor$;
import com.elixirtech.odf.PresentationStyle$FontName$;
import com.elixirtech.odf.PresentationStyle$FontSize$;
import com.elixirtech.odf.Style;
import com.elixirtech.odf.spreadsheet.Cell;
import com.elixirtech.odf.spreadsheet.CurrencyCell;
import com.elixirtech.odf.spreadsheet.NumberCell;
import com.elixirtech.odf.spreadsheet.PercentageCell;
import com.elixirtech.odf.spreadsheet.Sheet;
import com.elixirtech.odf.spreadsheet.StringCell;
import com.elixirtech.odf.spreadsheet.TimestampCell;
import com.elixirtech.report2.logical.model.LogicalElement;
import com.elixirtech.report2.logical.model.Rectangle;
import com.elixirtech.report2.logical.model.Text;
import com.elixirtech.report2.physical.odf.OdfElement;
import com.elixirtech.report2.physical.odf.OdfRenderContext;
import com.elixirtech.report2.raw.model.Field;
import com.elixirtech.report2.raw.model.Format;
import com.elixirtech.report2.raw.model.RawModelElement;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Currency;
import java.util.Date;
import java.util.Locale;
import org.slf4j.Logger;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Some;
import scala.Some$;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.List;
import scala.collection.mutable.Growable;
import scala.collection.mutable.ListBuffer;
import scala.jdk.CollectionConverters$;
import scala.math.Ordered;
import scala.runtime.BoxedUnit;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import sourcecode.FullName$;
import sourcecode.Line$;

public class OdfText
implements Ordered,
OdfElement,
SLF4J,
LoggingHelper {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(OdfText.class.getDeclaredField("logger$lzy1"));
    private volatile Object logger$lzy1;
    private final Rectangle obj;
    private final java.awt.Rectangle rc;

    public OdfText(Rectangle obj) {
        this.obj = obj;
        Ordered.$init$((Ordered)this);
        this.rc = new java.awt.Rectangle(obj.getLeft(), obj.getTop(), obj.getWidth(), obj.getHeight());
    }

    public Logger logger() {
        Object object = this.logger$lzy1;
        if (object instanceof Logger) {
            return (Logger)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Logger)this.logger$lzyINIT1();
    }

    private Object logger$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.logger$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Logger logger = null;
                    try {
                        logger = LoggingHelper.logger$((LoggingHelper)this);
                        object2 = logger == null ? LazyVals.NullValue$.MODULE$ : logger;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.logger$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return logger;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public boolean splitNewLines() {
        return true;
    }

    @Override
    public java.awt.Rectangle rc() {
        return this.rc;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public Option<Cell> render(Sheet sheet, OdfRenderContext cxt) {
        ListBuffer pstyles;
        Text txt;
        Option parentStyle;
        Option optFormat;
        block29: {
            Growable growable;
            String valign;
            block28: {
                Growable growable2;
                String string;
                None$ none$;
                RawModelElement rawModelElement = this.obj.getRaw();
                if (rawModelElement instanceof Field) {
                    Field field2 = (Field)rawModelElement;
                    none$ = Some$.MODULE$.apply((Object)field2);
                } else {
                    none$ = None$.MODULE$;
                }
                None$ optField = none$;
                valign = (String)optField.map((Function1 & Serializable)_$1 -> _$1.getVerticalAlign()).getOrElse(OdfText::$anonfun$2);
                optFormat = optField.flatMap((Function1 & Serializable)field -> {
                    Format format;
                    block3: {
                        block2: {
                            format = field.getFormat();
                            if (format == null) break block2;
                            String string = format.getType();
                            String string2 = "None";
                            if (string != null ? !string.equals(string2) : string2 != null) break block3;
                        }
                        return None$.MODULE$;
                    }
                    return Some$.MODULE$.apply((Object)format);
                });
                parentStyle = optFormat.flatMap((Function1 & Serializable)format -> {
                    None$ none$;
                    block6: {
                        String pattern = this.getFormatPattern((Format)format);
                        String string = format.getType();
                        switch (string == null ? 0 : string.hashCode()) {
                            case -1950496919: {
                                if (!"Number".equals(string)) break;
                                none$ = Some$.MODULE$.apply((Object)NumberStyle$.MODULE$.fromPattern(pattern));
                                break block6;
                            }
                            case 640046129: {
                                if (!"Currency".equals(string)) break;
                                String currencyCode = Currency.getInstance(Locale.getDefault()).getCurrencyCode();
                                none$ = Some$.MODULE$.apply((Object)CurrencyStyle$.MODULE$.fromPattern(pattern, currencyCode));
                                break block6;
                            }
                            case 985725989: {
                                if (!"Percent".equals(string)) break;
                                none$ = Some$.MODULE$.apply((Object)PercentageStyle$.MODULE$.fromPattern(pattern));
                                break block6;
                            }
                            case 1709827214: {
                                if (!"Date/Time".equals(string)) break;
                                none$ = Some$.MODULE$.apply((Object)new DateStyle(pattern));
                                break block6;
                            }
                        }
                        none$ = None$.MODULE$;
                    }
                    None$ optStyle = none$;
                    return optStyle.map((Function1 & Serializable)s -> AbstractDataStyle$.MODULE$.getDataStyleId(cxt.doc().content().styleManager().getStyleId((Style)((Object)s))));
                });
                txt = (Text)this.obj.getLogicalElement(0);
                pstyles = new ListBuffer();
                if (txt.isFontBold()) {
                    pstyles.$plus$eq((Object)PresentationStyle$.MODULE$.Bold());
                }
                if (txt.isFontItalic()) {
                    pstyles.$plus$eq((Object)PresentationStyle$.MODULE$.Italic());
                }
                if (txt.isFontUnderline()) {
                    pstyles.$plus$eq((Object)PresentationStyle$.MODULE$.Underline());
                }
                if (txt.isFontStrikethrough()) {
                    pstyles.$plus$eq((Object)PresentationStyle$.MODULE$.Strikethrough());
                }
                switch ((string = txt.getTextAlign()) == null ? 0 : string.hashCode()) {
                    case 2364455: {
                        if (!"Left".equals(string)) break;
                        growable2 = pstyles.$plus$eq((Object)PresentationStyle$.MODULE$.HorizontalAlignLeft());
                        break block28;
                    }
                    case 78959100: {
                        if (!"Right".equals(string)) break;
                        growable2 = pstyles.$plus$eq((Object)PresentationStyle$.MODULE$.HorizontalAlignRight());
                        break block28;
                    }
                    case 415171184: {
                        if (!"Justify".equals(string)) break;
                        growable2 = pstyles.$plus$eq((Object)PresentationStyle$.MODULE$.HorizontalAlignJustify());
                        break block28;
                    }
                    case 2014820469: {
                        if (!"Center".equals(string)) break;
                        growable2 = pstyles.$plus$eq((Object)PresentationStyle$.MODULE$.HorizontalAlignCenter());
                        break block28;
                    }
                }
                this.warn(() -> OdfText.render$$anonfun$1(txt), Line$.MODULE$.apply(79), FullName$.MODULE$.apply("com.elixirtech.report2.physical.odf.OdfText.render"));
                growable2 = BoxedUnit.UNIT;
            }
            String string = valign;
            switch (string == null ? 0 : string.hashCode()) {
                case 84277: {
                    if (!"Top".equals(string)) break;
                    growable = pstyles.$plus$eq((Object)PresentationStyle$.MODULE$.VerticalAlignTop());
                    break block29;
                }
                case 1995605579: {
                    if (!"Bottom".equals(string)) break;
                    growable = pstyles.$plus$eq((Object)PresentationStyle$.MODULE$.VerticalAlignBottom());
                    break block29;
                }
                case 2014820469: {
                    if (!"Center".equals(string)) break;
                    growable = pstyles.$plus$eq((Object)PresentationStyle$.MODULE$.VerticalAlignMiddle());
                    break block29;
                }
            }
            this.warn(() -> OdfText.render$$anonfun$2(valign), Line$.MODULE$.apply(85), FullName$.MODULE$.apply("com.elixirtech.report2.physical.odf.OdfText.render"));
            growable = BoxedUnit.UNIT;
        }
        pstyles.$plus$eq((Object)PresentationStyle$FontName$.MODULE$.apply(this.odfFont(txt.getFontName())));
        pstyles.$plus$eq((Object)PresentationStyle$FontSize$.MODULE$.apply(txt.getFontSize() / 20));
        this.opt(txt.getFontColor()).foreach((Function1 & Serializable)ofg -> (ListBuffer)pstyles.$plus$eq((Object)PresentationStyle$FontColor$.MODULE$.apply(this.odfColor((String)ofg))));
        this.opt(this.obj.getBackgroundColor()).foreach((Function1 & Serializable)obg -> (ListBuffer)pstyles.$plus$eq((Object)PresentationStyle$BackgroundColor$.MODULE$.apply(this.odfColor((String)obg))));
        if (this.obj.isBorderLeft() || this.obj.isBorderTop() || this.obj.isBorderRight() || this.obj.isBorderBottom()) {
            int width = this.obj.getBorderWidth() / 20;
            String style = this.odfBorderStyle(this.obj.getBorderStyle());
            String color = this.odfColor(this.obj.getBorderColor());
            if (this.obj.isBorderLeft()) {
                pstyles.$plus$eq((Object)PresentationStyle$BorderLeft$.MODULE$.apply(width, style, color));
            }
            if (this.obj.isBorderTop()) {
                pstyles.$plus$eq((Object)PresentationStyle$BorderTop$.MODULE$.apply(width, style, color));
            }
            if (this.obj.isBorderRight()) {
                pstyles.$plus$eq((Object)PresentationStyle$BorderRight$.MODULE$.apply(width, style, color));
            }
            if (this.obj.isBorderBottom()) {
                pstyles.$plus$eq((Object)PresentationStyle$BorderBottom$.MODULE$.apply(width, style, color));
            }
        }
        PresentationStyle pstyle = PresentationStyle$.MODULE$.apply((Option<String>)None$.MODULE$, (Option<String>)parentStyle, (List<XMLUtil.Attr>)pstyles.toList());
        String styleId = cxt.doc().content().styleManager().getStyleId(pstyle);
        Option option = optFormat;
        if (option instanceof Some) {
            Format format2;
            Format format3 = format2 = (Format)((Some)option).value();
            String string = format3.getType();
            String string2 = "Currency";
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                String value = String.valueOf(this.obj.getRawValue());
                return Some$.MODULE$.apply((Object)new CurrencyCell(value, styleId));
            }
            Format format4 = format2;
            String string3 = format4.getType();
            String string4 = "Date/Time";
            if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
                Object object = this.obj.getRawValue();
                if (object instanceof Date) {
                    Date d = (Date)object;
                    return Some$.MODULE$.apply((Object)new TimestampCell(d.getTime(), styleId));
                }
                return None$.MODULE$;
            }
            Format format5 = format2;
            String string5 = format5.getType();
            String string6 = "Number";
            if (!(string5 != null ? !string5.equals(string6) : string6 != null)) {
                String value = String.valueOf(this.obj.getRawValue());
                return Some$.MODULE$.apply((Object)new NumberCell(value, styleId));
            }
            Format format6 = format2;
            String string7 = format6.getType();
            String string8 = "Percent";
            if (!(string7 != null ? !string7.equals(string8) : string8 != null)) {
                String value = String.valueOf(this.obj.getRawValue());
                return Some$.MODULE$.apply((Object)new PercentageCell(value, styleId));
            }
        }
        List txtList = ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(this.obj.getLogicalElementList()).asScala().collect((PartialFunction)new Serializable(){

            public final boolean isDefinedAt(LogicalElement x) {
                LogicalElement logicalElement = x;
                if (logicalElement instanceof Text) {
                    Text txt = (Text)logicalElement;
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(LogicalElement x, Function1 function1) {
                LogicalElement logicalElement = x;
                if (logicalElement instanceof Text) {
                    Text txt = (Text)logicalElement;
                    return txt.getText();
                }
                return function1.apply((Object)x);
            }
        })).toList();
        return Some$.MODULE$.apply((Object)new StringCell((List<String>)txtList.map((Function1 & Serializable)s -> cxt.substitute((String)s)), (Option<String>)Some$.MODULE$.apply((Object)styleId)));
    }

    public Option<String> opt(String s) {
        if (s == null) {
            return None$.MODULE$;
        }
        String test = s.trim();
        if (test.length() == 0) {
            return None$.MODULE$;
        }
        return Some$.MODULE$.apply((Object)test);
    }

    public String toString() {
        List txtList = ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(this.obj.getLogicalElementList()).asScala().collect((PartialFunction)new Serializable(){

            public final boolean isDefinedAt(LogicalElement x) {
                LogicalElement logicalElement = x;
                if (logicalElement instanceof Text) {
                    Text txt = (Text)logicalElement;
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(LogicalElement x, Function1 function1) {
                LogicalElement logicalElement = x;
                if (logicalElement instanceof Text) {
                    Text txt = (Text)logicalElement;
                    return txt.getText();
                }
                return function1.apply((Object)x);
            }
        })).toList();
        return txtList.mkString("OdfText(", "\n", ")");
    }

    public String getFormatPattern(Format format) {
        if (StringUtil.notEmpty(format.getCustomPattern())) {
            return format.getCustomPattern();
        }
        Locale locale = Locale.getDefault();
        String string = format.getType();
        switch (string == null ? 0 : string.hashCode()) {
            case -1950496919: {
                if (!"Number".equals(string)) break;
                return this.configNumberFormatter(NumberFormat.getNumberInstance(locale), format).toPattern();
            }
            case 640046129: {
                if (!"Currency".equals(string)) break;
                return this.configNumberFormatter(NumberFormat.getCurrencyInstance(locale), format).toPattern();
            }
            case 985725989: {
                if (!"Percent".equals(string)) break;
                return this.configNumberFormatter(NumberFormat.getPercentInstance(locale), format).toPattern();
            }
            case 1709827214: {
                if (!"Date/Time".equals(string)) break;
                return this.getDateTimeFormat(locale, format).toPattern();
            }
        }
        throw new MatchError((Object)string);
    }

    public SimpleDateFormat getDateTimeFormat(Locale locale, Format format) {
        int date = OdfText.getStyle$1(format.getDateFormat());
        int time = OdfText.getStyle$1(format.getTimeFormat());
        DateFormat df = date == -1 && time != -1 ? DateFormat.getTimeInstance(time, locale) : (time == -1 ? DateFormat.getDateInstance(date, locale) : DateFormat.getDateTimeInstance(date, time, locale));
        return (SimpleDateFormat)df;
    }

    private DecimalFormat configNumberFormatter(NumberFormat nf, Format format) {
        DecimalFormat df = (DecimalFormat)nf;
        df.setMinimumIntegerDigits(format.getMinIntegerDigits());
        df.setMaximumIntegerDigits(format.getMaxIntegerDigits());
        df.setMinimumFractionDigits(format.getMinFractionDigits());
        df.setMaximumFractionDigits(format.getMaxFractionDigits());
        df.setGroupingUsed(format.isGroupingUsed());
        df.setGroupingSize(format.getGroupingSize());
        df.setDecimalSeparatorAlwaysShown(format.isDecimalSeparatorAlwaysShown());
        return df;
    }

    private static final String $anonfun$2() {
        return "Top";
    }

    private static final Object render$$anonfun$1(Text txt$1) {
        return "Unknown text align: " + txt$1.getTextAlign();
    }

    private static final Object render$$anonfun$2(String valign$1) {
        return "Unknown vertical align: " + valign$1;
    }

    private static final int getStyle$1(String s) {
        String string = s;
        switch (string == null ? 0 : string.hashCode()) {
            case -1994163307: {
                if (!"Medium".equals(string)) break;
                return 2;
            }
            case 2201263: {
                if (!"Full".equals(string)) break;
                return 0;
            }
            case 2374300: {
                if (!"Long".equals(string)) break;
                return 1;
            }
            case 2433880: {
                if (!"None".equals(string)) break;
                return -1;
            }
            case 79860828: {
                if (!"Short".equals(string)) break;
                return 3;
            }
        }
        return 3;
    }
}

