/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.report2.physical.pdf;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.report2.logical.model.LogicalElement;
import com.elixirtech.report2.physical.PhysicalRenderContext;
import com.elixirtech.report2.physical.pdf.PDFRenderContext;
import com.elixirtech.report2.physical.renderer.IPhysicalRenderer;
import com.elixirtech.report2.util.MetricConvertor;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;

public abstract class BasicPhysicalRenderer
implements IPhysicalRenderer {
    private static ElxLoggerJ m_Log = ElxLoggerJ.getLogger(BasicPhysicalRenderer.class);

    @Override
    public abstract void render(PhysicalRenderContext var1, LogicalElement var2);

    protected void convertToPoints(Rectangle rectangle) {
        rectangle.x = MetricConvertor.twipToPoint(rectangle.x);
        rectangle.y = MetricConvertor.twipToPoint(rectangle.y);
        rectangle.width = MetricConvertor.twipToPoint(rectangle.width);
        rectangle.height = MetricConvertor.twipToPoint(rectangle.height);
    }

    protected void drawImage(PhysicalRenderContext physicalRenderContext, Graphics graphics, String string, Image image, int n, int n2) {
        int n3 = image.getWidth(null);
        int n4 = image.getHeight(null);
        m_Log.debug((Object)("drawImage " + n + "," + n2 + "," + n3 + "," + n4));
        ((PDFRenderContext)physicalRenderContext).drawImage(image, n, n2, n3, n4, 0, 0, n3, n4);
    }

    protected void drawImage(PhysicalRenderContext physicalRenderContext, Graphics graphics, String string, Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        m_Log.debug((Object)("drawImage dest=" + n + "," + n2 + "," + n3 + "," + n4));
        m_Log.debug((Object)("           src=" + n5 + "," + n6 + "," + n7 + "," + n8));
        ((PDFRenderContext)physicalRenderContext).drawImage(image, n, n2, n3 - n, n4 - n2, n5, n6, n7 - n5, n8 - n6);
    }

    protected void drawImage(PhysicalRenderContext physicalRenderContext, Graphics graphics, com.lowagie.text.Image image, float f, float f2) {
        float f3 = image.getWidth() * 20.0f;
        float f4 = image.getHeight() * 20.0f;
        ((PDFRenderContext)physicalRenderContext).drawImage(image, new Rectangle2D.Float(f, f2, f3, f4), new Rectangle2D.Float(0.0f, 0.0f, f3, f4));
    }

    protected void drawImage(PhysicalRenderContext physicalRenderContext, Graphics graphics, com.lowagie.text.Image image, Rectangle2D rectangle2D, Rectangle2D rectangle2D2) {
        ((PDFRenderContext)physicalRenderContext).drawImage(image, rectangle2D, rectangle2D2);
    }
}

