/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.report2.physical.pdf;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.arch.StringUtil;
import com.elixirtech.graphics.GlyphOrientation;
import com.elixirtech.graphics.WritingMode;
import com.elixirtech.graphics.font.AWTFontMeasurerFactory;
import com.elixirtech.graphics.font.Font;
import com.elixirtech.graphics.font.IFontMeasurer;
import com.elixirtech.graphics.grid.GGrid;
import com.elixirtech.report2.logical.model.Grid;
import com.elixirtech.report2.logical.model.LogicalElement;
import com.elixirtech.report2.physical.GraphicalRenderContext;
import com.elixirtech.report2.physical.PhysicalRenderContext;
import com.elixirtech.report2.physical.pdf.BasicPhysicalRenderer;
import com.elixirtech.report2.physical.pdf.PDFRenderContext;
import com.elixirtech.ui.StandardColor;
import com.lowagie.text.pdf.PdfAction;
import com.lowagie.text.pdf.PdfContentByte;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Point2D;

public class GridRenderer
extends BasicPhysicalRenderer {
    public static final String TEXT_HEIGHT = "Text-Height";
    public static final String LINE_HEIGHT = "Line-Height";
    public static final String BOX_COUNT = "Box-Count";
    private static final ElxLoggerJ m_Log = ElxLoggerJ.getLogger(GridRenderer.class);

    @Override
    public void render(PhysicalRenderContext physicalRenderContext, LogicalElement logicalElement) {
        Grid grid = (Grid)logicalElement;
        GraphicalRenderContext graphicalRenderContext = (GraphicalRenderContext)physicalRenderContext;
        GGrid gGrid = GridRenderer.buildGrid(grid);
        Graphics2D graphics2D = (Graphics2D)graphicalRenderContext.getGraphics();
        graphics2D.scale(0.05, 0.05);
        gGrid.draw(graphics2D);
        graphics2D.scale(20.0, 20.0);
        String string = grid.getURL();
        if (StringUtil.notEmpty(string) && physicalRenderContext instanceof PDFRenderContext) {
            PDFRenderContext pDFRenderContext = (PDFRenderContext)physicalRenderContext;
            PdfContentByte pdfContentByte = pDFRenderContext.getDirectContent();
            PdfAction pdfAction = new PdfAction(string);
            int n = grid.getLeft();
            int n2 = grid.getTop();
            int n3 = grid.getWidth();
            int n4 = grid.getHeight();
            Point2D point2D = pDFRenderContext.transform(n / 20, (n2 + n4) / 20);
            Point2D point2D2 = pDFRenderContext.transform((n + n3) / 20, n2 / 20);
            pdfContentByte.setAction(pdfAction, (float)point2D.getX(), (float)point2D.getY(), (float)point2D2.getX(), (float)point2D2.getY());
        }
    }

    public static GGrid buildGrid(Grid grid) {
        int n = grid.getLeft();
        int n2 = grid.getTop();
        int n3 = grid.getWidth();
        int n4 = grid.getHeight();
        String string = grid.getLineGridProgression();
        Font font = new Font(grid.getFontName(), grid.isFontBold(), grid.isFontItalic(), grid.getFontSize());
        AWTFontMeasurerFactory aWTFontMeasurerFactory = new AWTFontMeasurerFactory();
        IFontMeasurer iFontMeasurer = aWTFontMeasurerFactory.getInstance(font);
        Rectangle rectangle = new Rectangle(n, n2, n3, n4);
        int n5 = (int)(iFontMeasurer.getAscent() + iFontMeasurer.getDescent());
        int n6 = (int)iFontMeasurer.getHeight();
        if (!TEXT_HEIGHT.equals(string)) {
            if (LINE_HEIGHT.equals(string)) {
                n5 = (int)iFontMeasurer.getHeight();
            } else if (string.startsWith(BOX_COUNT)) {
                int n7 = 1;
                String string2 = string.substring(BOX_COUNT.length()).trim();
                String[] stringArray = string2.split("\\s+");
                for (int i = 0; i < stringArray.length; ++i) {
                    try {
                        n7 = Integer.parseInt(stringArray[0].trim());
                        if (n7 <= 0) {
                            m_Log.warn((Object)("Box-Count <=0 : " + n7));
                            n7 = 1;
                        }
                        n5 = rectangle.width / n7;
                        continue;
                    }
                    catch (NumberFormatException numberFormatException) {
                        m_Log.warn((Object)("Bad Box-Count: " + string));
                    }
                }
                if (stringArray.length > 1) {
                    n7 = 1;
                    try {
                        n7 = Integer.parseInt(stringArray[1].trim());
                        if (n7 <= 0) {
                            m_Log.warn((Object)("Box-Count <=0 : " + n7));
                            n7 = 1;
                        }
                        n6 = rectangle.height / n7;
                    }
                    catch (NumberFormatException numberFormatException) {
                        m_Log.warn((Object)("Bad Box-Count: " + string));
                    }
                }
            } else {
                try {
                    n5 = Integer.parseInt(string.trim());
                }
                catch (NumberFormatException numberFormatException) {
                    m_Log.warn((Object)("Bad LineGridProgression: " + string));
                    n5 = (int)(iFontMeasurer.getAscent() + iFontMeasurer.getDescent());
                }
            }
        }
        GGrid gGrid = new GGrid();
        gGrid.setBoxSize(new Dimension(n5, n6));
        gGrid.setConstructionColor(null);
        gGrid.setFont(Font.getAWTFont20(font), iFontMeasurer);
        gGrid.setFontColor(StandardColor.lookup(grid.getFontColor()));
        gGrid.setFontUnderline(grid.isFontUnderline());
        gGrid.setFontStrikethrough(grid.isFontStrikethrough());
        gGrid.setGlyphOrientation(GlyphOrientation.get(grid.getGlyphOrientation()));
        gGrid.setGridMode(grid.getLineGridMode().equals("Ideograph") ? 1 : 2);
        gGrid.setRectangle(rectangle);
        gGrid.setString(grid.getText());
        gGrid.setWritingMode(WritingMode.get(grid.getWritingMode()));
        gGrid.setCharacterOffset(grid.getCharacterOffsetX(), grid.getCharacterOffsetY());
        gGrid.setBoxDrawing(StandardColor.lookup(grid.getBoxBorderColor()), grid.isBoxBorderTop(), grid.isBoxBorderSide(), grid.isBoxBorderBottom(), grid.getBoxBorderHeight());
        return gGrid;
    }
}

