/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.report2.physical.pdf;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.graphics.BorderStyle;
import com.elixirtech.graphics.GLine;
import com.elixirtech.graphics.ILineDrawable;
import com.elixirtech.report2.logical.model.Line;
import com.elixirtech.report2.logical.model.LogicalElement;
import com.elixirtech.report2.physical.GraphicalRenderContext;
import com.elixirtech.report2.physical.PhysicalConstants;
import com.elixirtech.report2.physical.PhysicalRenderContext;
import com.elixirtech.report2.physical.renderer.IPhysicalRenderer;
import com.elixirtech.ui.StandardColor;
import com.lowagie.text.pdf.PdfGraphics2D;
import java.awt.Color;
import java.awt.Shape;
import java.awt.Stroke;

public class LineRenderer
implements IPhysicalRenderer,
PhysicalConstants {
    private static ElxLoggerJ m_Log = ElxLoggerJ.getLogger(LineRenderer.class);

    @Override
    public void render(PhysicalRenderContext physicalRenderContext, LogicalElement logicalElement) {
        GraphicalRenderContext graphicalRenderContext = (GraphicalRenderContext)physicalRenderContext;
        Line line = (Line)logicalElement;
        int n = line.getLeft();
        int n2 = line.getTop();
        int n3 = line.getWidth();
        int n4 = line.getHeight();
        int n5 = line.getDivisor();
        int n6 = n + line.getX1() * n3 / n5;
        int n7 = n2 + line.getY1() * n4 / n5;
        int n8 = n + line.getX2() * n3 / n5;
        int n9 = n2 + line.getY2() * n4 / n5;
        GLine gLine = new GLine();
        gLine.setLine(n6, n7, n8, n9);
        gLine.setLineWidth(line.getLineWidth());
        gLine.setLineColor(StandardColor.lookup(line.getLineColor(), Color.BLACK));
        gLine.setLineStyle(BorderStyle.get(line.getLineStyle()));
        gLine.setArrowStyle1(line.getArrowStyle1());
        gLine.setArrowStyle2(line.getArrowStyle2());
        gLine.setArrowWidth1(line.getArrowWidth1());
        gLine.setArrowWidth2(line.getArrowWidth2());
        gLine.setArrowColor1(StandardColor.lookup(line.getArrowColor1(), Color.BLACK));
        gLine.setArrowColor2(StandardColor.lookup(line.getArrowColor2(), Color.BLACK));
        PdfGraphics2D pdfGraphics2D = (PdfGraphics2D)graphicalRenderContext.getGraphics();
        pdfGraphics2D.scale(0.05, 0.05);
        PDFG2D pDFG2D = new PDFG2D(pdfGraphics2D);
        gLine.draw(pDFG2D);
        pdfGraphics2D.scale(20.0, 20.0);
    }

    protected ElxLoggerJ getLog() {
        return m_Log;
    }

    public static class PDFG2D
    implements ILineDrawable {
        private PdfGraphics2D m_PdfGraphics2D;

        public PDFG2D(PdfGraphics2D pdfGraphics2D) {
            this.m_PdfGraphics2D = pdfGraphics2D;
        }

        @Override
        public void setColor(Color color) {
            this.m_PdfGraphics2D.setColor(color);
        }

        @Override
        public void draw(Shape shape) {
            this.m_PdfGraphics2D.draw(shape);
        }

        @Override
        public void fill(Shape shape) {
            this.m_PdfGraphics2D.fill(shape);
        }

        @Override
        public void setStroke(Stroke stroke) {
            this.m_PdfGraphics2D.setStroke(stroke);
        }
    }
}

