/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.report2.physical.pdf;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.arch.MimeTypes;
import com.elixirtech.arch.StringUtil;
import com.elixirtech.arch.util.StringStepper;
import com.elixirtech.graphics.TextAlignment;
import com.elixirtech.graphics.font.Font;
import com.elixirtech.pdf.ElxPdfGraphics2D;
import com.elixirtech.report2.font.FontUtil;
import com.elixirtech.report2.logical.model.LogicalElement;
import com.elixirtech.report2.logical.model.Text;
import com.elixirtech.report2.physical.GraphicalRenderContext;
import com.elixirtech.report2.physical.PhysicalRenderContext;
import com.elixirtech.report2.physical.pdf.PDFRenderContext;
import com.elixirtech.report2.physical.renderer.IPhysicalRenderer;
import com.elixirtech.report2.raw.model.RenderDetails;
import com.elixirtech.ui.StandardColor;
import com.lowagie.text.Chunk;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Phrase;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.ColumnText;
import com.lowagie.text.pdf.FontSelector;
import com.lowagie.text.pdf.PdfAction;
import com.lowagie.text.pdf.PdfAnnotation;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfFormField;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.text.AttributedString;
import java.util.Random;

public class TextRenderer2
implements IPhysicalRenderer {
    private static final boolean AVOID_TEXTLAYOUT = true;
    private static final boolean SAVE_STATE = true;
    private static final Random GENERATOR = new Random(System.currentTimeMillis());
    public static boolean OPTIMIZED = true;
    private static ElxLoggerJ m_Log = ElxLoggerJ.getLogger(TextRenderer2.class);

    @Override
    public void render(PhysicalRenderContext physicalRenderContext, LogicalElement logicalElement) {
        boolean bl = false;
        RenderDetails renderDetails = physicalRenderContext.getRenderDetails(MimeTypes.PDF());
        if (renderDetails != null) {
            bl = renderDetails.isSet("RenderTextAPI");
        }
        Text text = (Text)logicalElement;
        if (!(physicalRenderContext instanceof PDFRenderContext)) {
            this.simpleRender(physicalRenderContext, text);
        } else if (text.getOrientation() != 0 || !bl) {
            this.simpleRender(physicalRenderContext, text);
        } else {
            this.APIRender((PDFRenderContext)physicalRenderContext, text);
        }
    }

    private void simpleRender(PhysicalRenderContext physicalRenderContext, Text text) {
        Object object;
        int n;
        String string = physicalRenderContext.substituteVariables(text.getText());
        if (StringUtil.isEmpty(string)) {
            return;
        }
        GraphicalRenderContext graphicalRenderContext = (GraphicalRenderContext)physicalRenderContext;
        float f = (float)text.getLeft() / 20.0f;
        float f2 = (float)text.getTop() / 20.0f;
        float f3 = (float)text.getWidth() / 20.0f;
        float f4 = (float)text.getHeight() / 20.0f;
        TextAlignment textAlignment = TextAlignment.get(text.getTextAlign());
        Font font = FontUtil.getFont(text);
        Graphics2D graphics2D = (Graphics2D)graphicalRenderContext.getGraphics();
        java.awt.Font font2 = FontUtil.getAWTFont(font);
        graphics2D.setFont(font2);
        Color color = StandardColor.lookup(text.getFontColor());
        if (color == StandardColor.NONE) {
            return;
        }
        graphics2D.setColor(color);
        FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
        AttributedString attributedString = new AttributedString(string);
        attributedString.addAttribute(TextAttribute.FONT, graphics2D.getFont());
        attributedString.addAttribute(TextAttribute.FOREGROUND, graphics2D.getColor());
        if (text.isFontBold()) {
            attributedString.addAttribute(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD);
        }
        if (text.isFontItalic()) {
            attributedString.addAttribute(TextAttribute.POSTURE, TextAttribute.POSTURE_OBLIQUE);
        }
        if (text.isFontUnderline()) {
            attributedString.addAttribute(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
        }
        if (text.isFontStrikethrough()) {
            attributedString.addAttribute(TextAttribute.STRIKETHROUGH, TextAttribute.STRIKETHROUGH_ON);
        }
        TextLayout textLayout = new TextLayout(attributedString.getIterator(), fontRenderContext);
        float f5 = 0.0f;
        for (n = text.getOrientation(); n < 0; n += 360) {
        }
        while (n >= 360) {
            n -= 360;
        }
        if (n < 90) {
            graphics2D.translate(f, f2);
            f5 = f3;
        } else if (n < 180) {
            graphics2D.translate(f + f3, f2);
            graphics2D.rotate(1.5707963267948966);
            f5 = f4;
        } else if (n < 270) {
            graphics2D.translate(f + f3, f2 + f4);
            graphics2D.rotate(Math.PI);
            f5 = f3;
        } else {
            graphics2D.translate(f, f2 + f4);
            graphics2D.rotate(-1.5707963267948966);
            f5 = f4;
        }
        if (textAlignment == TextAlignment.LEFT || textAlignment == TextAlignment.RIGHT || textAlignment == TextAlignment.CENTER) {
            float f6 = 0.0f;
            float f7 = textLayout.getAdvance();
            if (textAlignment == TextAlignment.RIGHT) {
                f6 = f5 - f7;
            } else if (textAlignment == TextAlignment.CENTER) {
                f6 = (f5 - f7) / 2.0f;
            }
            float f8 = textLayout.getAscent();
            graphics2D.drawString(string, f6, f8);
            if (text.isFontUnderline() || text.isFontStrikethrough()) {
                GeneralPath generalPath;
                float f9;
                float f10;
                object = font2.getLineMetrics(string, fontRenderContext);
                if (text.isFontUnderline()) {
                    f10 = ((LineMetrics)object).getUnderlineOffset() + f8;
                    f9 = ((LineMetrics)object).getUnderlineThickness();
                    graphics2D.setStroke(new BasicStroke(f9));
                    generalPath = new GeneralPath();
                    generalPath.moveTo(f6, f10);
                    generalPath.lineTo(f6 + f7, f10);
                    graphics2D.draw(generalPath);
                }
                if (text.isFontStrikethrough()) {
                    f10 = ((LineMetrics)object).getStrikethroughOffset() + f8;
                    f9 = ((LineMetrics)object).getStrikethroughThickness();
                    graphics2D.setStroke(new BasicStroke(f9));
                    generalPath = new GeneralPath();
                    generalPath.moveTo(f6, f10);
                    generalPath.lineTo(f6 + f7, f10);
                    graphics2D.draw(generalPath);
                }
            }
        } else if (textAlignment == TextAlignment.JUSTIFY) {
            textLayout = textLayout.getJustifiedLayout(f5);
            textLayout.draw(graphics2D, 0.0f, textLayout.getAscent());
        }
        if (n < 90) {
            graphics2D.translate(-f, -f2);
        } else if (n < 180) {
            graphics2D.rotate(-1.5707963267948966);
            graphics2D.translate(-f - f3, -f2);
        } else if (n < 270) {
            graphics2D.rotate(-Math.PI);
            graphics2D.translate(-f - f3, -f2 - f4);
        } else {
            graphics2D.rotate(1.5707963267948966);
            graphics2D.translate(-f, -f2 - f4);
        }
        String string2 = text.getURL();
        if (StringUtil.notEmpty(string2) && physicalRenderContext instanceof PDFRenderContext) {
            PDFRenderContext pDFRenderContext = (PDFRenderContext)physicalRenderContext;
            PdfContentByte pdfContentByte = pDFRenderContext.getDirectContent();
            object = new PdfAction(string2);
            Point2D point2D = pDFRenderContext.transform(f, f2 + f4);
            Point2D point2D2 = pDFRenderContext.transform(f + f3, f2);
            pdfContentByte.setAction((PdfAction)object, (float)point2D.getX(), (float)point2D.getY(), (float)point2D2.getX(), (float)point2D2.getY());
        }
    }

    private void APIRender(PDFRenderContext pDFRenderContext, Text text) {
        ElxPdfGraphics2D elxPdfGraphics2D;
        int n;
        String string = text.getText();
        if (StringUtil.isEmpty(string = pDFRenderContext.substituteVariables(string))) {
            return;
        }
        Color color = StandardColor.lookup(text.getFontColor());
        if (color == StandardColor.NONE) {
            return;
        }
        PageNo pageNo = null;
        if (pDFRenderContext.useTemplatePageCount() && (n = string.indexOf("${##")) >= 0) {
            pageNo = new PageNo();
            pageNo.idx = n;
            pageNo.width = 4;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(string.substring(0, pageNo.idx));
            String string2 = string.substring(n + 4);
            StringStepper stringStepper = new StringStepper(string2);
            String string3 = stringStepper.upTo(Character.valueOf('}'));
            if (StringUtil.notEmpty(string3)) {
                try {
                    pageNo.width = Integer.parseInt(string3);
                }
                catch (NumberFormatException numberFormatException) {
                    m_Log.warn((Object)("Can't parse page number width: " + string3));
                }
            }
            for (int i = 0; i < pageNo.width; ++i) {
                stringBuilder.append('0');
            }
            stringStepper.advance();
            if (!stringStepper.atEnd()) {
                stringBuilder.append(stringStepper.remainder());
            }
            string = stringBuilder.toString();
        }
        PDFRenderContext pDFRenderContext2 = pDFRenderContext;
        int n2 = text.getLeft() / 20;
        int n3 = text.getTop() / 20;
        int n4 = text.getWidth() / 20;
        int n5 = text.getHeight() / 20;
        java.awt.Rectangle rectangle = new java.awt.Rectangle(n2, n3, n4, n5);
        TextAlignment textAlignment = TextAlignment.get(text.getTextAlign());
        Font font = FontUtil.getFont(text);
        java.awt.Font font2 = FontUtil.getAWTFont(font);
        TextLayout textLayout = new TextLayout(string, font2, (elxPdfGraphics2D = (ElxPdfGraphics2D)pDFRenderContext2.getGraphics()).getFontRenderContext());
        boolean bl = !textLayout.isLeftToRight();
        AffineTransform affineTransform = elxPdfGraphics2D.getTransform();
        rectangle.x = (int)((double)rectangle.x + affineTransform.getTranslateX());
        rectangle.y = (int)((double)rectangle.y + affineTransform.getTranslateY());
        try {
            boolean bl2;
            PdfContentByte pdfContentByte = pDFRenderContext2.getDirectContent();
            pdfContentByte.saveState();
            BaseFont baseFont = pDFRenderContext2.getFontMapper().awtToPdf(font2);
            boolean bl3 = textAlignment == TextAlignment.JUSTIFY;
            boolean bl4 = "UnicodeBigUnmarked".equals(baseFont.getEncoding());
            boolean bl5 = bl2 = !text.isFontStrikethrough() && !text.isFontUnderline();
            if (bl4 && (text.isFontBold() || text.isFontItalic())) {
                bl2 = false;
            }
            boolean bl6 = StringUtil.isEmpty(text.getURL());
            if (OPTIMIZED && bl2 && bl6 && !bl && !bl3 && pageNo == null) {
                float f = (float)pDFRenderContext2.getPageHeight() / 20.0f;
                float f2 = rectangle.x;
                float f3 = f - (float)rectangle.y - (float)text.getAscent() / 20.0f - 1.0f;
                pdfContentByte.setFontAndSize(baseFont, font2.getSize());
                pdfContentByte.setColorFill(color);
                if (textAlignment == TextAlignment.LEFT) {
                    pdfContentByte.beginText();
                    pdfContentByte.showTextAligned(0, string, f2, f3, 0.0f);
                    pdfContentByte.endText();
                } else if (textAlignment == TextAlignment.RIGHT) {
                    pdfContentByte.beginText();
                    pdfContentByte.showTextAligned(2, string, f2 += (float)text.getWidth() / 20.0f, f3, 0.0f);
                    pdfContentByte.endText();
                } else if (textAlignment == TextAlignment.CENTER) {
                    pdfContentByte.beginText();
                    pdfContentByte.showTextAligned(1, string, f2 += (float)text.getWidth() / 40.0f, f3, 0.0f);
                    pdfContentByte.endText();
                }
            } else {
                com.lowagie.text.Font font3 = TextRenderer2.buildFont(pDFRenderContext2, text, baseFont, color);
                ColumnText columnText = new ColumnText(pdfContentByte);
                int n6 = 0;
                if (textAlignment == TextAlignment.LEFT) {
                    if (bl) {
                        n6 = 2;
                    }
                } else if (textAlignment == TextAlignment.RIGHT) {
                    n6 = bl ? 0 : 2;
                } else if (textAlignment == TextAlignment.CENTER) {
                    n6 = 1;
                } else if (bl3) {
                    n6 = 8;
                }
                Phrase phrase = this.getPhrase(pDFRenderContext2, text, string, font3, pageNo, pDFRenderContext2.getWriter());
                int n7 = pDFRenderContext2.getPageHeight() / 20;
                float f = rectangle.x;
                float f4 = (float)(n7 - rectangle.y) - textLayout.getAscent();
                float f5 = rectangle.x + rectangle.width;
                float f6 = n7 - rectangle.y - font.getSize() + 1;
                if (!bl) {
                    columnText.setRunDirection(2);
                } else {
                    columnText.setRunDirection(3);
                }
                columnText.addText(phrase);
                float f7 = baseFont.getWidthPoint(string, (float)font.getSize() / 20.0f);
                if (f7 > f5 - f) {
                    if (TextAlignment.LEFT.equals(textAlignment)) {
                        f5 = (float)Math.ceil(f + f7);
                    } else if (TextAlignment.RIGHT.equals(textAlignment)) {
                        f = (float)Math.floor(f5 - f7);
                    } else if (TextAlignment.CENTER.equals(textAlignment)) {
                        float f8 = f7 - (f5 - f);
                        f = (float)Math.floor(f - f8 / 2.0f);
                        f5 = f + (float)Math.ceil(f7);
                    } else if (bl3) {
                        f5 = f + f7;
                    }
                }
                columnText.setSimpleColumn(f, f4, f5, f6, 0.0f, n6);
                columnText.go();
                if (pageNo != null) {
                    float f9;
                    if (!pDFRenderContext.hasPageCountTemplate()) {
                        pDFRenderContext.definePageCountTemplate(baseFont, (float)font.getSize() / 20.0f);
                    }
                    String string4 = string.substring(0, pageNo.idx);
                    float f10 = baseFont.getWidthPoint(string4, (float)font.getSize() / 20.0f);
                    if (TextAlignment.LEFT.equals(textAlignment)) {
                        f9 = f + f10;
                    } else if (TextAlignment.RIGHT.equals(textAlignment)) {
                        f9 = f5 - f7 + f10;
                    } else if (TextAlignment.CENTER.equals(textAlignment)) {
                        float f11 = f5 - f - f7;
                        f9 = f + f11 / 2.0f + f10;
                    } else {
                        f9 = f + f10;
                    }
                    pdfContentByte.setColorFill(color);
                    pdfContentByte.addTemplate(pDFRenderContext.getPageCountTemplate(), f9, f4);
                    pdfContentByte.resetRGBColorFill();
                }
            }
            pdfContentByte.restoreState();
        }
        catch (Exception exception) {
            m_Log.error((Object)("drawText: " + exception));
            exception.printStackTrace();
        }
    }

    protected static com.lowagie.text.Font buildFont(PDFRenderContext pDFRenderContext, Text text, BaseFont baseFont, Color color) {
        int n = 0;
        boolean bl = pDFRenderContext.isPostscriptNameTTCFont(baseFont.getPostscriptFontName());
        if (bl || "UnicodeBigUnmarked".equals(baseFont.getEncoding())) {
            if (text.isFontItalic()) {
                n |= 2;
            }
            if (text.isFontBold()) {
                n |= 1;
            }
        }
        if (text.isFontUnderline()) {
            n |= 4;
        }
        if (text.isFontStrikethrough()) {
            n |= 8;
        }
        com.lowagie.text.Font font = new com.lowagie.text.Font(baseFont, (float)text.getFontSize() / 20.0f, n, color);
        return font;
    }

    protected Phrase getPhrase(PDFRenderContext pDFRenderContext, Text text, String string, com.lowagie.text.Font font, PageNo pageNo, PdfWriter pdfWriter) throws DocumentException, IOException {
        Object object;
        if (pageNo == null) {
            String string2 = text.getURL();
            if (string2 == null || string2.trim().length() == 0) {
                if (pDFRenderContext.isUseFontSelector()) {
                    FontSelector fontSelector = new FontSelector();
                    fontSelector.addFont(font);
                    pDFRenderContext.updateFontSelector(fontSelector, font);
                    return fontSelector.process(string);
                }
                return new Phrase(string, font);
            }
            Chunk chunk = new Chunk(string, font);
            chunk.setAnnotation(TextRenderer2.createButtonLink(pdfWriter, text.getId(), text.getURL(), text.getURLDescription()));
            return new Phrase(chunk);
        }
        String string3 = text.getURL();
        Chunk chunk = new Chunk(string.substring(0, pageNo.idx), font);
        Chunk chunk2 = new Chunk(string.substring(pageNo.idx, pageNo.idx + pageNo.width), font);
        chunk2.setTextRenderMode(3, 0.0f, null);
        Chunk chunk3 = new Chunk(string.substring(pageNo.idx + pageNo.width), font);
        if (StringUtil.notEmpty(string3)) {
            object = TextRenderer2.createButtonLink(pdfWriter, text.getId(), text.getURL(), text.getURLDescription());
            chunk.setAnnotation((PdfAnnotation)object);
            chunk2.setAnnotation((PdfAnnotation)object);
            chunk3.setAnnotation((PdfAnnotation)object);
        }
        object = new Phrase();
        ((Phrase)object).add(chunk);
        ((Phrase)object).add(chunk2);
        ((Phrase)object).add(chunk3);
        return object;
    }

    protected ElxLoggerJ getLog() {
        return m_Log;
    }

    private static PdfFormField createButtonLink(PdfWriter pdfWriter, String string, String string2, String string3) {
        PdfFormField pdfFormField = PdfFormField.createPushButton(pdfWriter);
        pdfFormField.setAction(new PdfAction(string2));
        pdfFormField.setWidget(new Rectangle(0.0f, 0.0f, 0.0f, 0.0f), PdfAnnotation.HIGHLIGHT_NONE);
        Object object = string;
        String string4 = Integer.toString(GENERATOR.nextInt());
        object = StringUtil.isEmpty((String)object) ? string4 : (String)object + string4;
        pdfFormField.setFieldName((String)object);
        if (!StringUtil.isEmpty(string3)) {
            pdfFormField.setUserName(string3);
        } else {
            pdfFormField.setUserName(string2);
        }
        return pdfFormField;
    }

    private static class PageNo {
        public int idx;
        public int width;

        private PageNo() {
        }
    }
}

