/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.report2.physical.ppt;

import com.elixirtech.graphics.grid.GGrid;
import com.elixirtech.opc.ppt.Slide;
import com.elixirtech.report2.logical.model.Grid;
import com.elixirtech.report2.physical.ppt.PPTRenderer;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.IOException;

public class GridRenderer {
    private final PPTRenderer m_Renderer;
    private final Slide m_Slide;
    private final Grid m_Grid;

    public GridRenderer(PPTRenderer pPTRenderer, Slide slide, Grid grid) throws IOException {
        this.m_Renderer = pPTRenderer;
        this.m_Slide = slide;
        this.m_Grid = grid;
        int n = this.m_Renderer.getXOffset();
        int n2 = this.m_Renderer.getYOffset();
        int n3 = this.m_Grid.getLeft();
        int n4 = this.m_Grid.getTop();
        int n5 = this.m_Grid.getWidth();
        int n6 = this.m_Grid.getHeight();
        GGrid gGrid = this.buildGrid();
        BufferedImage bufferedImage = new BufferedImage(n5 / 20, n6 / 20, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.scale(0.05, 0.05);
        graphics2D.translate(-n3, -n4);
        gGrid.draw(graphics2D);
        graphics2D.dispose();
        Rectangle rectangle = new Rectangle(n3 + n, n4 + n2, n5, n6);
        this.m_Slide.addImage(rectangle, bufferedImage);
    }

    private GGrid buildGrid() {
        return com.elixirtech.report2.physical.pdf.GridRenderer.buildGrid(this.m_Grid);
    }
}

