/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.report2.physical.sxlsx;

import com.elixirtech.arch.LoggingHelper2;
import com.elixirtech.arch.LoggingInterface;
import com.elixirtech.report2.physical.sxlsx.Element;
import com.elixirtech.report2.physical.sxlsx.Position;
import com.elixirtech.report2.physical.sxlsx.SXLSXGenerator;
import com.elixirtech.report2.raw.model.PageSetup;
import java.io.Serializable;
import org.apache.poi.ss.usermodel.PrintSetup;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.streaming.SXSSFDrawing;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.collection.mutable.ArrayBuffer;
import scala.math.Ordering$;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.RichInt$;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction1;
import sourcecode.FullName$;
import sourcecode.Line$;

public class Sheet
implements LoggingHelper2 {
    public static final long OFFSET$1 = LazyVals$.MODULE$.getOffsetStatic(Sheet.class.getDeclaredField("log$lzy1"));
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(Sheet.class.getDeclaredField("drawing$lzy1"));
    private volatile Object log$lzy1;
    private final SXLSXGenerator gen;
    private int x;
    private int y;
    private final ArrayBuffer<Element> elements;
    private final Position colPosition;
    private final Position rowPosition;
    private final SXSSFSheet sheet;
    private final PrintSetup printSetup;
    private volatile Object drawing$lzy1;

    public Sheet(SXLSXGenerator gen, String title, PageSetup ps) {
        this.gen = gen;
        this.x = 0;
        this.y = 0;
        int snapValue = gen.getSnapValue();
        this.elements = new ArrayBuffer();
        this.colPosition = new Position(snapValue);
        this.rowPosition = new Position(snapValue);
        this.sheet = gen.workbook().createSheet(title);
        if (gen.isLockCells()) {
            this.sheet().protectSheet("this-is-to-prevent-users-editing-cells");
        }
        this.printSetup = this.sheet().getPrintSetup();
        this.printSetup().setLandscape("Landscape".equals(ps.getOrientation()));
    }

    public LoggingInterface log() {
        Object object = this.log$lzy1;
        if (object instanceof LoggingInterface) {
            return (LoggingInterface)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (LoggingInterface)this.log$lzyINIT1();
    }

    private Object log$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.log$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    LoggingInterface loggingInterface = null;
                    try {
                        loggingInterface = LoggingHelper2.log$((LoggingHelper2)this);
                        object2 = loggingInterface == null ? LazyVals.NullValue$.MODULE$ : loggingInterface;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.log$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return loggingInterface;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public SXSSFSheet sheet() {
        return this.sheet;
    }

    public PrintSetup printSetup() {
        return this.printSetup;
    }

    public SXSSFDrawing drawing() {
        Object object = this.drawing$lzy1;
        if (object instanceof SXSSFDrawing) {
            return (SXSSFDrawing)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (SXSSFDrawing)this.drawing$lzyINIT1();
    }

    private Object drawing$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.drawing$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    SXSSFDrawing sXSSFDrawing = null;
                    try {
                        sXSSFDrawing = this.sheet().createDrawingPatriarch();
                        object2 = sXSSFDrawing == null ? LazyVals.NullValue$.MODULE$ : sXSSFDrawing;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.drawing$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return sXSSFDrawing;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public void offsetX(int off) {
        this.x += off;
    }

    public void offsetY(int off) {
        this.y += off;
    }

    public void setX(int nx) {
        this.x = nx;
    }

    public void setY(int ny) {
        this.y = ny;
    }

    public void add(Element e) {
        e.offset(this.x, this.y);
        e.setSheet(this, this.colPosition, this.rowPosition);
        this.elements.$plus$eq((Object)e);
    }

    public SXSSFRow getRowFromPosition(int pos) {
        int rowIdx = this.rowPosition.getIndex(pos);
        return this.getRow(rowIdx);
    }

    public SXSSFRow getRow(int rowIdx) {
        return (SXSSFRow)Option$.MODULE$.apply((Object)this.sheet().getRow(rowIdx)).getOrElse(() -> this.getRow$$anonfun$1(rowIdx));
    }

    public int getRowIdx(int pos) {
        return this.rowPosition.getIndex(pos);
    }

    public int getColumnIdx(int pos) {
        return this.colPosition.getIndex(pos);
    }

    public void render() {
        int colCount = this.colPosition.getSize();
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), colCount - 1).foreach((Function1)(JFunction1.mcVI.sp & Serializable)columnIndex -> {
            int diff = this.colPosition.get(columnIndex + 1) - this.colPosition.get(columnIndex);
            int width = diff * this.gen.multiplier();
            this.sheet().setColumnWidth(columnIndex, width);
        });
        int rowCount = this.rowPosition.getSize();
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), rowCount - 1).foreach((Function1)(JFunction1.mcVI.sp & Serializable)rowIndex -> {
            int height = this.rowPosition.get(rowIndex + 1) - this.rowPosition.get(rowIndex);
            this.getRow(rowIndex).setHeight((short)(height * 20));
        });
        ArrayBuffer es = (ArrayBuffer)this.elements.sorted(Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms()));
        try {
            es.foreach((Function1)(JProcedure1 & Serializable)_$1 -> _$1.render(this.gen));
        }
        catch (Exception ex) {
            this.log().error(() -> Sheet.render$$anonfun$4(ex), (Throwable)ex, Line$.MODULE$.apply(78), FullName$.MODULE$.apply("com.elixirtech.report2.physical.sxlsx.Sheet.render"));
        }
        this.elements.clear();
    }

    public int getRowSpan(Element e) {
        return this.rowPosition.getSpan(e.top(), e.bottom());
    }

    public int getColSpan(Element e) {
        return this.colPosition.getSpan(e.left(), e.right());
    }

    public Option<CellRangeAddress> mergeCells(int x, int xSpan, int y, int ySpan) {
        Some some;
        try {
            CellRangeAddress cra = new CellRangeAddress(y, y + ySpan - 1, x, x + xSpan - 1);
            this.sheet().addMergedRegion(cra);
            some = Some$.MODULE$.apply((Object)cra);
        }
        catch (IllegalArgumentException ex) {
            this.log().info(this::mergeCells$$anonfun$1, Line$.MODULE$.apply(99), FullName$.MODULE$.apply("com.elixirtech.report2.physical.sxlsx.Sheet.mergeCells"));
            this.log().info(this::mergeCells$$anonfun$2, Line$.MODULE$.apply(100), FullName$.MODULE$.apply("com.elixirtech.report2.physical.sxlsx.Sheet.mergeCells"));
            this.log().error(() -> Sheet.mergeCells$$anonfun$3(x, xSpan, y, ySpan, ex), Line$.MODULE$.apply(101), FullName$.MODULE$.apply("com.elixirtech.report2.physical.sxlsx.Sheet.mergeCells"));
            some = None$.MODULE$;
        }
        return some;
    }

    private final SXSSFRow getRow$$anonfun$1(int rowIdx$1) {
        return this.sheet().createRow(rowIdx$1);
    }

    private static final Object render$$anonfun$4(Exception ex$1) {
        return "Error in render: " + ex$1;
    }

    private final Object mergeCells$$anonfun$1() {
        return "rowPosition: " + this.rowPosition;
    }

    private final Object mergeCells$$anonfun$2() {
        return "colPosition: " + this.colPosition;
    }

    private static final Object mergeCells$$anonfun$3(int x$1, int xSpan$1, int y$1, int ySpan$1, IllegalArgumentException ex$2) {
        return "mergeCells(" + x$1 + "," + xSpan$1 + "," + y$1 + "," + ySpan$1 + ") " + ex$2;
    }
}

