/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.report2.physical.sxlsx;

import com.elixirtech.arch.LoggingInterface;
import com.elixirtech.report2.logical.model.LogicalElement;
import com.elixirtech.report2.logical.model.Rectangle;
import com.elixirtech.report2.physical.sxlsx.CellStyleManager;
import com.elixirtech.report2.physical.sxlsx.Element;
import com.elixirtech.report2.physical.sxlsx.SXLSXGenerator;
import com.elixirtech.report2.physical.sxlsx.Text$;
import com.elixirtech.report2.raw.model.Field;
import com.elixirtech.report2.raw.model.RawModelElement;
import java.io.Serializable;
import java.util.Iterator;
import org.apache.poi.common.usermodel.HyperlinkType;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.Hyperlink;
import org.apache.poi.xssf.streaming.SXSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.Some$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.LazyVals$;
import scala.runtime.function.JProcedure1;

public class Text
extends Element {
    private final Rectangle rc;
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(Text$.class.getDeclaredField("log$lzy1"));

    public static Option<Number> getNumber(String string) {
        return Text$.MODULE$.getNumber(string);
    }

    public static LoggingInterface log() {
        return Text$.MODULE$.log();
    }

    public Text(Rectangle rc) {
        this.rc = rc;
        super(rc.getLeft(), rc.getTop(), rc.getWidth(), rc.getHeight());
    }

    @Override
    public void render(SXLSXGenerator gen) {
        CellStyleManager.CellStyle cellStyle = this.createCellStyle(this.rc);
        StringBuilder sb = new StringBuilder();
        boolean adjusted = false;
        None$ hyperlinkUrl = None$.MODULE$;
        Iterator<LogicalElement> it = this.rc.getLogicalElementIterator();
        while (it.hasNext()) {
            LogicalElement logicalElement = it.next();
            if (!(logicalElement instanceof com.elixirtech.report2.logical.model.Text)) continue;
            com.elixirtech.report2.logical.model.Text txt = (com.elixirtech.report2.logical.model.Text)logicalElement;
            if (!adjusted) {
                cellStyle = this.defineFontStyle(cellStyle, txt);
                adjusted = true;
            }
            sb.append(txt.getText());
            if (it.hasNext()) {
                sb.append("\n");
            }
            if (!hyperlinkUrl.isEmpty()) continue;
            hyperlinkUrl = Option$.MODULE$.apply((Object)txt.getURL());
        }
        XSSFCellStyle style = gen.getCellFormat(cellStyle);
        SXSSFCell cell = this.renderAcrossSpans(gen, style);
        String text = gen.substitute(sb.toString());
        if (gen.isForceNumbersAsText()) {
            cell.setCellValue(text);
        } else if (text.startsWith("'")) {
            String portion = text.substring(1);
            String txt = Text$.MODULE$.getNumber(portion).isDefined() ? portion : text;
            cell.setCellValue(txt);
        } else {
            Option<Number> option = Text$.MODULE$.getNumber(text);
            if (option instanceof Some) {
                Number value = (Number)((Some)option).value();
                cell.setCellValue(value.doubleValue());
            } else if (None$.MODULE$.equals(option)) {
                cell.setCellValue(text);
            } else {
                throw new MatchError(option);
            }
        }
        hyperlinkUrl.foreach((Function1)(JProcedure1 & Serializable)url -> {
            CreationHelper createHelper = gen.workbook().getCreationHelper();
            Hyperlink link = createHelper.createHyperlink(HyperlinkType.URL);
            link.setAddress(url);
            cell.setHyperlink(link);
        });
    }

    private CellStyleManager.CellStyle defineFontStyle(CellStyleManager.CellStyle cellstyle, com.elixirtech.report2.logical.model.Text textObject) {
        String string;
        RawModelElement raw = textObject.getRaw();
        RawModelElement rawModelElement = raw;
        if (rawModelElement instanceof Field) {
            Field f = (Field)rawModelElement;
            string = f.getVerticalAlign();
        } else {
            string = "Top";
        }
        String valign = string;
        CellStyleManager.MyFont newFont = new CellStyleManager.MyFont(textObject.getFontName(), textObject.getFontSize(), textObject.isFontBold(), textObject.isFontItalic(), textObject.isFontUnderline(), textObject.isFontStrikethrough(), textObject.getFontColor(), textObject.getTextAlign(), valign);
        Some some = Some$.MODULE$.apply((Object)newFont);
        Option<CellStyleManager.MyBorder> option = cellstyle.copy$default$1();
        Option<CellStyleManager.MyBackground> option2 = cellstyle.copy$default$3();
        boolean bl = cellstyle.copy$default$4();
        return cellstyle.copy(option, (Option<CellStyleManager.MyFont>)some, option2, bl);
    }
}

