/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.report2.physical.xlsx;

import com.elixirtech.arch.LoggingInterface;
import com.elixirtech.report2.logical.model.LogicalElement;
import com.elixirtech.report2.logical.model.Rectangle;
import com.elixirtech.report2.physical.xlsx.CellFormat;
import com.elixirtech.report2.physical.xlsx.CellFormat$;
import com.elixirtech.report2.physical.xlsx.CellStyleManager;
import com.elixirtech.report2.physical.xlsx.Element;
import com.elixirtech.report2.physical.xlsx.Text$;
import com.elixirtech.report2.physical.xlsx.XLSXGenerator;
import com.elixirtech.report2.raw.model.Field;
import com.elixirtech.report2.raw.model.Format;
import com.elixirtech.report2.raw.model.RawModelElement;
import java.io.Serializable;
import java.util.Iterator;
import org.apache.poi.common.usermodel.HyperlinkType;
import org.apache.poi.ss.usermodel.Hyperlink;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFCreationHelper;
import org.apache.poi.xssf.usermodel.XSSFHyperlink;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.collection.StringOps$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals$;
import scala.runtime.function.JProcedure1;

public class Text
extends Element {
    private final Rectangle rc;
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(Text$.class.getDeclaredField("log$lzy1"));

    public static Option<Number> getNumber(String string) {
        return Text$.MODULE$.getNumber(string);
    }

    public static LoggingInterface log() {
        return Text$.MODULE$.log();
    }

    public Text(Rectangle rc) {
        this.rc = rc;
        super(rc.getLeft(), rc.getTop(), rc.getWidth(), rc.getHeight());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void render(XLSXGenerator gen) {
        CellStyleManager.CellStyle cellStyle = this.createCellStyle(this.rc);
        StringBuilder sb = new StringBuilder();
        boolean adjusted = false;
        None$ hyperlinkUrl = None$.MODULE$;
        Iterator<LogicalElement> it = this.rc.getLogicalElementIterator();
        while (it.hasNext()) {
            LogicalElement logicalElement = it.next();
            if (!(logicalElement instanceof com.elixirtech.report2.logical.model.Text)) continue;
            com.elixirtech.report2.logical.model.Text txt = (com.elixirtech.report2.logical.model.Text)logicalElement;
            if (!adjusted) {
                cellStyle = this.defineFontStyle(cellStyle, txt);
                adjusted = true;
            }
            sb.append(txt.getText());
            if (it.hasNext()) {
                sb.append("\n");
            }
            if (!hyperlinkUrl.isEmpty()) continue;
            None$ none$ = hyperlinkUrl = Option$.MODULE$.apply((Object)txt.getURL()).map((Function1 & Serializable)_$1 -> _$1.trim());
            Some some = Some$.MODULE$.apply((Object)"");
            if (none$ != null ? !none$.equals(some) : some != null) continue;
            hyperlinkUrl = None$.MODULE$;
        }
        XSSFCellStyle style = gen.getCellFormat(cellStyle);
        XSSFCell cell = this.renderAcrossSpans(gen, style);
        String text = gen.substitute(sb.toString());
        if (gen.isForceNumbersAsText()) {
            cell.setCellValue(text);
        } else if (this.hasNumberFormat(this.rc)) {
            String basicText = StringOps$.MODULE$.filter$extension(Predef$.MODULE$.augmentString(text), (Function1 & Serializable)c -> Text.$anonfun$1(BoxesRunTime.unboxToChar((Object)c)));
            Option<Number> option = Text$.MODULE$.getNumber(basicText);
            if (option instanceof Some) {
                Number value = (Number)((Some)option).value();
                if (this.hasPercentFormat(this.rc)) {
                    cell.setCellValue(value.doubleValue() / 100.0);
                } else {
                    cell.setCellValue(value.doubleValue());
                }
            } else {
                if (!None$.MODULE$.equals(option)) throw new MatchError(option);
                cell.setCellValue(text);
            }
        } else if (text.startsWith("'")) {
            String portion = text.substring(1);
            String txt = Text$.MODULE$.getNumber(portion).isDefined() ? portion : text;
            cell.setCellValue(txt);
        } else {
            Option<Number> option = Text$.MODULE$.getNumber(text);
            if (option instanceof Some) {
                Number value = (Number)((Some)option).value();
                cell.setCellValue(value.doubleValue());
            } else {
                if (!None$.MODULE$.equals(option)) throw new MatchError(option);
                cell.setCellValue(text);
            }
        }
        hyperlinkUrl.foreach((Function1)(JProcedure1 & Serializable)url -> {
            XSSFCreationHelper createHelper = gen.workbook().getCreationHelper();
            XSSFHyperlink link = createHelper.createHyperlink(HyperlinkType.URL);
            link.setAddress(url);
            cell.setHyperlink((Hyperlink)link);
        });
    }

    private boolean hasNumberFormat(Rectangle rc) {
        return this.getFormat(rc).exists((Function1 & Serializable)format -> CellFormat$.MODULE$.isNumeric((Format)format));
    }

    private boolean hasPercentFormat(Rectangle rc) {
        return this.getFormat(rc).exists((Function1 & Serializable)cf -> {
            String string = cf.getType();
            String string2 = "Percent";
            if (string == null) {
                if (string2 == null) return true;
            } else if (string.equals(string2)) return true;
            String string3 = cf.getType();
            String string4 = "Percent100";
            if (string3 != null) {
                if (!string3.equals(string4)) return false;
                return true;
            }
            if (string4 == null) return true;
            return false;
        });
    }

    private Option<Format> getFormat(Rectangle rc) {
        RawModelElement rawModelElement = rc.getRaw();
        if (rawModelElement instanceof Field) {
            Field f = (Field)rawModelElement;
            return Option$.MODULE$.apply((Object)f.getFormat());
        }
        return None$.MODULE$;
    }

    private CellStyleManager.CellStyle defineFontStyle(CellStyleManager.CellStyle cellstyle, com.elixirtech.report2.logical.model.Text textObject) {
        String string;
        RawModelElement raw = textObject.getRaw();
        RawModelElement rawModelElement = raw;
        if (rawModelElement instanceof Field) {
            Field f = (Field)rawModelElement;
            string = f.getVerticalAlign();
        } else {
            string = "Top";
        }
        String valign = string;
        CellStyleManager.MyFont newFont = new CellStyleManager.MyFont(textObject.getFontName(), textObject.getFontSize(), textObject.isFontBold(), textObject.isFontItalic(), textObject.isFontUnderline(), textObject.isFontStrikethrough(), textObject.getFontColor(), textObject.getTextAlign(), valign);
        Some some = Some$.MODULE$.apply((Object)newFont);
        Option<CellStyleManager.MyBorder> option = cellstyle.copy$default$1();
        Option<CellStyleManager.MyBackground> option2 = cellstyle.copy$default$3();
        boolean bl = cellstyle.copy$default$4();
        Option<CellFormat> option3 = cellstyle.copy$default$5();
        return cellstyle.copy(option, (Option<CellStyleManager.MyFont>)some, option2, bl, option3);
    }

    private static final /* synthetic */ boolean $anonfun$1(char c) {
        return Character.isDigit(c) || c == '-' || c == '.' || c == ',';
    }
}

