/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.report2.physical.xlsx;

import com.elixirtech.arch.LoggingHelper2;
import com.elixirtech.arch.LoggingInterface;
import com.elixirtech.arch.StringUtil;
import com.elixirtech.arch.SystemConfig;
import com.elixirtech.arch.param.Template$;
import com.elixirtech.report2.logical.model.Body;
import com.elixirtech.report2.logical.model.Column;
import com.elixirtech.report2.logical.model.Columns;
import com.elixirtech.report2.logical.model.Glint;
import com.elixirtech.report2.logical.model.LogicalElement;
import com.elixirtech.report2.logical.model.LogicalElementHolder;
import com.elixirtech.report2.logical.model.LogicalReport;
import com.elixirtech.report2.logical.model.Page;
import com.elixirtech.report2.logical.model.SVG;
import com.elixirtech.report2.physical.ImageUtil;
import com.elixirtech.report2.physical.xlsx.CellStyleManager;
import com.elixirtech.report2.physical.xlsx.FontManager;
import com.elixirtech.report2.physical.xlsx.Image;
import com.elixirtech.report2.physical.xlsx.PrintText;
import com.elixirtech.report2.physical.xlsx.Rectangle;
import com.elixirtech.report2.physical.xlsx.Sheet;
import com.elixirtech.report2.physical.xlsx.Text;
import com.elixirtech.report2.physical.xlsx.XLSXGenerator$;
import com.elixirtech.report2.raw.model.PageSetup;
import com.elixirtech.report2.util.ImageLoader;
import com.elixirtech.ui.StandardColor;
import com.typesafe.config.Config;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Iterator;
import org.apache.poi.ss.usermodel.Footer;
import org.apache.poi.ss.usermodel.Header;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFDataFormat;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.Tuple4;
import scala.Tuple4$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.HashMap;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.function.JProcedure1;
import sourcecode.FullName$;
import sourcecode.Line$;

public class XLSXGenerator
implements LoggingHelper2 {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(XLSXGenerator.class.getDeclaredField("log$lzy1"));
    private volatile Object log$lzy1;
    private final LogicalReport report;
    private final OutputStream os;
    private final int multiplier;
    private int _imageResolution;
    private boolean _snap;
    private boolean _forceNumbersAsText;
    private boolean _lockCells;
    private String _printHeader;
    private String _printFooter;
    private final ArrayBuffer<Sheet> pages;
    private final HashMap<String, String> lookup;
    private final CellStyleManager cellStyleManager;
    private final FontManager fontManager;
    private final XSSFWorkbook workbook;
    private final XSSFDataFormat dataFormat;

    public static int BigSnap() {
        return XLSXGenerator$.MODULE$.BigSnap();
    }

    public static String DefaultPrintFooter() {
        return XLSXGenerator$.MODULE$.DefaultPrintFooter();
    }

    public static String DefaultPrintHeader() {
        return XLSXGenerator$.MODULE$.DefaultPrintHeader();
    }

    public static int ImageResolution() {
        return XLSXGenerator$.MODULE$.ImageResolution();
    }

    public static String Mode() {
        return XLSXGenerator$.MODULE$.Mode();
    }

    public static int NoSnap() {
        return XLSXGenerator$.MODULE$.NoSnap();
    }

    public static int RetainRows() {
        return XLSXGenerator$.MODULE$.RetainRows();
    }

    public static Config config() {
        return XLSXGenerator$.MODULE$.config();
    }

    public static SystemConfig systemConfig() {
        return XLSXGenerator$.MODULE$.systemConfig();
    }

    public static Config xlsxConfig() {
        return XLSXGenerator$.MODULE$.xlsxConfig();
    }

    public XLSXGenerator(LogicalReport report, OutputStream os, int multiplier) {
        this.report = report;
        this.os = os;
        this.multiplier = multiplier;
        this._imageResolution = XLSXGenerator$.MODULE$.ImageResolution();
        this._snap = false;
        this._forceNumbersAsText = false;
        this._lockCells = false;
        this._printHeader = "";
        this._printFooter = "";
        this.pages = new ArrayBuffer();
        this.lookup = new HashMap();
        this.cellStyleManager = new CellStyleManager(this);
        this.fontManager = new FontManager(this);
        this.workbook = new XSSFWorkbook();
        this.dataFormat = this.workbook().createDataFormat();
    }

    public LoggingInterface log() {
        Object object = this.log$lzy1;
        if (object instanceof LoggingInterface) {
            return (LoggingInterface)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (LoggingInterface)this.log$lzyINIT1();
    }

    private Object log$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.log$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    LoggingInterface loggingInterface = null;
                    try {
                        loggingInterface = LoggingHelper2.log$((LoggingHelper2)this);
                        object2 = loggingInterface == null ? LazyVals.NullValue$.MODULE$ : loggingInterface;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.log$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return loggingInterface;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public LogicalReport report() {
        return this.report;
    }

    public int multiplier() {
        return this.multiplier;
    }

    public XSSFWorkbook workbook() {
        return this.workbook;
    }

    public XSSFDataFormat dataFormat() {
        return this.dataFormat;
    }

    public FontManager getFontManager() {
        return this.fontManager;
    }

    public XSSFCellStyle getCellFormat(CellStyleManager.CellStyle style) {
        return this.cellStyleManager.getCellStyle(style);
    }

    public short getDataFormat(String formatString) {
        return this.dataFormat().getFormat(formatString);
    }

    public void setSnap(boolean snap) {
        this._snap = snap;
    }

    public int getSnapValue() {
        if (this._snap) {
            return XLSXGenerator$.MODULE$.BigSnap();
        }
        return XLSXGenerator$.MODULE$.NoSnap();
    }

    public void setImageResolution(int dpi) {
        this._imageResolution = dpi;
    }

    public void setForceNumbersAsText(boolean force) {
        this._forceNumbersAsText = force;
    }

    public boolean isForceNumbersAsText() {
        return this._forceNumbersAsText;
    }

    public boolean isLockCells() {
        return this._lockCells;
    }

    public void setLockCells(boolean lock) {
        this._lockCells = lock;
    }

    public void setPrintHeaderFooter(String printHeader, String printFooter) {
        this._printHeader = printHeader;
        this._printFooter = printFooter;
    }

    public int getPageCount() {
        return this.pages.size();
    }

    public void renderPage(Page page) {
        this.lookup.put((Object)"#", (Object)Integer.toString(page.getPageNumber()));
        this.lookup.put((Object)"##", (Object)Integer.toString(page.getPageCount()));
        this.lookup.put((Object)"@", (Object)(page.getPageNumber() + " of " + page.getPageCount()));
        PageSetup ps = page.getPageSetup();
        Sheet sheet = new Sheet(this, this.getTitle(page), ps);
        this.setupPrintHeaderFooter(sheet);
        Option$.MODULE$.apply((Object)page.getPageHeader()).foreach((Function1)(JProcedure1 & Serializable)ph -> this.renderElements(sheet, (LogicalElementHolder)ph));
        Body body = page.getBody();
        CollectionConverters$.MODULE$.ListHasAsScala(body.getBodyPartList()).asScala().foreach((Function1)(JProcedure1 & Serializable)bp -> this.renderElements(sheet, (LogicalElementHolder)bp));
        Option$.MODULE$.apply((Object)page.getPageFooter()).foreach((Function1)(JProcedure1 & Serializable)pf -> {
            int y = ps.getHeight() - ps.getBottom() - pf.getHeight();
            sheet.offsetY(y - sheet.getY());
            this.renderElements(sheet, (LogicalElementHolder)pf);
        });
        try {
            sheet.render();
            this.pages.$plus$eq((Object)sheet);
        }
        catch (Exception ex) {
            this.log().error(() -> XLSXGenerator.renderPage$$anonfun$4(ex), (Throwable)ex, Line$.MODULE$.apply(118), FullName$.MODULE$.apply("com.elixirtech.report2.physical.xlsx.XLSXGenerator.renderPage"));
            throw new IOException("Error rendering sheet: " + ex, ex);
        }
    }

    public void setupPrintHeaderFooter(Sheet sheet) {
        PrintText h = new PrintText(this._printHeader.trim());
        Header header = sheet.sheet().getHeader();
        h.struct().left().foreach((Function1)(JProcedure1 & Serializable)x$0 -> header.setLeft(x$0));
        h.struct().center().foreach((Function1)(JProcedure1 & Serializable)x$0 -> header.setCenter(x$0));
        h.struct().right().foreach((Function1)(JProcedure1 & Serializable)x$0 -> header.setRight(x$0));
        PrintText f = new PrintText(this._printFooter.trim());
        Footer footer = sheet.sheet().getFooter();
        f.struct().left().foreach((Function1)(JProcedure1 & Serializable)x$0 -> footer.setLeft(x$0));
        f.struct().center().foreach((Function1)(JProcedure1 & Serializable)x$0 -> footer.setCenter(x$0));
        f.struct().right().foreach((Function1)(JProcedure1 & Serializable)x$0 -> footer.setRight(x$0));
    }

    public void close() {
        this.workbook().write(this.os);
        this.workbook().close();
    }

    public void renderElements(Sheet sheet, LogicalElementHolder holder) {
        LogicalElementHolder logicalElementHolder = holder;
        if (logicalElementHolder instanceof Columns) {
            Columns columns = (Columns)logicalElementHolder;
            int maxHeight = 0;
            int x = sheet.getX();
            Iterator<Column> it = columns.getColumnIterator();
            while (it.hasNext()) {
                Column col = it.next();
                int colHeight = this.renderColumn(sheet, col);
                maxHeight = Math.max(maxHeight, colHeight);
                if (it.hasNext()) {
                    int width = col.getWidth() + col.getSpaceAfter();
                    sheet.offsetX(width);
                }
                sheet.offsetY(-colHeight);
            }
            sheet.offsetX(x - sheet.getX());
            sheet.offsetY(maxHeight);
            return;
        }
        LogicalElementHolder other = logicalElementHolder;
        CollectionConverters$.MODULE$.ListHasAsScala(holder.getLogicalElementList()).asScala().foreach((Function1)(JProcedure1 & Serializable)element -> this.renderElement(sheet, (LogicalElement)element, null));
        sheet.offsetY(holder.getHeight());
    }

    public int renderColumn(Sheet sheet, Column column) {
        IntRef totalHeight = IntRef.create((int)0);
        CollectionConverters$.MODULE$.ListHasAsScala(column.getBodyPartList()).asScala().foreach((Function1)(JProcedure1 & Serializable)bp -> {
            this.renderElements(sheet, (LogicalElementHolder)bp);
            int height = bp.getHeight() + bp.getSpaceAfter();
            sheet.offsetY(bp.getSpaceAfter());
            totalHeight$1.elem += height;
        });
        return totalHeight.elem;
    }

    public void renderElement(Sheet sheet, LogicalElement e, com.elixirtech.report2.logical.model.Rectangle enclosingRect) {
        LogicalElement logicalElement = e;
        if (logicalElement instanceof com.elixirtech.report2.logical.model.Rectangle) {
            com.elixirtech.report2.logical.model.Rectangle rc = (com.elixirtech.report2.logical.model.Rectangle)logicalElement;
            if (rc.getLogicalElementCount() == 0) {
                Color c = StandardColor.lookup(rc.getBackgroundColor());
                if (c.getAlpha() > 0 || rc.getBorderStyle() != null) {
                    sheet.add(new Rectangle(rc));
                    return;
                }
                return;
            }
            LogicalElement logicalElement2 = rc.getLogicalElement(0);
            if (logicalElement2 instanceof com.elixirtech.report2.logical.model.Text) {
                com.elixirtech.report2.logical.model.Text child = (com.elixirtech.report2.logical.model.Text)logicalElement2;
                sheet.add(new Text(rc));
                return;
            }
            CollectionConverters$.MODULE$.ListHasAsScala(rc.getLogicalElementList()).asScala().foreach((Function1)(JProcedure1 & Serializable)elem -> this.renderElement(sheet, (LogicalElement)elem, rc));
            return;
        }
        LogicalElement other = logicalElement;
        this.renderOther(sheet, other, enclosingRect);
    }

    public void renderOther(Sheet sheet, LogicalElement e, com.elixirtech.report2.logical.model.Rectangle enclosingRect) {
        Tuple4 tuple4 = (Tuple4)Option$.MODULE$.apply((Object)enclosingRect).map((Function1 & Serializable)rc -> Tuple4$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)rc.getLeft()), (Object)BoxesRunTime.boxToInteger((int)rc.getTop()), (Object)BoxesRunTime.boxToInteger((int)rc.getWidth()), (Object)BoxesRunTime.boxToInteger((int)rc.getHeight()))).getOrElse(() -> XLSXGenerator.$anonfun$2(e));
        if (!(tuple4 instanceof Tuple4)) {
            throw new MatchError((Object)tuple4);
        }
        Tuple4 tuple42 = tuple4;
        int left = BoxesRunTime.unboxToInt((Object)tuple42._1());
        int top = BoxesRunTime.unboxToInt((Object)tuple42._2());
        int width = BoxesRunTime.unboxToInt((Object)tuple42._3());
        int height = BoxesRunTime.unboxToInt((Object)tuple42._4());
        Tuple4 tuple43 = Tuple4$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)left), (Object)BoxesRunTime.boxToInteger((int)top), (Object)BoxesRunTime.boxToInteger((int)width), (Object)BoxesRunTime.boxToInteger((int)height));
        int left2 = BoxesRunTime.unboxToInt((Object)tuple43._1());
        int top2 = BoxesRunTime.unboxToInt((Object)tuple43._2());
        int width2 = BoxesRunTime.unboxToInt((Object)tuple43._3());
        int height2 = BoxesRunTime.unboxToInt((Object)tuple43._4());
        LogicalElement logicalElement = e;
        if (logicalElement instanceof com.elixirtech.report2.logical.model.Image) {
            com.elixirtech.report2.logical.model.Image im = (com.elixirtech.report2.logical.model.Image)logicalElement;
            Option actualImage = Option$.MODULE$.apply((Object)((BufferedImage)im.getImage())).orElse(() -> this.$anonfun$3(im));
            Option option = actualImage;
            if (option instanceof Some) {
                BufferedImage ai = (BufferedImage)((Some)option).value();
                im.setImage(ai);
                Image img = new Image(left2, top2, width2, height2);
                img.setImage(ImageUtil.getImage(enclosingRect, im, this._imageResolution));
                sheet.add(img);
                return;
            }
            if (None$.MODULE$.equals(option)) {
                this.log().warn(() -> XLSXGenerator.renderOther$$anonfun$1(im), Line$.MODULE$.apply(218), FullName$.MODULE$.apply("com.elixirtech.report2.physical.xlsx.XLSXGenerator.renderOther"));
                return;
            }
            throw new MatchError((Object)option);
        }
        if (logicalElement instanceof Glint) {
            Glint glint = (Glint)logicalElement;
            Image img = new Image(left2, top2, width2, height2);
            if (glint.getWidth() > 0 && glint.getHeight() > 0) {
                int imageResolution = glint.getImageResolution();
                if (imageResolution > 0) {
                    img.setImage(ImageUtil.getImage(glint, imageResolution));
                    sheet.add(img);
                    return;
                }
                return;
            }
            return;
        }
        if (logicalElement instanceof SVG) {
            SVG svg = (SVG)logicalElement;
            Image img = new Image(left2, top2, width2, height2);
            if (svg.getWidth() > 0 && svg.getHeight() > 0) {
                int imageResolution = svg.getImageResolution();
                if (imageResolution > 0) {
                    img.setImage(ImageUtil.getImage(enclosingRect, svg, imageResolution));
                    sheet.add(img);
                    return;
                }
                return;
            }
            return;
        }
    }

    private BufferedImage asBufferedImage(java.awt.Image raw) {
        java.awt.Image image = raw;
        if (image instanceof BufferedImage) {
            BufferedImage bi = (BufferedImage)image;
            return bi;
        }
        BufferedImage bi = new BufferedImage(raw.getWidth(null), raw.getHeight(null), 2);
        Graphics g = bi.getGraphics();
        g.drawImage(raw, 0, 0, null);
        g.dispose();
        return bi;
    }

    private String getTitle(Page page) {
        Object object;
        String name = page.getName();
        if (StringUtil.isEmpty(name)) {
            String ext = " Page " + this.getPageNo();
            object = this.trim(this.report().getCaption(), 31 - ext.length()) + ext;
        } else {
            object = name;
        }
        String title = object;
        return this.ensureNameHasValidChars(title);
    }

    private int getPageNo() {
        return this.pages.size() + 1;
    }

    public String substitute(String s) {
        String string;
        String s2 = s.replace("${#}", (CharSequence)this.lookup.apply((Object)"#")).replace("${##}", (CharSequence)this.lookup.apply((Object)"##")).replace("${@}", (CharSequence)this.lookup.apply((Object)"@"));
        try {
            string = Template$.MODULE$.apply(s2).substitute(this.lookup.lift());
        }
        catch (Exception ex) {
            this.log().error(() -> XLSXGenerator.substitute$$anonfun$1(s), (Throwable)ex, Line$.MODULE$.apply(273), FullName$.MODULE$.apply("com.elixirtech.report2.physical.xlsx.XLSXGenerator.substitute"));
            string = s;
        }
        return string;
    }

    private String trim(String s, int len) {
        if (s.length() > len) {
            return s.substring(0, len);
        }
        return s;
    }

    private String ensureNameHasValidChars(String name) {
        String simple = name.replace('/', '_').replace('\\', '_').replace('?', '_').replace('*', '_').replace('[', '_').replace(']', '_').replace(':', '_').replace('{', '_');
        return this.trim(simple, 31);
    }

    private static final Object renderPage$$anonfun$4(Exception ex$1) {
        return "Error rendering sheet: " + ex$1;
    }

    private static final Tuple4 $anonfun$2(LogicalElement e$1) {
        return Tuple4$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)e$1.getLeft()), (Object)BoxesRunTime.boxToInteger((int)e$1.getTop()), (Object)BoxesRunTime.boxToInteger((int)e$1.getWidth()), (Object)BoxesRunTime.boxToInteger((int)e$1.getHeight()));
    }

    private final Option $anonfun$3(com.elixirtech.report2.logical.model.Image im$1) {
        return Option$.MODULE$.apply((Object)ImageLoader.loadFromPath(im$1.getPicture())).map((Function1 & Serializable)raw -> this.asBufferedImage((java.awt.Image)raw));
    }

    private static final Object renderOther$$anonfun$1(com.elixirtech.report2.logical.model.Image im$2) {
        return "image is null for " + im$2.getPicture();
    }

    private static final Object substitute$$anonfun$1(String s$1) {
        return "Error in substitution of: " + s$1;
    }
}

