/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.report2.processor;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.arch.StringUtil;
import com.elixirtech.jdom.Element;
import com.elixirtech.jdom.Namespace;
import com.elixirtech.report2.RenderConstants;
import com.elixirtech.report2.processor.DocumentProcessor;
import com.elixirtech.scm.Scheme;

public class FieldCleaner
extends DocumentProcessor
implements RenderConstants {
    private static final ElxLoggerJ m_Log = ElxLoggerJ.getLogger(FieldCleaner.class);

    @Override
    public void processElement(Element element) {
        if (element.getName().equals("field") && element.getNamespace().equals(NS_RML)) {
            String string;
            String string2 = element.getText();
            Element element2 = new Element("control-source");
            element2.setAttribute("space", "preserve", Namespace.XML_NAMESPACE);
            if (string2.startsWith("=")) {
                element2.setAttribute("type", "Script");
                string2 = Scheme.convert(string2);
            } else {
                element2.setAttribute("type", "Field");
                element2.setAttribute("field", string2);
            }
            element2.setAttribute("running-value", element.getAttributeValue("running-sum"));
            element2.setText(string2);
            String string3 = element.getAttributeValue("font-weight");
            element.setAttribute("font-bold", "Bold".equals(string3) ? "Yes" : "No");
            element.removeAttribute("font-weight");
            try {
                string = element.getAttributeValue("format");
                if (StringUtil.notEmpty(string) && !"None".equals(string)) {
                    Element element3 = new Element("format");
                    String[] stringArray = string.split("\\|");
                    String string4 = stringArray[0];
                    if ("Date".equals(string4)) {
                        string4 = "Date/Time";
                    } else if ("Time".equals(string4)) {
                        string4 = "Date/Time";
                    } else if ("Date/Time".equals(string4)) {
                        string4 = "Date/Time";
                    }
                    element3.setAttribute("type", string4);
                    boolean bl = "true".equals(stringArray[1]);
                    if (bl) {
                        element3.setAttribute("custom-pattern", stringArray[2]);
                    } else if ("Currency".equals(string4) || "Number".equals(string4) || "Percent".equals(string4)) {
                        element3.setAttribute("min-integer-digits", stringArray[2]);
                        element3.setAttribute("max-integer-digits", stringArray[3]);
                        element3.setAttribute("min-fraction-digits", stringArray[4]);
                        element3.setAttribute("max-fraction-digits", stringArray[5]);
                        element3.setAttribute("grouping-used", "true".equals(stringArray[6]) ? "Yes" : "No");
                        element3.setAttribute("grouping-size", stringArray[7]);
                        element3.setAttribute("decimal-separator-always-shown", "true".equals(stringArray[8]) ? "Yes" : "No");
                    } else if ("Date".equals(stringArray[0])) {
                        element3.setAttribute("date-format", stringArray[2]);
                        element3.setAttribute("time-format", "None");
                    } else if ("Time".equals(stringArray[0])) {
                        element3.setAttribute("date-format", "None");
                        element3.setAttribute("time-format", stringArray[2]);
                    } else if ("Date/Time".equals(stringArray[0])) {
                        element3.setAttribute("date-format", stringArray[2]);
                        element3.setAttribute("time-format", stringArray[3]);
                    }
                    element.addContent(element3);
                }
            }
            catch (Exception exception) {
                m_Log.error((Object)("Can't migrate format: " + exception), (Throwable)exception);
            }
            string = element.getAttributeValue("locale");
            if ("Template Locale".equals(string)) {
                element.removeAttribute("locale");
            }
            element.removeAttribute("control-source");
            element.removeAttribute("running-sum");
            element.removeAttribute("space", Namespace.XML_NAMESPACE);
            element.addContent(element2);
        }
    }
}

