/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.report2.raw;

import com.elixirtech.arch.ARM$;
import com.elixirtech.arch.LoggingHelper;
import com.elixirtech.arch.logging.SLF4J;
import com.elixirtech.jaxen.jdom.JDOMXPath;
import com.elixirtech.jdom.Attribute;
import com.elixirtech.jdom.Document;
import com.elixirtech.jdom.Element;
import com.elixirtech.jdom.input.SAXBuilder;
import com.elixirtech.report2.raw.Migrator;
import com.elixirtech.report2.raw.model.Parameter;
import com.elixirtech.report2.raw.model.RawReport;
import com.elixirtech.report2.raw.model.RawReportSAX;
import com.elixirtech.repository.RMLFileObject;
import com.elixirtech.sax.delegates.EncryptedSAX;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Iterator;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.slf4j.Logger;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.function.JProcedure1;
import sourcecode.FullName$;
import sourcecode.Line$;

public final class RMLUtil$
implements SLF4J,
LoggingHelper,
Serializable {
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(RMLUtil$.class.getDeclaredField("logger$lzy1"));
    private volatile Object logger$lzy1;
    private static final int VERSION;
    public static final RMLUtil$ MODULE$;

    private RMLUtil$() {
    }

    static {
        MODULE$ = new RMLUtil$();
        VERSION = 2;
    }

    public Logger logger() {
        Object object = this.logger$lzy1;
        if (object instanceof Logger) {
            return (Logger)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Logger)this.logger$lzyINIT1();
    }

    private Object logger$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.logger$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Logger logger = null;
                    try {
                        logger = LoggingHelper.logger$((LoggingHelper)this);
                        object2 = logger == null ? LazyVals.NullValue$.MODULE$ : logger;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.logger$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return logger;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(RMLUtil$.class);
    }

    public int VERSION() {
        return VERSION;
    }

    public RawReport readRML(RMLFileObject fo) throws IOException {
        return this.readRML(fo, true);
    }

    public RawReport readRML(RMLFileObject fo, boolean useCache) throws IOException {
        return this.doReadRML(fo, useCache);
    }

    private RawReport doReadRML(RMLFileObject fo, boolean useCache) {
        this.debug(() -> RMLUtil$.doReadRML$$anonfun$1(fo), Line$.MODULE$.apply(43), FullName$.MODULE$.apply("com.elixirtech.report2.raw.RMLUtil.doReadRML"));
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser parser = factory.newSAXParser();
            EncryptedSAX handler = new EncryptedSAX(new RawReportSAX());
            ARM$.MODULE$.run((Function1)(JProcedure1 & Serializable)arm -> {
                InputStream is = (InputStream)arm.manage((Object)fo.getInputStream());
                parser.parse(is, (DefaultHandler)handler);
            });
            RawReport report = (RawReport)handler.getObject();
            report.setFileObject(fo);
            report.loaded();
            int version = BoxesRunTime.unboxToInt((Object)Option$.MODULE$.apply((Object)report.getMetadata()).map((Function1 & Serializable)_$1 -> _$1.getVersion()).getOrElse(RMLUtil$::$anonfun$2));
            if (version != this.VERSION()) {
                new Migrator(report, version);
            }
            return report;
        }
        catch (ParserConfigurationException ex) {
            this.error(() -> RMLUtil$.doReadRML$$anonfun$3(ex), ex, Line$.MODULE$.apply(65), FullName$.MODULE$.apply("com.elixirtech.report2.raw.RMLUtil.doReadRML"));
            throw new IOException(ex.toString(), ex);
        }
        catch (SAXException ex) {
            this.error(() -> RMLUtil$.doReadRML$$anonfun$4(ex), ex, Line$.MODULE$.apply(68), FullName$.MODULE$.apply("com.elixirtech.report2.raw.RMLUtil.doReadRML"));
            throw new IOException(ex.toString(), ex);
        }
    }

    public RawReport deepCopy(RawReport report) {
        RawReport ret = report.deepCopy();
        ret.setFileObject(report.getFileObject());
        ret.loaded();
        return ret;
    }

    public java.util.List<String> getSectionNames(RawReport report) {
        return CollectionConverters$.MODULE$.SeqHasAsJava((Seq)CollectionConverters$.MODULE$.IteratorHasAsScala(report.getSectionIterator()).asScala().map((Function1 & Serializable)_$2 -> _$2.getName()).toList()).asJava();
    }

    public java.util.List<String> getSectionNames(RMLFileObject fo) throws IOException {
        java.util.List list;
        try {
            SAXBuilder sb = new SAXBuilder();
            list = (java.util.List)ARM$.MODULE$.run((Function1 & Serializable)arm -> {
                InputStream is = (InputStream)arm.manage((Object)fo.getInputStream());
                Document doc = sb.build(is);
                JDOMXPath path = new JDOMXPath("/rml:report/rml:sections/rml:section/@name");
                path.addNamespace("rml", "http://www.elixirtech.com/ElixirReport/RML");
                Iterator it = path.selectNodes(doc).iterator();
                return CollectionConverters$.MODULE$.SeqHasAsJava((Seq)CollectionConverters$.MODULE$.IteratorHasAsScala(it).asScala().map((Function1 & Serializable)_$3 -> ((Attribute)_$3).getValue()).toList()).asJava();
            });
        }
        catch (IOException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new IOException("Error reading report: " + ex, ex);
        }
        return list;
    }

    public java.util.List<String> getDataSourceNames(RawReport report) {
        return CollectionConverters$.MODULE$.SeqHasAsJava((Seq)CollectionConverters$.MODULE$.IteratorHasAsScala(report.getDataSourceIterator()).asScala().map((Function1 & Serializable)_$4 -> _$4.getName()).toList()).asJava();
    }

    public java.util.List<String> getDataSourceNames(RMLFileObject fo) throws IOException {
        java.util.List list;
        try {
            SAXBuilder sb = new SAXBuilder();
            list = (java.util.List)ARM$.MODULE$.run((Function1 & Serializable)arm -> {
                InputStream is = (InputStream)arm.manage((Object)fo.getInputStream());
                Document doc = sb.build(is);
                JDOMXPath path = new JDOMXPath("/rml:report/rml:datasources/rml:datasource/@name");
                path.addNamespace("rml", "http://www.elixirtech.com/ElixirReport/RML");
                Iterator it = path.selectNodes(doc).iterator();
                return CollectionConverters$.MODULE$.SeqHasAsJava((Seq)CollectionConverters$.MODULE$.IteratorHasAsScala(it).asScala().map((Function1 & Serializable)_$5 -> ((Attribute)_$5).getValue()).toList()).asJava();
            });
        }
        catch (IOException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new IOException("Error reading report: " + ex, ex);
        }
        return list;
    }

    public Map<String, String> getDataSources(RMLFileObject fo) throws IOException {
        Map map;
        try {
            SAXBuilder sb = new SAXBuilder();
            map = (Map)ARM$.MODULE$.run((Function1 & Serializable)arm -> {
                InputStream is = (InputStream)arm.manage((Object)fo.getInputStream());
                Document doc = sb.build(is);
                JDOMXPath path = new JDOMXPath("/rml:report/rml:datasources/rml:datasource");
                path.addNamespace("rml", "http://www.elixirtech.com/ElixirReport/RML");
                Iterator it = path.selectNodes(doc).iterator();
                List elements = CollectionConverters$.MODULE$.IteratorHasAsScala(it).asScala().collect((PartialFunction)new Serializable(){

                    public final boolean isDefinedAt(Object x) {
                        Object object = x;
                        if (object instanceof Element) {
                            Element e = (Element)object;
                            return true;
                        }
                        return false;
                    }

                    public final Object applyOrElse(Object x, Function1 function1) {
                        Object object = x;
                        if (object instanceof Element) {
                            Element e = (Element)object;
                            return e;
                        }
                        return function1.apply(x);
                    }
                }).toList();
                return elements.flatMap((Function1 & Serializable)e -> Option$.MODULE$.apply((Object)e.getAttributeValue("name")).flatMap((Function1 & Serializable)name -> Option$.MODULE$.apply((Object)e.getAttributeValue("datasource-name")).map((Function1 & Serializable)dsName -> {
                    String string = (String)Predef$.MODULE$.ArrowAssoc(name);
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, dsName);
                }))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
            });
        }
        catch (IOException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new IOException("Error reading report: " + ex, ex);
        }
        return map;
    }

    public java.util.List<Parameter> getParameters(RMLFileObject fo) throws IOException {
        java.util.List list;
        try {
            SAXBuilder sb = new SAXBuilder();
            list = (java.util.List)ARM$.MODULE$.run((Function1 & Serializable)arm -> {
                InputStream is = (InputStream)arm.manage((Object)fo.getInputStream());
                Document doc = sb.build(is);
                JDOMXPath path = new JDOMXPath("/rml:report/rml:parameters/rml:param");
                path.addNamespace("rml", "http://www.elixirtech.com/ElixirReport/RML");
                Iterator it = path.selectNodes(doc).iterator();
                return CollectionConverters$.MODULE$.SeqHasAsJava((Seq)CollectionConverters$.MODULE$.IteratorHasAsScala(it).asScala().map((Function1 & Serializable)_$6 -> (Element)_$6).filter((Function1 & Serializable)param -> "Yes".equals(param.getAttributeValue("enabled"))).map((Function1 & Serializable)param -> new Parameter(param.getAttributeValue("key"), param.getText())).toList()).asJava();
            });
        }
        catch (IOException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new IOException("Error reading report: " + ex, ex);
        }
        return list;
    }

    public String getDescription(RMLFileObject fo) throws IOException {
        String string;
        try {
            SAXBuilder sb = new SAXBuilder();
            string = (String)ARM$.MODULE$.run((Function1 & Serializable)arm -> {
                InputStream is = (InputStream)arm.manage((Object)fo.getInputStream());
                Document doc = sb.build(is);
                JDOMXPath path = new JDOMXPath("/rml:report/@description");
                path.addNamespace("rml", "http://www.elixirtech.com/ElixirReport/RML");
                Iterator it = path.selectNodes(doc).iterator();
                return (String)CollectionConverters$.MODULE$.IteratorHasAsScala(it).asScala().map((Function1 & Serializable)_$7 -> ((Attribute)_$7).getValue()).toList().headOption().getOrElse(RMLUtil$::getDescription$$anonfun$1$$anonfun$2);
            });
        }
        catch (IOException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new IOException("Error reading report: " + ex, ex);
        }
        return string;
    }

    private static final Object doReadRML$$anonfun$1(RMLFileObject fo$1) {
        return "readRML(" + fo$1.getName() + ")";
    }

    private static final int $anonfun$2() {
        return 1;
    }

    private static final Object doReadRML$$anonfun$3(ParserConfigurationException ex$1) {
        return "readRML: " + ex$1;
    }

    private static final Object doReadRML$$anonfun$4(SAXException ex$2) {
        return "readRML: " + ex$2;
    }

    private static final String getDescription$$anonfun$1$$anonfun$2() {
        return "";
    }
}

