/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.report2.raw;

import com.elixirtech.arch.Elixir;
import com.elixirtech.i18n.Name;
import com.elixirtech.property.DefaultStyle;
import com.elixirtech.property.IMasterPropertyList;
import com.elixirtech.property.IStyle;
import com.elixirtech.report2.raw.IStyleManager;
import com.elixirtech.report2.raw.model.IResourceProvider;
import com.elixirtech.report2.raw.model.RawReport;
import com.elixirtech.report2.raw.model.Style;
import java.util.Arrays;
import java.util.Map;

public class StyleManager
implements IStyleManager {
    private static IMasterPropertyList m_MasterPropertyList = (IMasterPropertyList)Elixir.get(IMasterPropertyList.class);
    private RawReport m_Report;

    public static boolean isInherited(Name name) {
        return m_MasterPropertyList.isInherited(name);
    }

    public StyleManager(RawReport rawReport) {
        this.m_Report = rawReport;
    }

    @Override
    public IStyle lookupStyle(String string) {
        if (string == null) {
            return null;
        }
        IResourceProvider iResourceProvider = this.m_Report.getResourceProvider();
        Style style = iResourceProvider.getStyle(string);
        if (style == null) {
            return null;
        }
        return style;
    }

    @Override
    public String[] getStyleNames() {
        Object[] objectArray = new String[this.m_Report.getStyleCount() + 1];
        int n = 0;
        objectArray[n] = "";
        for (Style style : this.m_Report.getStyleMap().values()) {
            objectArray[++n] = style.getName();
        }
        Arrays.sort(objectArray);
        return objectArray;
    }

    @Override
    public IStyle getStyle(String string) {
        IStyle iStyle = null;
        if (string != null) {
            iStyle = this.m_Report.getStyle(string);
        }
        if (iStyle == null) {
            iStyle = DefaultStyle.current();
        }
        return iStyle;
    }

    @Override
    public int getStyleCount() {
        return this.m_Report.getStyleCount();
    }

    @Override
    public void addStyle(IStyle iStyle) {
        this.m_Report.addStyle((Style)iStyle);
    }

    @Override
    public Map<String, Style> getStyleMap() {
        return this.m_Report.getStyleMap();
    }

    public void renameStyle(String string, String string2) {
        for (Style style : this.m_Report.getStyleMap().values()) {
            if (!string.equals(style.getBaseName())) continue;
            style.setBaseName(string2);
        }
    }
}

