/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.report2.raw.model;

import com.elixirtech.i18n.Name;
import com.elixirtech.jdom.Element;
import com.elixirtech.property.DefaultStyle;
import com.elixirtech.property.Property;
import com.elixirtech.property.PropertyImplementor;
import com.elixirtech.property.PropertyType;
import com.elixirtech.report2.raw.StyleManager;
import com.elixirtech.report2.raw.model.Chunk;
import com.elixirtech.report2.raw.model.IRawElementHolder;
import com.elixirtech.report2.raw.model.RawModelElement;
import com.elixirtech.report2.raw.model.Style;
import com.elixirtech.sax.BeanUtil;
import com.elixirtech.sax.IBean;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public abstract class BasicRawElementHolder
extends RawModelElement
implements IBean,
PropertyImplementor,
IRawElementHolder {
    protected List<RawModelElement> m_RawElement = new ArrayList<RawModelElement>();
    protected Boolean m_Fill;
    private static String[] m_PropertyNameStrings = new String[]{"RawModelElement.Fill".intern()};
    private static String[] m_PropertyTypeStrings = new String[]{"Boolean"};
    private static int m_IndexOffset;
    private static Name[] m_PropertyNames;
    private static PropertyType[] m_PropertyTypes;

    public static boolean isHidden(String string) {
        return false;
    }

    @Override
    public String getTagName() {
        return "basic-element-holder";
    }

    @Override
    public void loaded() {
        super.loaded();
        Iterator<RawModelElement> iterator = this.m_RawElement.iterator();
        while (iterator.hasNext()) {
            ((IBean)iterator.next()).loaded();
        }
    }

    @Override
    public void dispose() {
        if (this.m_RawElement != null) {
            Iterator<RawModelElement> iterator = this.m_RawElement.iterator();
            while (iterator.hasNext()) {
                ((IBean)iterator.next()).dispose();
            }
        }
        this.m_RawElement = null;
    }

    @Override
    public void copyAttrs(Element element) {
        if (this.m_Fill != null) {
            element.setAttribute("fill", this.m_Fill != false ? "Yes" : "No");
        }
        super.copyAttrs(element);
    }

    @Override
    public Object shallowCopy() throws InstantiationException, IllegalAccessException {
        BasicRawElementHolder basicRawElementHolder = (BasicRawElementHolder)super.shallowCopy();
        return basicRawElementHolder;
    }

    public void addRawElement(RawModelElement rawModelElement) {
        this.m_RawElement.add(rawModelElement);
        rawModelElement.setParent(this);
        Chunk.MyTreeModel myTreeModel = this.getTreeModel();
        if (myTreeModel != null) {
            int n = this.m_RawElement.indexOf(rawModelElement);
            myTreeModel.fireInsertedEvent(myTreeModel.getTreePath(this), new int[]{n}, new Object[]{rawModelElement});
        }
    }

    public void addRawElement(int n, RawModelElement rawModelElement) {
        this.m_RawElement.add(n, rawModelElement);
        rawModelElement.setParent(this);
        Chunk.MyTreeModel myTreeModel = this.getTreeModel();
        if (myTreeModel != null) {
            int n2 = this.m_RawElement.indexOf(rawModelElement);
            myTreeModel.fireInsertedEvent(myTreeModel.getTreePath(this), new int[]{n2}, new Object[]{rawModelElement});
        }
    }

    public void addAllRawElements(Collection<RawModelElement> collection) {
        this.m_RawElement.addAll(collection);
        for (RawModelElement rawModelElement : collection) {
            rawModelElement.setParent(this);
        }
        Chunk.MyTreeModel myTreeModel = this.getTreeModel();
        if (myTreeModel != null) {
            myTreeModel.fireStructureChangedEvent(myTreeModel.getTreePath(this));
        }
    }

    @Override
    public int indexOfRawElement(RawModelElement rawModelElement) {
        return this.m_RawElement.indexOf(rawModelElement);
    }

    public void removeRawElement(RawModelElement rawModelElement) {
        int n = this.m_RawElement.indexOf(rawModelElement);
        this.m_RawElement.remove(rawModelElement);
        rawModelElement.setParent(null);
        Chunk.MyTreeModel myTreeModel = this.getTreeModel();
        if (myTreeModel != null) {
            myTreeModel.fireRemovedEvent(myTreeModel.getTreePath(this), new int[]{n}, new Object[]{rawModelElement});
        }
    }

    public void removeAllRawElements(Collection collection) {
        Object object2;
        this.m_RawElement.removeAll(collection);
        for (Object object2 : collection) {
            ((RawModelElement)object2).setParent(null);
        }
        object2 = this.getTreeModel();
        if (object2 != null) {
            ((Chunk.MyTreeModel)object2).fireStructureChangedEvent(((Chunk.MyTreeModel)object2).getTreePath(this));
        }
    }

    public void removeAllRawElements() {
        for (RawModelElement object2 : this.m_RawElement) {
            object2.setParent(null);
        }
        this.m_RawElement.clear();
        Chunk.MyTreeModel myTreeModel = this.getTreeModel();
        if (myTreeModel != null) {
            myTreeModel.fireStructureChangedEvent(myTreeModel.getTreePath(this));
        }
    }

    @Override
    public RawModelElement getRawElement(int n) {
        return this.m_RawElement.get(n);
    }

    @Override
    public int getRawElementCount() {
        return this.m_RawElement.size();
    }

    @Override
    public Iterator<RawModelElement> getRawElementIterator() {
        return this.m_RawElement.iterator();
    }

    @Override
    public List<RawModelElement> getRawElementList() {
        return this.m_RawElement;
    }

    public void setRawElementList(List<RawModelElement> list) {
        this.m_RawElement = list;
        Chunk.MyTreeModel myTreeModel = this.getTreeModel();
        if (myTreeModel != null) {
            myTreeModel.fireStructureChangedEvent(myTreeModel.getTreePath(this));
        }
    }

    @Override
    public void cacheProperties() {
        int n = this.getPropertyCount();
        for (int i = 0; i < n; ++i) {
            Object object = this.getLocalPropertyValue(i);
            if (object != null) continue;
            object = this.getDefaultPropertyValue(i);
            this.setPropertyValue(i, object);
        }
    }

    @Override
    public boolean isFill() {
        Boolean bl = this.m_Fill;
        if (bl == null) {
            bl = (Boolean)this.getDefaultPropertyValue(m_IndexOffset + 1 - 1);
        }
        return bl;
    }

    public void setFill(boolean bl) {
        this.m_Fill = bl;
        if (Boolean.TRUE.equals(this.m_Fill)) {
            this.doFill();
        }
    }

    public void setFill(Boolean bl) {
        this.m_Fill = bl;
        if (Boolean.TRUE.equals(this.m_Fill)) {
            this.doFill();
        }
    }

    @Override
    public void getPropertyNames(Set<Name> set) {
        set.addAll(Arrays.asList(m_PropertyNames));
        super.getPropertyNames(set);
    }

    @Override
    public int getPropertyCount() {
        return m_IndexOffset + m_PropertyNameStrings.length;
    }

    public static int getStaticPropertyCount() {
        return m_IndexOffset + m_PropertyNameStrings.length;
    }

    @Override
    public int getPropertyIndex(String string) {
        int n = BeanUtil.indexOf(string, m_PropertyNameStrings);
        if (n < 0) {
            return super.getPropertyIndex(string);
        }
        return n += m_IndexOffset;
    }

    @Override
    public Property getProperty(Name name) {
        int n = BeanUtil.indexOf(name.getName(), m_PropertyNameStrings);
        if (n < 0) {
            return super.getProperty(name);
        }
        return new Property(this, n += m_IndexOffset);
    }

    @Override
    public Name getPropertyName(int n) {
        if (n < m_IndexOffset) {
            return super.getPropertyName(n);
        }
        return m_PropertyNames[n - m_IndexOffset];
    }

    @Override
    public PropertyType getPropertyType(int n) {
        if (n < m_IndexOffset) {
            return super.getPropertyType(n);
        }
        return m_PropertyTypes[n - m_IndexOffset];
    }

    @Override
    public void setPropertyValue(int n, Object object) {
        if (n < m_IndexOffset) {
            super.setPropertyValue(n, object);
        } else {
            try {
                switch (n -= m_IndexOffset) {
                    case 0: {
                        this.m_Fill = (Boolean)object;
                        if (Boolean.TRUE.equals(this.m_Fill)) {
                            this.doFill();
                        }
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("No such property index: " + n + " in " + this.getClass());
                    }
                }
            }
            catch (Exception exception) {
                throw new IllegalArgumentException("Error setting " + n + " with " + object + "(" + object.getClass() + ") : " + exception);
            }
        }
    }

    @Override
    public Object getPropertyValue(Name name) {
        String string = name.getName();
        int n = BeanUtil.indexOf(string, m_PropertyNameStrings);
        if (n < 0) {
            return super.getPropertyValue(name);
        }
        return this.getPropertyValue(m_IndexOffset + n);
    }

    @Override
    public boolean isLocalPropertyValue(int n) {
        return this.getLocalPropertyValue(n) != null;
    }

    @Override
    protected Object getLocalPropertyValue(int n) {
        if (n < m_IndexOffset) {
            return super.getLocalPropertyValue(n);
        }
        switch (n - m_IndexOffset) {
            case 0: {
                return this.m_Fill;
            }
        }
        throw new IllegalArgumentException("No such property index " + n + " in " + this.getClass());
    }

    @Override
    protected Object getDefaultPropertyValue(int n) {
        Style style;
        Object object;
        if (n < m_IndexOffset) {
            return super.getDefaultPropertyValue(n);
        }
        Object object2 = null;
        Name name = m_PropertyNames[n - m_IndexOffset];
        if (this.m_Style != null) {
            object2 = this.m_Style.getValue(name);
        }
        if (object2 == null && StyleManager.isInherited(name) && (object = this.getParentStyledElement()) != null) {
            object2 = object.getPropertyValue(name);
        }
        if (object2 == null && (object = this.getResourceProvider()) != null && (style = object.getStyle(this.getDefaultStyle())) != null) {
            object2 = style.getValue(name);
        }
        if (object2 == null) {
            object2 = DefaultStyle.current().getValue(name);
        }
        return object2;
    }

    public static int getIndexOffset() {
        return m_IndexOffset;
    }

    @Override
    public abstract BasicRawElementHolder deepCopy();

    protected void copyInto(BasicRawElementHolder basicRawElementHolder) {
        super.copyInto(basicRawElementHolder);
        basicRawElementHolder.m_Fill = this.m_Fill;
        basicRawElementHolder.m_RawElement = new ArrayList<RawModelElement>();
        for (RawModelElement rawModelElement : this.m_RawElement) {
            basicRawElementHolder.addRawElement(rawModelElement.deepCopy());
        }
    }

    static {
        try {
            m_IndexOffset = RawModelElement.getStaticPropertyCount();
            int n = m_PropertyNameStrings.length;
            m_PropertyNames = new Name[n];
            m_PropertyTypes = new PropertyType[n];
            for (int i = 0; i < n; ++i) {
                BasicRawElementHolder.m_PropertyNames[i] = BeanUtil.getName(m_PropertyNameStrings[i]);
                BasicRawElementHolder.m_PropertyTypes[i] = BeanUtil.getType(m_PropertyTypeStrings[i]);
            }
        }
        catch (Throwable throwable) {
            BasicRawElementHolder.logError("Error in property initialization", throwable);
        }
    }
}

