/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.report2.raw.model;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.arch.StringUtil;
import com.elixirtech.data2.function.FunctionFactory;
import com.elixirtech.jdom.Element;
import com.elixirtech.sax.IBean;

public class ControlSource
implements IBean {
    private static ElxLoggerJ m_Log = ElxLoggerJ.getLogger(ControlSource.class);
    protected boolean m_IsLoaded;
    public static final String FIELD = "Field";
    public static final String OPERATION = "Operation";
    public static final String SCRIPT = "Script";
    public static final String URL = "URL";
    public static final String LITERAL = "Literal";
    public static final String ALL = "All";
    public static final String GROUP = "Group";
    public static final String TEXT = "Text";
    public static final String IMAGE = "Image";
    public static final String GLINT = "Glint";
    protected String m_Type;
    protected String m_DataSource;
    protected String m_Field;
    protected String m_Operation;
    protected boolean m_RunningValue;
    protected String m_Range;
    protected String m_URL;
    protected String m_URLType;
    protected String m_DisplayName;
    protected String m_Text = "";

    protected static void logError(String string) {
        m_Log.error((Object)string);
    }

    protected static void logError(String string, Throwable throwable) {
        m_Log.error((Object)string, throwable);
    }

    protected static void logInfo(String string) {
        m_Log.info((Object)string);
    }

    public static boolean isHidden(String string) {
        return false;
    }

    public ControlSource() {
        this.m_Type = FIELD;
    }

    @Override
    public String getTagName() {
        return "control-source";
    }

    @Override
    public void loaded() {
        this.m_IsLoaded = true;
    }

    @Override
    public void dispose() {
    }

    public void copyAttrs(Element element) {
        if (this.m_Type != null) {
            element.setAttribute("type", this.m_Type);
        }
        if (this.m_DataSource != null) {
            element.setAttribute("datasource", this.m_DataSource);
        }
        if (this.m_Field != null) {
            element.setAttribute("field", this.m_Field);
        }
        if (this.m_Operation != null) {
            element.setAttribute("operation", this.m_Operation);
        }
        element.setAttribute("running-value", this.m_RunningValue ? "Yes" : "No");
        if (this.m_Range != null) {
            element.setAttribute("range", this.m_Range);
        }
        if (this.m_URL != null) {
            element.setAttribute("url", this.m_URL);
        }
        if (this.m_URLType != null) {
            element.setAttribute("url-type", this.m_URLType);
        }
        if (this.m_DisplayName != null) {
            element.setAttribute("display-name", this.m_DisplayName);
        }
    }

    public Object shallowCopy() throws InstantiationException, IllegalAccessException {
        ControlSource controlSource = (ControlSource)this.getClass().newInstance();
        controlSource.m_Type = this.m_Type;
        controlSource.m_DataSource = this.m_DataSource;
        controlSource.m_Field = this.m_Field;
        controlSource.m_Operation = this.m_Operation;
        controlSource.m_RunningValue = this.m_RunningValue;
        controlSource.m_Range = this.m_Range;
        controlSource.m_URL = this.m_URL;
        controlSource.m_URLType = this.m_URLType;
        controlSource.m_DisplayName = this.m_DisplayName;
        return controlSource;
    }

    public ControlSource(String string) {
        this.setText(string);
    }

    public String toString() {
        return this.getText();
    }

    public String getDisplayNameValue() {
        if (StringUtil.notEmpty(this.m_DisplayName)) {
            return this.m_DisplayName;
        }
        if (FIELD.equals(this.m_Type)) {
            return this.getFieldName();
        }
        if (OPERATION.equals(this.m_Type)) {
            Object object = FunctionFactory.getI18N(this.m_Operation);
            return String.valueOf(object) + "(" + this.getFieldName() + ")";
        }
        if (SCRIPT.equals(this.m_Type)) {
            return this.getScriptName();
        }
        if (URL.equals(this.m_Type)) {
            return this.m_URL;
        }
        if (LITERAL.equals(this.m_Type)) {
            return this.m_Text;
        }
        return this.m_Type;
    }

    public boolean equals(Object object) {
        if (!(object instanceof ControlSource)) {
            return false;
        }
        ControlSource controlSource = (ControlSource)object;
        if (!ControlSource.equals(this.m_Type, controlSource.m_Type)) {
            return false;
        }
        if (FIELD.equals(this.m_Type)) {
            if (!ControlSource.equals(this.m_DataSource, controlSource.m_DataSource)) {
                return false;
            }
            return ControlSource.equals(this.m_Field, controlSource.m_Field);
        }
        if (OPERATION.equals(this.m_Type)) {
            if (!ControlSource.equals(this.m_DataSource, controlSource.m_DataSource)) {
                return false;
            }
            if (!ControlSource.equals(this.m_Field, controlSource.m_Field)) {
                return false;
            }
            if (!ControlSource.equals(this.m_Operation, controlSource.m_Operation)) {
                return false;
            }
            if (this.m_RunningValue != controlSource.m_RunningValue) {
                return false;
            }
            return ControlSource.equals(this.m_Range, controlSource.m_Range);
        }
        if (SCRIPT.equals(this.m_Type) || LITERAL.equals(this.m_Type)) {
            if (!ControlSource.equals(this.m_Operation, controlSource.m_Operation)) {
                return false;
            }
            return ControlSource.equals(this.m_Text, controlSource.m_Text);
        }
        if (URL.equals(this.m_Type)) {
            if (!ControlSource.equals(this.m_URL, controlSource.m_URL)) {
                return false;
            }
            return ControlSource.equals(this.m_URLType, controlSource.m_URLType);
        }
        return false;
    }

    private String getFieldName() {
        if (StringUtil.notEmpty(this.m_DataSource)) {
            return this.m_DataSource + ":" + this.m_Field;
        }
        return this.m_Field;
    }

    private String getScriptName() {
        String string = this.m_Text;
        if (string.startsWith("=")) {
            string = string.substring(1);
        }
        if (string.startsWith("//")) {
            string = string.substring(2);
        }
        return string.split("\n")[0].trim();
    }

    private static boolean equals(Object object, Object object2) {
        if (object == null) {
            return object2 == null;
        }
        return object.equals(object2);
    }

    public String getType() {
        return this.m_Type;
    }

    public void setType(String string) {
        this.m_Type = string;
    }

    public String getDataSource() {
        return this.m_DataSource;
    }

    public void setDataSource(String string) {
        this.m_DataSource = string;
    }

    public String getField() {
        return this.m_Field;
    }

    public void setField(String string) {
        this.m_Field = string;
    }

    public String getOperation() {
        return this.m_Operation;
    }

    public void setOperation(String string) {
        this.m_Operation = string;
    }

    public boolean isRunningValue() {
        return this.m_RunningValue;
    }

    public void setRunningValue(boolean bl) {
        this.m_RunningValue = bl;
    }

    public String getRange() {
        return this.m_Range;
    }

    public void setRange(String string) {
        this.m_Range = string;
    }

    public String getURL() {
        return this.m_URL;
    }

    public void setURL(String string) {
        this.m_URL = string;
    }

    public String getURLType() {
        return this.m_URLType;
    }

    public void setURLType(String string) {
        this.m_URLType = string;
    }

    public String getDisplayName() {
        return this.m_DisplayName;
    }

    public void setDisplayName(String string) {
        this.m_DisplayName = string;
    }

    public void addText(String string) {
        this.m_Text = this.m_Text == null ? string : this.m_Text + string;
    }

    public void setText(String string) {
        this.m_Text = string;
    }

    public String getText() {
        return this.m_Text;
    }

    public ControlSource deepCopy() {
        ControlSource controlSource = new ControlSource();
        this.copyInto(controlSource);
        return controlSource;
    }

    protected void copyInto(ControlSource controlSource) {
        controlSource.m_Type = this.m_Type;
        controlSource.m_DataSource = this.m_DataSource;
        controlSource.m_Field = this.m_Field;
        controlSource.m_Operation = this.m_Operation;
        controlSource.m_RunningValue = this.m_RunningValue;
        controlSource.m_Range = this.m_Range;
        controlSource.m_URL = this.m_URL;
        controlSource.m_URLType = this.m_URLType;
        controlSource.m_DisplayName = this.m_DisplayName;
        controlSource.m_Text = this.m_Text;
    }
}

