/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.report2.raw.model;

import com.elixirtech.ensemble.cube.IMeasure;
import com.elixirtech.i18n.Name;
import com.elixirtech.jdom.Element;
import com.elixirtech.property.DefaultStyle;
import com.elixirtech.property.Property;
import com.elixirtech.property.PropertyImplementor;
import com.elixirtech.property.PropertyType;
import com.elixirtech.report2.ShapeBuilder;
import com.elixirtech.report2.raw.StyleManager;
import com.elixirtech.report2.raw.model.CellRender;
import com.elixirtech.report2.raw.model.Format;
import com.elixirtech.report2.raw.model.IFormatHolder;
import com.elixirtech.report2.raw.model.ITextElement;
import com.elixirtech.report2.raw.model.RawModelElement;
import com.elixirtech.report2.raw.model.Shape;
import com.elixirtech.report2.raw.model.Style;
import com.elixirtech.sax.BeanUtil;
import com.elixirtech.sax.IBean;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;

public class CubeMeasure
extends RawModelElement
implements IBean,
PropertyImplementor,
IFormatHolder,
ITextElement,
IMeasure {
    protected Format m_Format;
    protected List<CellRender> m_CellRender = new ArrayList<CellRender>();
    protected String m_Name;
    protected String m_Function;
    protected String m_Pattern;
    protected String m_TextAlignment;
    protected String m_IconAlignment;
    protected Boolean m_ShowText;
    protected Boolean m_ShowIcon;
    protected Locale m_Locale;
    protected String m_BackgroundColor;
    protected String m_FontName;
    protected Integer m_FontSize;
    protected Boolean m_FontBold;
    protected Boolean m_FontItalic;
    protected String m_FontColor;
    protected Boolean m_FontUnderline;
    protected Boolean m_FontStrikethrough;
    protected Integer m_PaddingLeft;
    protected Integer m_PaddingRight;
    protected Integer m_PaddingTop;
    protected Integer m_PaddingBottom;
    protected String m_BorderStyle;
    protected Integer m_BorderWidth;
    protected String m_BorderColor;
    protected Boolean m_BorderLeft;
    protected Boolean m_BorderRight;
    protected Boolean m_BorderTop;
    protected Boolean m_BorderBottom;
    protected String m_WidthOverrideType;
    protected Integer m_WidthOverride;
    private static String[] m_PropertyNameStrings = new String[]{"CubeMeasure.TextAlignment".intern(), "CubeMeasure.IconAlignment".intern(), "CubeMeasure.ShowText".intern(), "CubeMeasure.ShowIcon".intern(), "Common.Locale".intern(), "Field.Format".intern(), "Common.BackgroundColor".intern(), "TextElement.FontName".intern(), "TextElement.FontSize".intern(), "TextElement.FontBold".intern(), "TextElement.FontItalic".intern(), "TextElement.FontColor".intern(), "TextElement.FontUnderline".intern(), "TextElement.FontStrikethrough".intern(), "RawElement.PaddingLeft".intern(), "RawElement.PaddingRight".intern(), "RawElement.PaddingTop".intern(), "RawElement.PaddingBottom".intern(), "RawElement.BorderStyle".intern(), "RawElement.BorderWidth".intern(), "RawElement.BorderColor".intern(), "Rectangle.BorderLeft".intern(), "Rectangle.BorderRight".intern(), "Rectangle.BorderTop".intern(), "Rectangle.BorderBottom".intern(), "CubeMeasure.WidthOverrideType".intern(), "CubeMeasure.WidthOverride".intern()};
    private static String[] m_PropertyTypeStrings = new String[]{"Choice.HorizontalAlignment", "Choice.LeftRightAlignment", "Boolean", "Boolean", "Locale", "Format", "Colour", "String", "Point", "Boolean", "Boolean", "Colour", "Boolean", "Boolean", "Twip", "Twip", "Twip", "Twip", "Choice.BorderStyle", "Twip", "Colour", "Boolean", "Boolean", "Boolean", "Boolean", "Choice.WidthOverride", "Twip"};
    private static int m_IndexOffset;
    private static Name[] m_PropertyNames;
    private static PropertyType[] m_PropertyTypes;

    public static boolean isHidden(String string) {
        if (BeanUtil.methodMatches(string, "RawModelElement.RenderIf")) {
            return true;
        }
        if (BeanUtil.methodMatches(string, "RawModelElement.OnRenderBegin")) {
            return true;
        }
        if (BeanUtil.methodMatches(string, "RawModelElement.OnRenderEnd")) {
            return true;
        }
        return BeanUtil.methodMatches(string, "RawModelElement.LockHandles");
    }

    public CubeMeasure() {
    }

    @Override
    public String getTagName() {
        return "cube-measure";
    }

    @Override
    public void loaded() {
        super.loaded();
        if (this.m_Format != null) {
            this.m_Format.loaded();
        }
        Iterator<CellRender> iterator = this.m_CellRender.iterator();
        while (iterator.hasNext()) {
            ((IBean)iterator.next()).loaded();
        }
    }

    @Override
    public void dispose() {
        if (this.m_Format != null) {
            if (this.m_Format != null) {
                this.m_Format.dispose();
            }
            this.m_Format = null;
        }
        if (this.m_CellRender != null) {
            Iterator<CellRender> iterator = this.m_CellRender.iterator();
            while (iterator.hasNext()) {
                ((IBean)iterator.next()).dispose();
            }
        }
        this.m_CellRender = null;
    }

    @Override
    public void copyAttrs(Element element) {
        if (this.m_Name != null) {
            element.setAttribute("name", this.m_Name);
        }
        if (this.m_Function != null) {
            element.setAttribute("function", this.m_Function);
        }
        if (this.m_Pattern != null) {
            element.setAttribute("pattern", this.m_Pattern);
        }
        if (this.m_TextAlignment != null) {
            element.setAttribute("text-align", this.m_TextAlignment);
        }
        if (this.m_IconAlignment != null) {
            element.setAttribute("icon-align", this.m_IconAlignment);
        }
        if (this.m_ShowText != null) {
            element.setAttribute("show-text", this.m_ShowText != false ? "Yes" : "No");
        }
        if (this.m_ShowIcon != null) {
            element.setAttribute("show-icon", this.m_ShowIcon != false ? "Yes" : "No");
        }
        if (this.m_Locale != null) {
            element.setAttribute("locale", this.m_Locale.toString());
        }
        if (this.m_BackgroundColor != null) {
            element.setAttribute("background-color", this.m_BackgroundColor);
        }
        if (this.m_FontName != null) {
            element.setAttribute("font-name", this.m_FontName);
        }
        if (this.m_FontSize != null) {
            element.setAttribute("font-size", this.m_FontSize.toString());
        }
        if (this.m_FontBold != null) {
            element.setAttribute("font-bold", this.m_FontBold != false ? "Yes" : "No");
        }
        if (this.m_FontItalic != null) {
            element.setAttribute("font-italic", this.m_FontItalic != false ? "Yes" : "No");
        }
        if (this.m_FontColor != null) {
            element.setAttribute("font-color", this.m_FontColor);
        }
        if (this.m_FontUnderline != null) {
            element.setAttribute("font-underline", this.m_FontUnderline != false ? "Yes" : "No");
        }
        if (this.m_FontStrikethrough != null) {
            element.setAttribute("font-strikethrough", this.m_FontStrikethrough != false ? "Yes" : "No");
        }
        if (this.m_PaddingLeft != null) {
            element.setAttribute("padding-left", this.m_PaddingLeft.toString());
        }
        if (this.m_PaddingRight != null) {
            element.setAttribute("padding-right", this.m_PaddingRight.toString());
        }
        if (this.m_PaddingTop != null) {
            element.setAttribute("padding-top", this.m_PaddingTop.toString());
        }
        if (this.m_PaddingBottom != null) {
            element.setAttribute("padding-bottom", this.m_PaddingBottom.toString());
        }
        if (this.m_BorderStyle != null) {
            element.setAttribute("border-style", this.m_BorderStyle);
        }
        if (this.m_BorderWidth != null) {
            element.setAttribute("border-width", this.m_BorderWidth.toString());
        }
        if (this.m_BorderColor != null) {
            element.setAttribute("border-color", this.m_BorderColor);
        }
        if (this.m_BorderLeft != null) {
            element.setAttribute("border-left", this.m_BorderLeft != false ? "Yes" : "No");
        }
        if (this.m_BorderRight != null) {
            element.setAttribute("border-right", this.m_BorderRight != false ? "Yes" : "No");
        }
        if (this.m_BorderTop != null) {
            element.setAttribute("border-top", this.m_BorderTop != false ? "Yes" : "No");
        }
        if (this.m_BorderBottom != null) {
            element.setAttribute("border-bottom", this.m_BorderBottom != false ? "Yes" : "No");
        }
        if (this.m_WidthOverrideType != null) {
            element.setAttribute("width-override-type", this.m_WidthOverrideType);
        }
        if (this.m_WidthOverride != null) {
            element.setAttribute("width-override", this.m_WidthOverride.toString());
        }
        super.copyAttrs(element);
    }

    @Override
    public Object shallowCopy() throws InstantiationException, IllegalAccessException {
        CubeMeasure cubeMeasure = (CubeMeasure)super.shallowCopy();
        cubeMeasure.m_Name = this.m_Name;
        cubeMeasure.m_Function = this.m_Function;
        cubeMeasure.m_Pattern = this.m_Pattern;
        return cubeMeasure;
    }

    public CubeMeasure(String string, String string2, String string3) {
        this();
        this.m_Name = string;
        this.m_Function = string2;
        this.m_Pattern = string3;
    }

    @Override
    public Shape getShape() {
        Shape shape = super.getShape();
        if (shape == null) {
            shape = ShapeBuilder.buildShape(this);
            this.setShape(shape);
        }
        return shape;
    }

    public int getLeftMargin() {
        int n = this.getPaddingLeft();
        if (this.isBorderLeft() && !"None".equals(this.getBorderStyle())) {
            n += this.getBorderWidth();
        }
        return n;
    }

    public int getTopMargin() {
        int n = this.getPaddingTop();
        if (this.isBorderTop() && !"None".equals(this.getBorderStyle())) {
            n += this.getBorderWidth();
        }
        return n;
    }

    public int getRightMargin() {
        int n = this.getPaddingRight();
        if (this.isBorderRight() && !"None".equals(this.getBorderStyle())) {
            n += this.getBorderWidth();
        }
        return n;
    }

    public int getBottomMargin() {
        int n = this.getPaddingBottom();
        if (this.isBorderBottom() && !"None".equals(this.getBorderStyle())) {
            n += this.getBorderWidth();
        }
        return n;
    }

    public void addCellRender(CellRender cellRender) {
        this.m_CellRender.add(cellRender);
    }

    public void addCellRender(int n, CellRender cellRender) {
        this.m_CellRender.add(n, cellRender);
    }

    public void addAllCellRenders(Collection<CellRender> collection) {
        this.m_CellRender.addAll(collection);
    }

    public int indexOfCellRender(CellRender cellRender) {
        return this.m_CellRender.indexOf(cellRender);
    }

    public void removeCellRender(CellRender cellRender) {
        this.m_CellRender.remove(cellRender);
    }

    public void removeAllCellRenders(Collection collection) {
        this.m_CellRender.removeAll(collection);
    }

    public void removeAllCellRenders() {
        this.m_CellRender.clear();
    }

    public CellRender getCellRender(int n) {
        return this.m_CellRender.get(n);
    }

    public int getCellRenderCount() {
        return this.m_CellRender.size();
    }

    public Iterator<CellRender> getCellRenderIterator() {
        return this.m_CellRender.iterator();
    }

    public List<CellRender> getCellRenderList() {
        return this.m_CellRender;
    }

    public void setCellRenderList(List<CellRender> list) {
        this.m_CellRender = list;
    }

    @Override
    public String getName() {
        return this.m_Name;
    }

    @Override
    public void setName(String string) {
        this.m_Name = string;
    }

    @Override
    public String getFunction() {
        return this.m_Function;
    }

    @Override
    public void setFunction(String string) {
        this.m_Function = string;
    }

    @Override
    public String getPattern() {
        return this.m_Pattern;
    }

    @Override
    public void setPattern(String string) {
        this.m_Pattern = string;
    }

    @Override
    public void cacheProperties() {
        int n = this.getPropertyCount();
        for (int i = 0; i < n; ++i) {
            Object object = this.getLocalPropertyValue(i);
            if (object != null) continue;
            object = this.getDefaultPropertyValue(i);
            this.setPropertyValue(i, object);
        }
    }

    @Override
    public Format getFormat() {
        if (this.m_Format != null) {
            return this.m_Format;
        }
        return (Format)this.getDefaultPropertyValue(m_IndexOffset + 6 - 1);
    }

    @Override
    public void setFormat(Format format) {
        this.m_Format = format;
    }

    public String getTextAlignment() {
        if (this.m_TextAlignment != null) {
            return this.m_TextAlignment;
        }
        return (String)this.getDefaultPropertyValue(m_IndexOffset + 1 - 1);
    }

    public void setTextAlignment(String string) {
        this.m_TextAlignment = string;
    }

    public String getIconAlignment() {
        if (this.m_IconAlignment != null) {
            return this.m_IconAlignment;
        }
        return (String)this.getDefaultPropertyValue(m_IndexOffset + 2 - 1);
    }

    public void setIconAlignment(String string) {
        this.m_IconAlignment = string;
    }

    public boolean isShowText() {
        Boolean bl = this.m_ShowText;
        if (bl == null) {
            bl = (Boolean)this.getDefaultPropertyValue(m_IndexOffset + 3 - 1);
        }
        return bl;
    }

    public void setShowText(boolean bl) {
        this.m_ShowText = bl;
    }

    public void setShowText(Boolean bl) {
        this.m_ShowText = bl;
    }

    public boolean isShowIcon() {
        Boolean bl = this.m_ShowIcon;
        if (bl == null) {
            bl = (Boolean)this.getDefaultPropertyValue(m_IndexOffset + 4 - 1);
        }
        return bl;
    }

    public void setShowIcon(boolean bl) {
        this.m_ShowIcon = bl;
    }

    public void setShowIcon(Boolean bl) {
        this.m_ShowIcon = bl;
    }

    @Override
    public Locale getLocale() {
        if (this.m_Locale != null) {
            return this.m_Locale;
        }
        return (Locale)this.getDefaultPropertyValue(m_IndexOffset + 5 - 1);
    }

    public void setLocale(Locale locale) {
        this.m_Locale = locale;
    }

    public String getBackgroundColor() {
        if (this.m_BackgroundColor != null) {
            return this.m_BackgroundColor;
        }
        return (String)this.getDefaultPropertyValue(m_IndexOffset + 7 - 1);
    }

    public void setBackgroundColor(String string) {
        this.m_BackgroundColor = string;
    }

    @Override
    public String getFontName() {
        if (this.m_FontName != null) {
            return this.m_FontName;
        }
        return (String)this.getDefaultPropertyValue(m_IndexOffset + 8 - 1);
    }

    @Override
    public void setFontName(String string) {
        this.m_FontName = string;
    }

    @Override
    public int getFontSize() {
        Integer n = this.m_FontSize;
        if (n == null) {
            n = (Integer)this.getDefaultPropertyValue(m_IndexOffset + 9 - 1);
        }
        return n;
    }

    @Override
    public void setFontSize(int n) {
        if (n < 0) {
            n = 0;
        }
        this.m_FontSize = n;
    }

    public void setFontSize(Integer n) {
        if (n != null && n < 0) {
            n = 0;
        }
        this.m_FontSize = n;
    }

    @Override
    public boolean isFontBold() {
        Boolean bl = this.m_FontBold;
        if (bl == null) {
            bl = (Boolean)this.getDefaultPropertyValue(m_IndexOffset + 10 - 1);
        }
        return bl;
    }

    @Override
    public void setFontBold(boolean bl) {
        this.m_FontBold = bl;
    }

    public void setFontBold(Boolean bl) {
        this.m_FontBold = bl;
    }

    @Override
    public boolean isFontItalic() {
        Boolean bl = this.m_FontItalic;
        if (bl == null) {
            bl = (Boolean)this.getDefaultPropertyValue(m_IndexOffset + 11 - 1);
        }
        return bl;
    }

    @Override
    public void setFontItalic(boolean bl) {
        this.m_FontItalic = bl;
    }

    public void setFontItalic(Boolean bl) {
        this.m_FontItalic = bl;
    }

    @Override
    public String getFontColor() {
        if (this.m_FontColor != null) {
            return this.m_FontColor;
        }
        return (String)this.getDefaultPropertyValue(m_IndexOffset + 12 - 1);
    }

    @Override
    public void setFontColor(String string) {
        this.m_FontColor = string;
    }

    @Override
    public boolean isFontUnderline() {
        Boolean bl = this.m_FontUnderline;
        if (bl == null) {
            bl = (Boolean)this.getDefaultPropertyValue(m_IndexOffset + 13 - 1);
        }
        return bl;
    }

    @Override
    public void setFontUnderline(boolean bl) {
        this.m_FontUnderline = bl;
    }

    public void setFontUnderline(Boolean bl) {
        this.m_FontUnderline = bl;
    }

    @Override
    public boolean isFontStrikethrough() {
        Boolean bl = this.m_FontStrikethrough;
        if (bl == null) {
            bl = (Boolean)this.getDefaultPropertyValue(m_IndexOffset + 14 - 1);
        }
        return bl;
    }

    @Override
    public void setFontStrikethrough(boolean bl) {
        this.m_FontStrikethrough = bl;
    }

    public void setFontStrikethrough(Boolean bl) {
        this.m_FontStrikethrough = bl;
    }

    public int getPaddingLeft() {
        Integer n = this.m_PaddingLeft;
        if (n == null) {
            n = (Integer)this.getDefaultPropertyValue(m_IndexOffset + 15 - 1);
        }
        return n;
    }

    public void setPaddingLeft(int n) {
        if (n < 0) {
            n = 0;
        }
        this.m_PaddingLeft = n;
    }

    public void setPaddingLeft(Integer n) {
        if (n != null && n < 0) {
            n = 0;
        }
        this.m_PaddingLeft = n;
    }

    public int getPaddingRight() {
        Integer n = this.m_PaddingRight;
        if (n == null) {
            n = (Integer)this.getDefaultPropertyValue(m_IndexOffset + 16 - 1);
        }
        return n;
    }

    public void setPaddingRight(int n) {
        if (n < 0) {
            n = 0;
        }
        this.m_PaddingRight = n;
    }

    public void setPaddingRight(Integer n) {
        if (n != null && n < 0) {
            n = 0;
        }
        this.m_PaddingRight = n;
    }

    public int getPaddingTop() {
        Integer n = this.m_PaddingTop;
        if (n == null) {
            n = (Integer)this.getDefaultPropertyValue(m_IndexOffset + 17 - 1);
        }
        return n;
    }

    public void setPaddingTop(int n) {
        if (n < 0) {
            n = 0;
        }
        this.m_PaddingTop = n;
    }

    public void setPaddingTop(Integer n) {
        if (n != null && n < 0) {
            n = 0;
        }
        this.m_PaddingTop = n;
    }

    public int getPaddingBottom() {
        Integer n = this.m_PaddingBottom;
        if (n == null) {
            n = (Integer)this.getDefaultPropertyValue(m_IndexOffset + 18 - 1);
        }
        return n;
    }

    public void setPaddingBottom(int n) {
        if (n < 0) {
            n = 0;
        }
        this.m_PaddingBottom = n;
    }

    public void setPaddingBottom(Integer n) {
        if (n != null && n < 0) {
            n = 0;
        }
        this.m_PaddingBottom = n;
    }

    public String getBorderStyle() {
        if (this.m_BorderStyle != null) {
            return this.m_BorderStyle;
        }
        return (String)this.getDefaultPropertyValue(m_IndexOffset + 19 - 1);
    }

    public void setBorderStyle(String string) {
        this.m_BorderStyle = string;
    }

    public int getBorderWidth() {
        Integer n = this.m_BorderWidth;
        if (n == null) {
            n = (Integer)this.getDefaultPropertyValue(m_IndexOffset + 20 - 1);
        }
        return n;
    }

    public void setBorderWidth(int n) {
        if (n < 0) {
            n = 0;
        }
        this.m_BorderWidth = n;
    }

    public void setBorderWidth(Integer n) {
        if (n != null && n < 0) {
            n = 0;
        }
        this.m_BorderWidth = n;
    }

    public String getBorderColor() {
        if (this.m_BorderColor != null) {
            return this.m_BorderColor;
        }
        return (String)this.getDefaultPropertyValue(m_IndexOffset + 21 - 1);
    }

    public void setBorderColor(String string) {
        this.m_BorderColor = string;
    }

    public boolean isBorderLeft() {
        Boolean bl = this.m_BorderLeft;
        if (bl == null) {
            bl = (Boolean)this.getDefaultPropertyValue(m_IndexOffset + 22 - 1);
        }
        return bl;
    }

    public void setBorderLeft(boolean bl) {
        this.m_BorderLeft = bl;
    }

    public void setBorderLeft(Boolean bl) {
        this.m_BorderLeft = bl;
    }

    public boolean isBorderRight() {
        Boolean bl = this.m_BorderRight;
        if (bl == null) {
            bl = (Boolean)this.getDefaultPropertyValue(m_IndexOffset + 23 - 1);
        }
        return bl;
    }

    public void setBorderRight(boolean bl) {
        this.m_BorderRight = bl;
    }

    public void setBorderRight(Boolean bl) {
        this.m_BorderRight = bl;
    }

    public boolean isBorderTop() {
        Boolean bl = this.m_BorderTop;
        if (bl == null) {
            bl = (Boolean)this.getDefaultPropertyValue(m_IndexOffset + 24 - 1);
        }
        return bl;
    }

    public void setBorderTop(boolean bl) {
        this.m_BorderTop = bl;
    }

    public void setBorderTop(Boolean bl) {
        this.m_BorderTop = bl;
    }

    public boolean isBorderBottom() {
        Boolean bl = this.m_BorderBottom;
        if (bl == null) {
            bl = (Boolean)this.getDefaultPropertyValue(m_IndexOffset + 25 - 1);
        }
        return bl;
    }

    public void setBorderBottom(boolean bl) {
        this.m_BorderBottom = bl;
    }

    public void setBorderBottom(Boolean bl) {
        this.m_BorderBottom = bl;
    }

    public String getWidthOverrideType() {
        if (this.m_WidthOverrideType != null) {
            return this.m_WidthOverrideType;
        }
        return (String)this.getDefaultPropertyValue(m_IndexOffset + 26 - 1);
    }

    public void setWidthOverrideType(String string) {
        this.m_WidthOverrideType = string;
    }

    public int getWidthOverride() {
        Integer n = this.m_WidthOverride;
        if (n == null) {
            n = (Integer)this.getDefaultPropertyValue(m_IndexOffset + 27 - 1);
        }
        return n;
    }

    public void setWidthOverride(int n) {
        if (n < 0) {
            n = 0;
        }
        this.m_WidthOverride = n;
    }

    public void setWidthOverride(Integer n) {
        if (n != null && n < 0) {
            n = 0;
        }
        this.m_WidthOverride = n;
    }

    @Override
    public void getPropertyNames(Set<Name> set) {
        set.addAll(Arrays.asList(m_PropertyNames));
        super.getPropertyNames(set);
        set.remove(Name.apply("RawModelElement.RenderIf", ""));
        set.remove(Name.apply("RawModelElement.OnRenderBegin", ""));
        set.remove(Name.apply("RawModelElement.OnRenderEnd", ""));
        set.remove(Name.apply("RawModelElement.LockHandles", ""));
    }

    @Override
    public int getPropertyCount() {
        return m_IndexOffset + m_PropertyNameStrings.length;
    }

    public static int getStaticPropertyCount() {
        return m_IndexOffset + m_PropertyNameStrings.length;
    }

    @Override
    public int getPropertyIndex(String string) {
        int n = BeanUtil.indexOf(string, m_PropertyNameStrings);
        if (n < 0) {
            return super.getPropertyIndex(string);
        }
        return n += m_IndexOffset;
    }

    @Override
    public Property getProperty(Name name) {
        int n = BeanUtil.indexOf(name.getName(), m_PropertyNameStrings);
        if (n < 0) {
            return super.getProperty(name);
        }
        return new Property(this, n += m_IndexOffset);
    }

    @Override
    public Name getPropertyName(int n) {
        if (n < m_IndexOffset) {
            return super.getPropertyName(n);
        }
        return m_PropertyNames[n - m_IndexOffset];
    }

    @Override
    public PropertyType getPropertyType(int n) {
        if (n < m_IndexOffset) {
            return super.getPropertyType(n);
        }
        return m_PropertyTypes[n - m_IndexOffset];
    }

    @Override
    public void setPropertyValue(int n, Object object) {
        if (n < m_IndexOffset) {
            super.setPropertyValue(n, object);
        } else {
            try {
                switch (n -= m_IndexOffset) {
                    case 0: {
                        this.m_TextAlignment = (String)object;
                        break;
                    }
                    case 1: {
                        this.m_IconAlignment = (String)object;
                        break;
                    }
                    case 2: {
                        this.m_ShowText = (Boolean)object;
                        break;
                    }
                    case 3: {
                        this.m_ShowIcon = (Boolean)object;
                        break;
                    }
                    case 4: {
                        this.m_Locale = (Locale)object;
                        break;
                    }
                    case 5: {
                        this.m_Format = (Format)object;
                        break;
                    }
                    case 6: {
                        this.m_BackgroundColor = (String)object;
                        break;
                    }
                    case 7: {
                        this.m_FontName = (String)object;
                        break;
                    }
                    case 8: {
                        this.setFontSize((Integer)object);
                        break;
                    }
                    case 9: {
                        this.m_FontBold = (Boolean)object;
                        break;
                    }
                    case 10: {
                        this.m_FontItalic = (Boolean)object;
                        break;
                    }
                    case 11: {
                        this.m_FontColor = (String)object;
                        break;
                    }
                    case 12: {
                        this.m_FontUnderline = (Boolean)object;
                        break;
                    }
                    case 13: {
                        this.m_FontStrikethrough = (Boolean)object;
                        break;
                    }
                    case 14: {
                        this.setPaddingLeft((Integer)object);
                        break;
                    }
                    case 15: {
                        this.setPaddingRight((Integer)object);
                        break;
                    }
                    case 16: {
                        this.setPaddingTop((Integer)object);
                        break;
                    }
                    case 17: {
                        this.setPaddingBottom((Integer)object);
                        break;
                    }
                    case 18: {
                        this.m_BorderStyle = (String)object;
                        break;
                    }
                    case 19: {
                        this.setBorderWidth((Integer)object);
                        break;
                    }
                    case 20: {
                        this.m_BorderColor = (String)object;
                        break;
                    }
                    case 21: {
                        this.m_BorderLeft = (Boolean)object;
                        break;
                    }
                    case 22: {
                        this.m_BorderRight = (Boolean)object;
                        break;
                    }
                    case 23: {
                        this.m_BorderTop = (Boolean)object;
                        break;
                    }
                    case 24: {
                        this.m_BorderBottom = (Boolean)object;
                        break;
                    }
                    case 25: {
                        this.m_WidthOverrideType = (String)object;
                        break;
                    }
                    case 26: {
                        this.setWidthOverride((Integer)object);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("No such property index: " + n + " in " + this.getClass());
                    }
                }
            }
            catch (Exception exception) {
                throw new IllegalArgumentException("Error setting " + n + " with " + object + "(" + object.getClass() + ") : " + exception);
            }
        }
    }

    @Override
    public Object getPropertyValue(Name name) {
        String string = name.getName();
        int n = BeanUtil.indexOf(string, m_PropertyNameStrings);
        if (n < 0) {
            return super.getPropertyValue(name);
        }
        return this.getPropertyValue(m_IndexOffset + n);
    }

    @Override
    public boolean isLocalPropertyValue(int n) {
        return this.getLocalPropertyValue(n) != null;
    }

    @Override
    protected Object getLocalPropertyValue(int n) {
        if (n < m_IndexOffset) {
            return super.getLocalPropertyValue(n);
        }
        switch (n - m_IndexOffset) {
            case 0: {
                return this.m_TextAlignment;
            }
            case 1: {
                return this.m_IconAlignment;
            }
            case 2: {
                return this.m_ShowText;
            }
            case 3: {
                return this.m_ShowIcon;
            }
            case 4: {
                return this.m_Locale;
            }
            case 5: {
                return this.m_Format;
            }
            case 6: {
                return this.m_BackgroundColor;
            }
            case 7: {
                return this.m_FontName;
            }
            case 8: {
                return this.m_FontSize;
            }
            case 9: {
                return this.m_FontBold;
            }
            case 10: {
                return this.m_FontItalic;
            }
            case 11: {
                return this.m_FontColor;
            }
            case 12: {
                return this.m_FontUnderline;
            }
            case 13: {
                return this.m_FontStrikethrough;
            }
            case 14: {
                return this.m_PaddingLeft;
            }
            case 15: {
                return this.m_PaddingRight;
            }
            case 16: {
                return this.m_PaddingTop;
            }
            case 17: {
                return this.m_PaddingBottom;
            }
            case 18: {
                return this.m_BorderStyle;
            }
            case 19: {
                return this.m_BorderWidth;
            }
            case 20: {
                return this.m_BorderColor;
            }
            case 21: {
                return this.m_BorderLeft;
            }
            case 22: {
                return this.m_BorderRight;
            }
            case 23: {
                return this.m_BorderTop;
            }
            case 24: {
                return this.m_BorderBottom;
            }
            case 25: {
                return this.m_WidthOverrideType;
            }
            case 26: {
                return this.m_WidthOverride;
            }
        }
        throw new IllegalArgumentException("No such property index " + n + " in " + this.getClass());
    }

    @Override
    protected Object getDefaultPropertyValue(int n) {
        Style style;
        Object object;
        if (n < m_IndexOffset) {
            return super.getDefaultPropertyValue(n);
        }
        Object object2 = null;
        Name name = m_PropertyNames[n - m_IndexOffset];
        if (this.m_Style != null) {
            object2 = this.m_Style.getValue(name);
        }
        if (object2 == null && StyleManager.isInherited(name) && (object = this.getParentStyledElement()) != null) {
            object2 = object.getPropertyValue(name);
        }
        if (object2 == null && (object = this.getResourceProvider()) != null && (style = object.getStyle(this.getDefaultStyle())) != null) {
            object2 = style.getValue(name);
        }
        if (object2 == null) {
            object2 = DefaultStyle.current().getValue(name);
        }
        return object2;
    }

    public static int getIndexOffset() {
        return m_IndexOffset;
    }

    @Override
    public CubeMeasure deepCopy() {
        CubeMeasure cubeMeasure = new CubeMeasure();
        this.copyInto(cubeMeasure);
        return cubeMeasure;
    }

    protected void copyInto(CubeMeasure cubeMeasure) {
        super.copyInto(cubeMeasure);
        cubeMeasure.m_Name = this.m_Name;
        cubeMeasure.m_Function = this.m_Function;
        cubeMeasure.m_Pattern = this.m_Pattern;
        cubeMeasure.m_TextAlignment = this.m_TextAlignment;
        cubeMeasure.m_IconAlignment = this.m_IconAlignment;
        cubeMeasure.m_ShowText = this.m_ShowText;
        cubeMeasure.m_ShowIcon = this.m_ShowIcon;
        cubeMeasure.m_Locale = this.m_Locale;
        cubeMeasure.m_BackgroundColor = this.m_BackgroundColor;
        cubeMeasure.m_FontName = this.m_FontName;
        cubeMeasure.m_FontSize = this.m_FontSize;
        cubeMeasure.m_FontBold = this.m_FontBold;
        cubeMeasure.m_FontItalic = this.m_FontItalic;
        cubeMeasure.m_FontColor = this.m_FontColor;
        cubeMeasure.m_FontUnderline = this.m_FontUnderline;
        cubeMeasure.m_FontStrikethrough = this.m_FontStrikethrough;
        cubeMeasure.m_PaddingLeft = this.m_PaddingLeft;
        cubeMeasure.m_PaddingRight = this.m_PaddingRight;
        cubeMeasure.m_PaddingTop = this.m_PaddingTop;
        cubeMeasure.m_PaddingBottom = this.m_PaddingBottom;
        cubeMeasure.m_BorderStyle = this.m_BorderStyle;
        cubeMeasure.m_BorderWidth = this.m_BorderWidth;
        cubeMeasure.m_BorderColor = this.m_BorderColor;
        cubeMeasure.m_BorderLeft = this.m_BorderLeft;
        cubeMeasure.m_BorderRight = this.m_BorderRight;
        cubeMeasure.m_BorderTop = this.m_BorderTop;
        cubeMeasure.m_BorderBottom = this.m_BorderBottom;
        cubeMeasure.m_WidthOverrideType = this.m_WidthOverrideType;
        cubeMeasure.m_WidthOverride = this.m_WidthOverride;
        if (this.m_Format != null) {
            cubeMeasure.m_Format = this.m_Format.deepCopy();
        }
        cubeMeasure.m_CellRender = new ArrayList<CellRender>();
        for (CellRender cellRender : this.m_CellRender) {
            cubeMeasure.addCellRender(cellRender.deepCopy());
        }
    }

    static {
        try {
            m_IndexOffset = RawModelElement.getStaticPropertyCount();
            int n = m_PropertyNameStrings.length;
            m_PropertyNames = new Name[n];
            m_PropertyTypes = new PropertyType[n];
            for (int i = 0; i < n; ++i) {
                CubeMeasure.m_PropertyNames[i] = BeanUtil.getName(m_PropertyNameStrings[i]);
                CubeMeasure.m_PropertyTypes[i] = BeanUtil.getType(m_PropertyTypeStrings[i]);
            }
        }
        catch (Throwable throwable) {
            CubeMeasure.logError("Error in property initialization", throwable);
        }
    }
}

