/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.report2.raw.model;

import com.elixirtech.i18n.Name;
import com.elixirtech.jdom.Element;
import com.elixirtech.property.DefaultStyle;
import com.elixirtech.property.Property;
import com.elixirtech.property.PropertyImplementor;
import com.elixirtech.property.PropertyType;
import com.elixirtech.report2.raw.StyleManager;
import com.elixirtech.report2.raw.model.Chunk;
import com.elixirtech.report2.raw.model.CubeColumn;
import com.elixirtech.report2.raw.model.CubeHierarchy;
import com.elixirtech.report2.raw.model.CubeMeasure;
import com.elixirtech.report2.raw.model.CubeRow;
import com.elixirtech.report2.raw.model.IRawElementHolder;
import com.elixirtech.report2.raw.model.ISplittableElement;
import com.elixirtech.report2.raw.model.ITextElement;
import com.elixirtech.report2.raw.model.RawElement;
import com.elixirtech.report2.raw.model.RawModelElement;
import com.elixirtech.report2.raw.model.Style;
import com.elixirtech.sax.BeanUtil;
import com.elixirtech.sax.IBean;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;

public class CubeTable
extends RawElement
implements IBean,
PropertyImplementor,
IRawElementHolder,
ISplittableElement,
ITextElement {
    protected CubeColumn m_Column;
    protected CubeRow m_Row;
    protected List<CubeHierarchy> m_Hierarchy = new ArrayList<CubeHierarchy>();
    protected List<CubeMeasure> m_Measure = new ArrayList<CubeMeasure>();
    protected Boolean m_CollapseRows;
    protected Boolean m_CollapseColumns;
    protected Boolean m_KeepRowTotals;
    protected Boolean m_ShowRowHeaderLabels;
    protected Boolean m_KeepColumnTotals;
    protected String m_ColumnTotalsTitle;
    protected String m_RowTotalsTitle;
    protected Boolean m_ShowColumnHeaders;
    protected Boolean m_ShowRowHeaders;
    protected Boolean m_ShowColumnTotalsAfterDetails;
    protected Boolean m_ShowRowTotalsAfterDetails;
    protected Boolean m_KeepTogether;
    protected String m_Cache;
    protected String m_DataRange;
    protected Boolean m_WidthGrowable;
    protected Boolean m_WidthShrinkable;
    protected Boolean m_GrowHPageCount = Boolean.TRUE;
    protected Boolean m_MergeHeaderBorders;
    protected String m_FontName;
    protected Integer m_FontSize;
    protected Boolean m_FontBold;
    protected Boolean m_FontItalic;
    protected String m_FontColor;
    protected Boolean m_FontUnderline;
    protected Boolean m_FontStrikethrough;
    private static String[] m_PropertyNameStrings = new String[]{"CubeTable.CollapseRows".intern(), "CubeTable.CollapseColumns".intern(), "CubeTable.KeepRowTotals".intern(), "CubeTable.ShowRowHeaderLabels".intern(), "CubeTable.KeepColumnTotals".intern(), "CubeTable.ColumnTotalsTitle".intern(), "CubeTable.RowTotalsTitle".intern(), "CubeTable.ShowColumnHeaders".intern(), "CubeTable.ShowRowHeaders".intern(), "CubeTable.ShowColumnTotalsAfterDetails".intern(), "CubeTable.ShowRowTotalsAfterDetails".intern(), "Common.KeepTogether".intern(), "CubeTable.Cache".intern(), "CubeTable.DataRange".intern(), "CubeTable.WidthGrowable".intern(), "CubeTable.WidthShrinkable".intern(), "CubeTable.GrowHPageCount".intern(), "CubeTable.MergeHeaderBorders".intern(), "TextElement.FontName".intern(), "TextElement.FontSize".intern(), "TextElement.FontBold".intern(), "TextElement.FontItalic".intern(), "TextElement.FontColor".intern(), "TextElement.FontUnderline".intern(), "TextElement.FontStrikethrough".intern()};
    private static String[] m_PropertyTypeStrings = new String[]{"Boolean", "Boolean", "Boolean", "Boolean", "Boolean", "String", "String", "Boolean", "Boolean", "Boolean", "Boolean", "Boolean", "String", "Choice.DataRange", "Boolean", "Boolean", "Boolean", "Boolean", "String", "Point", "Boolean", "Boolean", "Colour", "Boolean", "Boolean"};
    private static int m_IndexOffset;
    private static Name[] m_PropertyNames;
    private static PropertyType[] m_PropertyTypes;

    public static boolean isHidden(String string) {
        return false;
    }

    @Override
    public String getTagName() {
        return "cube-table";
    }

    @Override
    public void loaded() {
        super.loaded();
        if (this.m_Column != null) {
            this.m_Column.loaded();
        }
        if (this.m_Row != null) {
            this.m_Row.loaded();
        }
        Iterator<IBean> iterator = this.m_Hierarchy.iterator();
        while (iterator.hasNext()) {
            ((IBean)iterator.next()).loaded();
        }
        iterator = this.m_Measure.iterator();
        while (iterator.hasNext()) {
            iterator.next().loaded();
        }
    }

    @Override
    public void dispose() {
        Iterator<IBean> iterator;
        if (this.m_Column != null) {
            if (this.m_Column != null) {
                this.m_Column.dispose();
            }
            this.m_Column = null;
        }
        if (this.m_Row != null) {
            if (this.m_Row != null) {
                this.m_Row.dispose();
            }
            this.m_Row = null;
        }
        if (this.m_Hierarchy != null) {
            iterator = this.m_Hierarchy.iterator();
            while (iterator.hasNext()) {
                ((IBean)iterator.next()).dispose();
            }
        }
        this.m_Hierarchy = null;
        if (this.m_Measure != null) {
            iterator = this.m_Measure.iterator();
            while (iterator.hasNext()) {
                iterator.next().dispose();
            }
        }
        this.m_Measure = null;
    }

    @Override
    public void copyAttrs(Element element) {
        if (this.m_CollapseRows != null) {
            element.setAttribute("collapse-rows", this.m_CollapseRows != false ? "Yes" : "No");
        }
        if (this.m_CollapseColumns != null) {
            element.setAttribute("collapse-columns", this.m_CollapseColumns != false ? "Yes" : "No");
        }
        if (this.m_KeepRowTotals != null) {
            element.setAttribute("keep-row-totals", this.m_KeepRowTotals != false ? "Yes" : "No");
        }
        if (this.m_ShowRowHeaderLabels != null) {
            element.setAttribute("show-row-header-labels", this.m_ShowRowHeaderLabels != false ? "Yes" : "No");
        }
        if (this.m_KeepColumnTotals != null) {
            element.setAttribute("keep-column-totals", this.m_KeepColumnTotals != false ? "Yes" : "No");
        }
        if (this.m_ColumnTotalsTitle != null) {
            element.setAttribute("column-totals-title", this.m_ColumnTotalsTitle);
        }
        if (this.m_RowTotalsTitle != null) {
            element.setAttribute("row-totals-title", this.m_RowTotalsTitle);
        }
        if (this.m_ShowColumnHeaders != null) {
            element.setAttribute("show-column-headers", this.m_ShowColumnHeaders != false ? "Yes" : "No");
        }
        if (this.m_ShowRowHeaders != null) {
            element.setAttribute("show-row-headers", this.m_ShowRowHeaders != false ? "Yes" : "No");
        }
        if (this.m_ShowColumnTotalsAfterDetails != null) {
            element.setAttribute("show-column-totals-after-details", this.m_ShowColumnTotalsAfterDetails != false ? "Yes" : "No");
        }
        if (this.m_ShowRowTotalsAfterDetails != null) {
            element.setAttribute("show-row-totals-after-details", this.m_ShowRowTotalsAfterDetails != false ? "Yes" : "No");
        }
        if (this.m_KeepTogether != null) {
            element.setAttribute("keep-together", this.m_KeepTogether != false ? "Yes" : "No");
        }
        if (this.m_Cache != null) {
            element.setAttribute("cache", this.m_Cache);
        }
        if (this.m_DataRange != null) {
            element.setAttribute("datarange", this.m_DataRange);
        }
        if (this.m_WidthGrowable != null) {
            element.setAttribute("can-grow-width", this.m_WidthGrowable != false ? "Yes" : "No");
        }
        if (this.m_WidthShrinkable != null) {
            element.setAttribute("can-shrink-width", this.m_WidthShrinkable != false ? "Yes" : "No");
        }
        if (this.m_GrowHPageCount != null) {
            element.setAttribute("can-grow-hpage-count", this.m_GrowHPageCount != false ? "Yes" : "No");
        }
        if (this.m_MergeHeaderBorders != null) {
            element.setAttribute("merge-header-borders", this.m_MergeHeaderBorders != false ? "Yes" : "No");
        }
        if (this.m_FontName != null) {
            element.setAttribute("font-name", this.m_FontName);
        }
        if (this.m_FontSize != null) {
            element.setAttribute("font-size", this.m_FontSize.toString());
        }
        if (this.m_FontBold != null) {
            element.setAttribute("font-bold", this.m_FontBold != false ? "Yes" : "No");
        }
        if (this.m_FontItalic != null) {
            element.setAttribute("font-italic", this.m_FontItalic != false ? "Yes" : "No");
        }
        if (this.m_FontColor != null) {
            element.setAttribute("font-color", this.m_FontColor);
        }
        if (this.m_FontUnderline != null) {
            element.setAttribute("font-underline", this.m_FontUnderline != false ? "Yes" : "No");
        }
        if (this.m_FontStrikethrough != null) {
            element.setAttribute("font-strikethrough", this.m_FontStrikethrough != false ? "Yes" : "No");
        }
        super.copyAttrs(element);
    }

    @Override
    public Object shallowCopy() throws InstantiationException, IllegalAccessException {
        CubeTable cubeTable = (CubeTable)super.shallowCopy();
        return cubeTable;
    }

    public String getType() {
        return "Cube";
    }

    public Icon getIcon() {
        return null;
    }

    public boolean isHierarchy(String string) {
        for (CubeHierarchy cubeHierarchy : this.m_Hierarchy) {
            if (!string.equals(cubeHierarchy.getName())) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getRawElementCount() {
        return this.m_Measure.size() + 2;
    }

    @Override
    public RawModelElement getRawElement(int n) {
        int n2 = this.m_Measure.size();
        if (n < n2) {
            return this.m_Measure.get(n);
        }
        if (n == n2) {
            return this.getRow();
        }
        if (n == n2 + 1) {
            return this.getColumn();
        }
        return null;
    }

    @Override
    public Iterator<RawModelElement> getRawElementIterator() {
        ArrayList<RawModelElement> arrayList = new ArrayList<RawModelElement>();
        arrayList.addAll(this.m_Measure);
        arrayList.add(this.getRow());
        arrayList.add(this.getColumn());
        return arrayList.iterator();
    }

    @Override
    public List<RawModelElement> getRawElementList() {
        ArrayList<RawModelElement> arrayList = new ArrayList<RawModelElement>();
        arrayList.addAll(this.m_Measure);
        arrayList.add(this.getRow());
        arrayList.add(this.getColumn());
        return arrayList;
    }

    @Override
    public int indexOfRawElement(RawModelElement rawModelElement) {
        int n = this.m_Measure.size();
        if (rawModelElement == this.getRow()) {
            return n;
        }
        if (rawModelElement == this.getColumn()) {
            return n + 1;
        }
        return this.m_Measure.indexOf(rawModelElement);
    }

    public CubeColumn getColumn() {
        return this.m_Column;
    }

    public void setColumn(CubeColumn cubeColumn) {
        this.m_Column = cubeColumn;
        this.m_Column.setParent(this);
    }

    public CubeRow getRow() {
        return this.m_Row;
    }

    public void setRow(CubeRow cubeRow) {
        this.m_Row = cubeRow;
        this.m_Row.setParent(this);
    }

    public void addHierarchy(CubeHierarchy cubeHierarchy) {
        this.m_Hierarchy.add(cubeHierarchy);
    }

    public void addHierarchy(int n, CubeHierarchy cubeHierarchy) {
        this.m_Hierarchy.add(n, cubeHierarchy);
    }

    public void addAllHierarchys(Collection<CubeHierarchy> collection) {
        this.m_Hierarchy.addAll(collection);
    }

    public int indexOfHierarchy(CubeHierarchy cubeHierarchy) {
        return this.m_Hierarchy.indexOf(cubeHierarchy);
    }

    public void removeHierarchy(CubeHierarchy cubeHierarchy) {
        this.m_Hierarchy.remove(cubeHierarchy);
    }

    public void removeAllHierarchys(Collection collection) {
        this.m_Hierarchy.removeAll(collection);
    }

    public void removeAllHierarchys() {
        this.m_Hierarchy.clear();
    }

    public CubeHierarchy getHierarchy(int n) {
        return this.m_Hierarchy.get(n);
    }

    public int getHierarchyCount() {
        return this.m_Hierarchy.size();
    }

    public Iterator<CubeHierarchy> getHierarchyIterator() {
        return this.m_Hierarchy.iterator();
    }

    public List<CubeHierarchy> getHierarchyList() {
        return this.m_Hierarchy;
    }

    public void setHierarchyList(List<CubeHierarchy> list) {
        this.m_Hierarchy = list;
    }

    public void addMeasure(CubeMeasure cubeMeasure) {
        this.m_Measure.add(cubeMeasure);
        cubeMeasure.setParent(this);
        Chunk.MyTreeModel myTreeModel = this.getTreeModel();
        if (myTreeModel != null) {
            int n = this.m_Measure.indexOf(cubeMeasure);
            myTreeModel.fireInsertedEvent(myTreeModel.getTreePath(this), new int[]{n}, new Object[]{cubeMeasure});
        }
    }

    public void addMeasure(int n, CubeMeasure cubeMeasure) {
        this.m_Measure.add(n, cubeMeasure);
        cubeMeasure.setParent(this);
        Chunk.MyTreeModel myTreeModel = this.getTreeModel();
        if (myTreeModel != null) {
            int n2 = this.m_Measure.indexOf(cubeMeasure);
            myTreeModel.fireInsertedEvent(myTreeModel.getTreePath(this), new int[]{n2}, new Object[]{cubeMeasure});
        }
    }

    public void addAllMeasures(Collection<CubeMeasure> collection) {
        this.m_Measure.addAll(collection);
        for (CubeMeasure cubeMeasure : collection) {
            cubeMeasure.setParent(this);
        }
        Chunk.MyTreeModel myTreeModel = this.getTreeModel();
        if (myTreeModel != null) {
            myTreeModel.fireStructureChangedEvent(myTreeModel.getTreePath(this));
        }
    }

    public int indexOfMeasure(CubeMeasure cubeMeasure) {
        return this.m_Measure.indexOf(cubeMeasure);
    }

    public void removeMeasure(CubeMeasure cubeMeasure) {
        int n = this.m_Measure.indexOf(cubeMeasure);
        this.m_Measure.remove(cubeMeasure);
        cubeMeasure.setParent(null);
        Chunk.MyTreeModel myTreeModel = this.getTreeModel();
        if (myTreeModel != null) {
            myTreeModel.fireRemovedEvent(myTreeModel.getTreePath(this), new int[]{n}, new Object[]{cubeMeasure});
        }
    }

    public void removeAllMeasures(Collection collection) {
        Object object2;
        this.m_Measure.removeAll(collection);
        for (Object object2 : collection) {
            ((RawModelElement)object2).setParent(null);
        }
        object2 = this.getTreeModel();
        if (object2 != null) {
            ((Chunk.MyTreeModel)object2).fireStructureChangedEvent(((Chunk.MyTreeModel)object2).getTreePath(this));
        }
    }

    public void removeAllMeasures() {
        for (CubeMeasure object2 : this.m_Measure) {
            object2.setParent(null);
        }
        this.m_Measure.clear();
        Chunk.MyTreeModel myTreeModel = this.getTreeModel();
        if (myTreeModel != null) {
            myTreeModel.fireStructureChangedEvent(myTreeModel.getTreePath(this));
        }
    }

    public CubeMeasure getMeasure(int n) {
        return this.m_Measure.get(n);
    }

    public int getMeasureCount() {
        return this.m_Measure.size();
    }

    public Iterator<CubeMeasure> getMeasureIterator() {
        return this.m_Measure.iterator();
    }

    public List<CubeMeasure> getMeasureList() {
        return this.m_Measure;
    }

    public void setMeasureList(List<CubeMeasure> list) {
        this.m_Measure = list;
        Chunk.MyTreeModel myTreeModel = this.getTreeModel();
        if (myTreeModel != null) {
            myTreeModel.fireStructureChangedEvent(myTreeModel.getTreePath(this));
        }
    }

    @Override
    public void cacheProperties() {
        int n = this.getPropertyCount();
        for (int i = 0; i < n; ++i) {
            Object object = this.getLocalPropertyValue(i);
            if (object != null) continue;
            object = this.getDefaultPropertyValue(i);
            this.setPropertyValue(i, object);
        }
    }

    public boolean isCollapseRows() {
        Boolean bl = this.m_CollapseRows;
        if (bl == null) {
            bl = (Boolean)this.getDefaultPropertyValue(m_IndexOffset + 1 - 1);
        }
        return bl;
    }

    public void setCollapseRows(boolean bl) {
        this.m_CollapseRows = bl;
    }

    public void setCollapseRows(Boolean bl) {
        this.m_CollapseRows = bl;
    }

    public boolean isCollapseColumns() {
        Boolean bl = this.m_CollapseColumns;
        if (bl == null) {
            bl = (Boolean)this.getDefaultPropertyValue(m_IndexOffset + 2 - 1);
        }
        return bl;
    }

    public void setCollapseColumns(boolean bl) {
        this.m_CollapseColumns = bl;
    }

    public void setCollapseColumns(Boolean bl) {
        this.m_CollapseColumns = bl;
    }

    public boolean isKeepRowTotals() {
        Boolean bl = this.m_KeepRowTotals;
        if (bl == null) {
            bl = (Boolean)this.getDefaultPropertyValue(m_IndexOffset + 3 - 1);
        }
        return bl;
    }

    public void setKeepRowTotals(boolean bl) {
        this.m_KeepRowTotals = bl;
    }

    public void setKeepRowTotals(Boolean bl) {
        this.m_KeepRowTotals = bl;
    }

    public boolean isShowRowHeaderLabels() {
        Boolean bl = this.m_ShowRowHeaderLabels;
        if (bl == null) {
            bl = (Boolean)this.getDefaultPropertyValue(m_IndexOffset + 4 - 1);
        }
        return bl;
    }

    public void setShowRowHeaderLabels(boolean bl) {
        this.m_ShowRowHeaderLabels = bl;
    }

    public void setShowRowHeaderLabels(Boolean bl) {
        this.m_ShowRowHeaderLabels = bl;
    }

    public boolean isKeepColumnTotals() {
        Boolean bl = this.m_KeepColumnTotals;
        if (bl == null) {
            bl = (Boolean)this.getDefaultPropertyValue(m_IndexOffset + 5 - 1);
        }
        return bl;
    }

    public void setKeepColumnTotals(boolean bl) {
        this.m_KeepColumnTotals = bl;
    }

    public void setKeepColumnTotals(Boolean bl) {
        this.m_KeepColumnTotals = bl;
    }

    public String getColumnTotalsTitle() {
        if (this.m_ColumnTotalsTitle != null) {
            return this.m_ColumnTotalsTitle;
        }
        return (String)this.getDefaultPropertyValue(m_IndexOffset + 6 - 1);
    }

    public void setColumnTotalsTitle(String string) {
        this.m_ColumnTotalsTitle = string;
    }

    public String getRowTotalsTitle() {
        if (this.m_RowTotalsTitle != null) {
            return this.m_RowTotalsTitle;
        }
        return (String)this.getDefaultPropertyValue(m_IndexOffset + 7 - 1);
    }

    public void setRowTotalsTitle(String string) {
        this.m_RowTotalsTitle = string;
    }

    public boolean isShowColumnHeaders() {
        Boolean bl = this.m_ShowColumnHeaders;
        if (bl == null) {
            bl = (Boolean)this.getDefaultPropertyValue(m_IndexOffset + 8 - 1);
        }
        return bl;
    }

    public void setShowColumnHeaders(boolean bl) {
        this.m_ShowColumnHeaders = bl;
    }

    public void setShowColumnHeaders(Boolean bl) {
        this.m_ShowColumnHeaders = bl;
    }

    public boolean isShowRowHeaders() {
        Boolean bl = this.m_ShowRowHeaders;
        if (bl == null) {
            bl = (Boolean)this.getDefaultPropertyValue(m_IndexOffset + 9 - 1);
        }
        return bl;
    }

    public void setShowRowHeaders(boolean bl) {
        this.m_ShowRowHeaders = bl;
    }

    public void setShowRowHeaders(Boolean bl) {
        this.m_ShowRowHeaders = bl;
    }

    public boolean isShowColumnTotalsAfterDetails() {
        Boolean bl = this.m_ShowColumnTotalsAfterDetails;
        if (bl == null) {
            bl = (Boolean)this.getDefaultPropertyValue(m_IndexOffset + 10 - 1);
        }
        return bl;
    }

    public void setShowColumnTotalsAfterDetails(boolean bl) {
        this.m_ShowColumnTotalsAfterDetails = bl;
    }

    public void setShowColumnTotalsAfterDetails(Boolean bl) {
        this.m_ShowColumnTotalsAfterDetails = bl;
    }

    public boolean isShowRowTotalsAfterDetails() {
        Boolean bl = this.m_ShowRowTotalsAfterDetails;
        if (bl == null) {
            bl = (Boolean)this.getDefaultPropertyValue(m_IndexOffset + 11 - 1);
        }
        return bl;
    }

    public void setShowRowTotalsAfterDetails(boolean bl) {
        this.m_ShowRowTotalsAfterDetails = bl;
    }

    public void setShowRowTotalsAfterDetails(Boolean bl) {
        this.m_ShowRowTotalsAfterDetails = bl;
    }

    @Override
    public boolean isKeepTogether() {
        Boolean bl = this.m_KeepTogether;
        if (bl == null) {
            bl = (Boolean)this.getDefaultPropertyValue(m_IndexOffset + 12 - 1);
        }
        return bl;
    }

    @Override
    public void setKeepTogether(boolean bl) {
        this.m_KeepTogether = bl;
    }

    @Override
    public void setKeepTogether(Boolean bl) {
        this.m_KeepTogether = bl;
    }

    public String getCache() {
        if (this.m_Cache != null) {
            return this.m_Cache;
        }
        return (String)this.getDefaultPropertyValue(m_IndexOffset + 13 - 1);
    }

    public void setCache(String string) {
        this.m_Cache = string;
    }

    public String getDataRange() {
        if (this.m_DataRange != null) {
            return this.m_DataRange;
        }
        return (String)this.getDefaultPropertyValue(m_IndexOffset + 14 - 1);
    }

    public void setDataRange(String string) {
        this.m_DataRange = string;
    }

    public boolean isWidthGrowable() {
        Boolean bl = this.m_WidthGrowable;
        if (bl == null) {
            bl = (Boolean)this.getDefaultPropertyValue(m_IndexOffset + 15 - 1);
        }
        return bl;
    }

    public void setWidthGrowable(boolean bl) {
        this.m_WidthGrowable = bl;
    }

    public void setWidthGrowable(Boolean bl) {
        this.m_WidthGrowable = bl;
    }

    public boolean isWidthShrinkable() {
        Boolean bl = this.m_WidthShrinkable;
        if (bl == null) {
            bl = (Boolean)this.getDefaultPropertyValue(m_IndexOffset + 16 - 1);
        }
        return bl;
    }

    public void setWidthShrinkable(boolean bl) {
        this.m_WidthShrinkable = bl;
    }

    public void setWidthShrinkable(Boolean bl) {
        this.m_WidthShrinkable = bl;
    }

    public boolean isGrowHPageCount() {
        Boolean bl = this.m_GrowHPageCount;
        if (bl == null) {
            bl = (Boolean)this.getDefaultPropertyValue(m_IndexOffset + 17 - 1);
        }
        return bl;
    }

    public void setGrowHPageCount(boolean bl) {
        this.m_GrowHPageCount = bl;
    }

    public void setGrowHPageCount(Boolean bl) {
        this.m_GrowHPageCount = bl;
    }

    public boolean isMergeHeaderBorders() {
        Boolean bl = this.m_MergeHeaderBorders;
        if (bl == null) {
            bl = (Boolean)this.getDefaultPropertyValue(m_IndexOffset + 18 - 1);
        }
        return bl;
    }

    public void setMergeHeaderBorders(boolean bl) {
        this.m_MergeHeaderBorders = bl;
    }

    public void setMergeHeaderBorders(Boolean bl) {
        this.m_MergeHeaderBorders = bl;
    }

    @Override
    public String getFontName() {
        if (this.m_FontName != null) {
            return this.m_FontName;
        }
        return (String)this.getDefaultPropertyValue(m_IndexOffset + 19 - 1);
    }

    @Override
    public void setFontName(String string) {
        this.m_FontName = string;
    }

    @Override
    public int getFontSize() {
        Integer n = this.m_FontSize;
        if (n == null) {
            n = (Integer)this.getDefaultPropertyValue(m_IndexOffset + 20 - 1);
        }
        return n;
    }

    @Override
    public void setFontSize(int n) {
        if (n < 0) {
            n = 0;
        }
        this.m_FontSize = n;
    }

    public void setFontSize(Integer n) {
        if (n != null && n < 0) {
            n = 0;
        }
        this.m_FontSize = n;
    }

    @Override
    public boolean isFontBold() {
        Boolean bl = this.m_FontBold;
        if (bl == null) {
            bl = (Boolean)this.getDefaultPropertyValue(m_IndexOffset + 21 - 1);
        }
        return bl;
    }

    @Override
    public void setFontBold(boolean bl) {
        this.m_FontBold = bl;
    }

    public void setFontBold(Boolean bl) {
        this.m_FontBold = bl;
    }

    @Override
    public boolean isFontItalic() {
        Boolean bl = this.m_FontItalic;
        if (bl == null) {
            bl = (Boolean)this.getDefaultPropertyValue(m_IndexOffset + 22 - 1);
        }
        return bl;
    }

    @Override
    public void setFontItalic(boolean bl) {
        this.m_FontItalic = bl;
    }

    public void setFontItalic(Boolean bl) {
        this.m_FontItalic = bl;
    }

    @Override
    public String getFontColor() {
        if (this.m_FontColor != null) {
            return this.m_FontColor;
        }
        return (String)this.getDefaultPropertyValue(m_IndexOffset + 23 - 1);
    }

    @Override
    public void setFontColor(String string) {
        this.m_FontColor = string;
    }

    @Override
    public boolean isFontUnderline() {
        Boolean bl = this.m_FontUnderline;
        if (bl == null) {
            bl = (Boolean)this.getDefaultPropertyValue(m_IndexOffset + 24 - 1);
        }
        return bl;
    }

    @Override
    public void setFontUnderline(boolean bl) {
        this.m_FontUnderline = bl;
    }

    public void setFontUnderline(Boolean bl) {
        this.m_FontUnderline = bl;
    }

    @Override
    public boolean isFontStrikethrough() {
        Boolean bl = this.m_FontStrikethrough;
        if (bl == null) {
            bl = (Boolean)this.getDefaultPropertyValue(m_IndexOffset + 25 - 1);
        }
        return bl;
    }

    @Override
    public void setFontStrikethrough(boolean bl) {
        this.m_FontStrikethrough = bl;
    }

    public void setFontStrikethrough(Boolean bl) {
        this.m_FontStrikethrough = bl;
    }

    @Override
    public void getPropertyNames(Set<Name> set) {
        set.addAll(Arrays.asList(m_PropertyNames));
        super.getPropertyNames(set);
    }

    @Override
    public int getPropertyCount() {
        return m_IndexOffset + m_PropertyNameStrings.length;
    }

    public static int getStaticPropertyCount() {
        return m_IndexOffset + m_PropertyNameStrings.length;
    }

    @Override
    public int getPropertyIndex(String string) {
        int n = BeanUtil.indexOf(string, m_PropertyNameStrings);
        if (n < 0) {
            return super.getPropertyIndex(string);
        }
        return n += m_IndexOffset;
    }

    @Override
    public Property getProperty(Name name) {
        int n = BeanUtil.indexOf(name.getName(), m_PropertyNameStrings);
        if (n < 0) {
            return super.getProperty(name);
        }
        return new Property(this, n += m_IndexOffset);
    }

    @Override
    public Name getPropertyName(int n) {
        if (n < m_IndexOffset) {
            return super.getPropertyName(n);
        }
        return m_PropertyNames[n - m_IndexOffset];
    }

    @Override
    public PropertyType getPropertyType(int n) {
        if (n < m_IndexOffset) {
            return super.getPropertyType(n);
        }
        return m_PropertyTypes[n - m_IndexOffset];
    }

    @Override
    public void setPropertyValue(int n, Object object) {
        if (n < m_IndexOffset) {
            super.setPropertyValue(n, object);
        } else {
            try {
                switch (n -= m_IndexOffset) {
                    case 0: {
                        this.m_CollapseRows = (Boolean)object;
                        break;
                    }
                    case 1: {
                        this.m_CollapseColumns = (Boolean)object;
                        break;
                    }
                    case 2: {
                        this.m_KeepRowTotals = (Boolean)object;
                        break;
                    }
                    case 3: {
                        this.m_ShowRowHeaderLabels = (Boolean)object;
                        break;
                    }
                    case 4: {
                        this.m_KeepColumnTotals = (Boolean)object;
                        break;
                    }
                    case 5: {
                        this.m_ColumnTotalsTitle = (String)object;
                        break;
                    }
                    case 6: {
                        this.m_RowTotalsTitle = (String)object;
                        break;
                    }
                    case 7: {
                        this.m_ShowColumnHeaders = (Boolean)object;
                        break;
                    }
                    case 8: {
                        this.m_ShowRowHeaders = (Boolean)object;
                        break;
                    }
                    case 9: {
                        this.m_ShowColumnTotalsAfterDetails = (Boolean)object;
                        break;
                    }
                    case 10: {
                        this.m_ShowRowTotalsAfterDetails = (Boolean)object;
                        break;
                    }
                    case 11: {
                        this.m_KeepTogether = (Boolean)object;
                        break;
                    }
                    case 12: {
                        this.m_Cache = (String)object;
                        break;
                    }
                    case 13: {
                        this.m_DataRange = (String)object;
                        break;
                    }
                    case 14: {
                        this.m_WidthGrowable = (Boolean)object;
                        break;
                    }
                    case 15: {
                        this.m_WidthShrinkable = (Boolean)object;
                        break;
                    }
                    case 16: {
                        this.m_GrowHPageCount = (Boolean)object;
                        break;
                    }
                    case 17: {
                        this.m_MergeHeaderBorders = (Boolean)object;
                        break;
                    }
                    case 18: {
                        this.m_FontName = (String)object;
                        break;
                    }
                    case 19: {
                        this.setFontSize((Integer)object);
                        break;
                    }
                    case 20: {
                        this.m_FontBold = (Boolean)object;
                        break;
                    }
                    case 21: {
                        this.m_FontItalic = (Boolean)object;
                        break;
                    }
                    case 22: {
                        this.m_FontColor = (String)object;
                        break;
                    }
                    case 23: {
                        this.m_FontUnderline = (Boolean)object;
                        break;
                    }
                    case 24: {
                        this.m_FontStrikethrough = (Boolean)object;
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("No such property index: " + n + " in " + this.getClass());
                    }
                }
            }
            catch (Exception exception) {
                throw new IllegalArgumentException("Error setting " + n + " with " + object + "(" + object.getClass() + ") : " + exception);
            }
        }
    }

    @Override
    public Object getPropertyValue(Name name) {
        String string = name.getName();
        int n = BeanUtil.indexOf(string, m_PropertyNameStrings);
        if (n < 0) {
            return super.getPropertyValue(name);
        }
        return this.getPropertyValue(m_IndexOffset + n);
    }

    @Override
    public boolean isLocalPropertyValue(int n) {
        return this.getLocalPropertyValue(n) != null;
    }

    @Override
    protected Object getLocalPropertyValue(int n) {
        if (n < m_IndexOffset) {
            return super.getLocalPropertyValue(n);
        }
        switch (n - m_IndexOffset) {
            case 0: {
                return this.m_CollapseRows;
            }
            case 1: {
                return this.m_CollapseColumns;
            }
            case 2: {
                return this.m_KeepRowTotals;
            }
            case 3: {
                return this.m_ShowRowHeaderLabels;
            }
            case 4: {
                return this.m_KeepColumnTotals;
            }
            case 5: {
                return this.m_ColumnTotalsTitle;
            }
            case 6: {
                return this.m_RowTotalsTitle;
            }
            case 7: {
                return this.m_ShowColumnHeaders;
            }
            case 8: {
                return this.m_ShowRowHeaders;
            }
            case 9: {
                return this.m_ShowColumnTotalsAfterDetails;
            }
            case 10: {
                return this.m_ShowRowTotalsAfterDetails;
            }
            case 11: {
                return this.m_KeepTogether;
            }
            case 12: {
                return this.m_Cache;
            }
            case 13: {
                return this.m_DataRange;
            }
            case 14: {
                return this.m_WidthGrowable;
            }
            case 15: {
                return this.m_WidthShrinkable;
            }
            case 16: {
                return this.m_GrowHPageCount;
            }
            case 17: {
                return this.m_MergeHeaderBorders;
            }
            case 18: {
                return this.m_FontName;
            }
            case 19: {
                return this.m_FontSize;
            }
            case 20: {
                return this.m_FontBold;
            }
            case 21: {
                return this.m_FontItalic;
            }
            case 22: {
                return this.m_FontColor;
            }
            case 23: {
                return this.m_FontUnderline;
            }
            case 24: {
                return this.m_FontStrikethrough;
            }
        }
        throw new IllegalArgumentException("No such property index " + n + " in " + this.getClass());
    }

    @Override
    protected Object getDefaultPropertyValue(int n) {
        Style style;
        Object object;
        if (n < m_IndexOffset) {
            return super.getDefaultPropertyValue(n);
        }
        Object object2 = null;
        Name name = m_PropertyNames[n - m_IndexOffset];
        if (this.m_Style != null) {
            object2 = this.m_Style.getValue(name);
        }
        if (object2 == null && StyleManager.isInherited(name) && (object = this.getParentStyledElement()) != null) {
            object2 = object.getPropertyValue(name);
        }
        if (object2 == null && (object = this.getResourceProvider()) != null && (style = object.getStyle(this.getDefaultStyle())) != null) {
            object2 = style.getValue(name);
        }
        if (object2 == null) {
            object2 = DefaultStyle.current().getValue(name);
        }
        return object2;
    }

    public static int getIndexOffset() {
        return m_IndexOffset;
    }

    @Override
    public CubeTable deepCopy() {
        CubeTable cubeTable = new CubeTable();
        this.copyInto(cubeTable);
        return cubeTable;
    }

    protected void copyInto(CubeTable cubeTable) {
        super.copyInto(cubeTable);
        cubeTable.m_CollapseRows = this.m_CollapseRows;
        cubeTable.m_CollapseColumns = this.m_CollapseColumns;
        cubeTable.m_KeepRowTotals = this.m_KeepRowTotals;
        cubeTable.m_ShowRowHeaderLabels = this.m_ShowRowHeaderLabels;
        cubeTable.m_KeepColumnTotals = this.m_KeepColumnTotals;
        cubeTable.m_ColumnTotalsTitle = this.m_ColumnTotalsTitle;
        cubeTable.m_RowTotalsTitle = this.m_RowTotalsTitle;
        cubeTable.m_ShowColumnHeaders = this.m_ShowColumnHeaders;
        cubeTable.m_ShowRowHeaders = this.m_ShowRowHeaders;
        cubeTable.m_ShowColumnTotalsAfterDetails = this.m_ShowColumnTotalsAfterDetails;
        cubeTable.m_ShowRowTotalsAfterDetails = this.m_ShowRowTotalsAfterDetails;
        cubeTable.m_KeepTogether = this.m_KeepTogether;
        cubeTable.m_Cache = this.m_Cache;
        cubeTable.m_DataRange = this.m_DataRange;
        cubeTable.m_WidthGrowable = this.m_WidthGrowable;
        cubeTable.m_WidthShrinkable = this.m_WidthShrinkable;
        cubeTable.m_GrowHPageCount = this.m_GrowHPageCount;
        cubeTable.m_MergeHeaderBorders = this.m_MergeHeaderBorders;
        cubeTable.m_FontName = this.m_FontName;
        cubeTable.m_FontSize = this.m_FontSize;
        cubeTable.m_FontBold = this.m_FontBold;
        cubeTable.m_FontItalic = this.m_FontItalic;
        cubeTable.m_FontColor = this.m_FontColor;
        cubeTable.m_FontUnderline = this.m_FontUnderline;
        cubeTable.m_FontStrikethrough = this.m_FontStrikethrough;
        if (this.m_Column != null) {
            cubeTable.m_Column = this.m_Column.deepCopy();
            cubeTable.m_Column.setParent(this);
        }
        if (this.m_Row != null) {
            cubeTable.m_Row = this.m_Row.deepCopy();
            cubeTable.m_Row.setParent(this);
        }
        cubeTable.m_Hierarchy = new ArrayList<CubeHierarchy>();
        for (CubeHierarchy iBean : this.m_Hierarchy) {
            cubeTable.addHierarchy(iBean.deepCopy());
        }
        cubeTable.m_Measure = new ArrayList<CubeMeasure>();
        for (CubeMeasure cubeMeasure : this.m_Measure) {
            cubeTable.addMeasure(cubeMeasure.deepCopy());
        }
    }

    static {
        try {
            m_IndexOffset = RawElement.getStaticPropertyCount();
            int n = m_PropertyNameStrings.length;
            m_PropertyNames = new Name[n];
            m_PropertyTypes = new PropertyType[n];
            for (int i = 0; i < n; ++i) {
                CubeTable.m_PropertyNames[i] = BeanUtil.getName(m_PropertyNameStrings[i]);
                CubeTable.m_PropertyTypes[i] = BeanUtil.getType(m_PropertyTypeStrings[i]);
            }
        }
        catch (Throwable throwable) {
            CubeTable.logError("Error in property initialization", throwable);
        }
    }
}

