/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.report2.raw.model;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.jdom.Element;
import com.elixirtech.report2.raw.model.Filter;
import com.elixirtech.report2.raw.model.Parameter;
import com.elixirtech.sax.IBean;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class DataSource
implements IBean {
    private static ElxLoggerJ m_Log = ElxLoggerJ.getLogger(DataSource.class);
    protected boolean m_IsLoaded;
    protected Map<String, Parameter> m_Parameter = new HashMap<String, Parameter>();
    protected List<Filter> m_Filter = new ArrayList<Filter>();
    protected String m_Name;
    protected String m_DataSourceName;
    protected boolean m_Tabulate = true;

    protected static void logError(String string) {
        m_Log.error((Object)string);
    }

    protected static void logError(String string, Throwable throwable) {
        m_Log.error((Object)string, throwable);
    }

    protected static void logInfo(String string) {
        m_Log.info((Object)string);
    }

    public static boolean isHidden(String string) {
        return false;
    }

    public DataSource() {
    }

    @Override
    public String getTagName() {
        return "datasource";
    }

    @Override
    public void loaded() {
        this.m_IsLoaded = true;
        for (IBean iBean : this.m_Parameter.values()) {
            iBean.loaded();
        }
        Iterator<IBean> iterator = this.m_Filter.iterator();
        while (iterator.hasNext()) {
            iterator.next().loaded();
        }
    }

    @Override
    public void dispose() {
        if (this.m_Parameter != null) {
            for (IBean iBean : this.m_Parameter.values()) {
                iBean.dispose();
            }
        }
        this.m_Parameter = null;
        if (this.m_Filter != null) {
            Iterator<IBean> iterator = this.m_Filter.iterator();
            while (iterator.hasNext()) {
                iterator.next().dispose();
            }
        }
        this.m_Filter = null;
    }

    public void copyAttrs(Element element) {
        if (this.m_Name != null) {
            element.setAttribute("name", this.m_Name);
        }
        if (this.m_DataSourceName != null) {
            element.setAttribute("datasource-name", this.m_DataSourceName);
        }
        element.setAttribute("tabulate", this.m_Tabulate ? "Yes" : "No");
    }

    public Object shallowCopy() throws InstantiationException, IllegalAccessException {
        DataSource dataSource = (DataSource)this.getClass().newInstance();
        dataSource.m_Name = this.m_Name;
        dataSource.m_DataSourceName = this.m_DataSourceName;
        dataSource.m_Tabulate = this.m_Tabulate;
        return dataSource;
    }

    public DataSource(String string) {
        this();
        this.setName(string);
    }

    public String toString() {
        return this.m_Name;
    }

    public void addParameter(Parameter parameter) {
        String string = parameter.getKey();
        this.m_Parameter.put(string, parameter);
    }

    public void removeParameter(Parameter parameter) {
        String string = parameter.getKey();
        this.m_Parameter.remove(string);
    }

    public Parameter getParameter(String string) {
        return this.m_Parameter.get(string);
    }

    public Iterator<Parameter> getParameterIterator() {
        return this.m_Parameter.values().iterator();
    }

    public int getParameterCount() {
        return this.m_Parameter.size();
    }

    public Map<String, Parameter> getParameterMap() {
        return this.m_Parameter;
    }

    public void setParameterMap(Map<String, Parameter> map) {
        this.m_Parameter = map;
    }

    public void addFilter(Filter filter) {
        this.m_Filter.add(filter);
    }

    public void addFilter(int n, Filter filter) {
        this.m_Filter.add(n, filter);
    }

    public void addAllFilters(Collection<Filter> collection) {
        this.m_Filter.addAll(collection);
    }

    public int indexOfFilter(Filter filter) {
        return this.m_Filter.indexOf(filter);
    }

    public void removeFilter(Filter filter) {
        this.m_Filter.remove(filter);
    }

    public void removeAllFilters(Collection collection) {
        this.m_Filter.removeAll(collection);
    }

    public void removeAllFilters() {
        this.m_Filter.clear();
    }

    public Filter getFilter(int n) {
        return this.m_Filter.get(n);
    }

    public int getFilterCount() {
        return this.m_Filter.size();
    }

    public Iterator<Filter> getFilterIterator() {
        return this.m_Filter.iterator();
    }

    public List<Filter> getFilterList() {
        return this.m_Filter;
    }

    public void setFilterList(List<Filter> list) {
        this.m_Filter = list;
    }

    public String getName() {
        return this.m_Name;
    }

    public void setName(String string) {
        this.m_Name = string;
        if (this.m_Name != null) {
            this.m_Name = this.m_Name.trim();
        }
    }

    public String getDataSourceName() {
        return this.m_DataSourceName;
    }

    public void setDataSourceName(String string) {
        this.m_DataSourceName = string;
        if (this.m_DataSourceName != null) {
            this.m_DataSourceName = this.m_DataSourceName.trim();
        }
    }

    public boolean isTabulate() {
        return this.m_Tabulate;
    }

    public void setTabulate(boolean bl) {
        this.m_Tabulate = bl;
    }

    public DataSource deepCopy() {
        DataSource dataSource = new DataSource();
        this.copyInto(dataSource);
        return dataSource;
    }

    protected void copyInto(DataSource dataSource) {
        dataSource.m_Name = this.m_Name;
        dataSource.m_DataSourceName = this.m_DataSourceName;
        dataSource.m_Tabulate = this.m_Tabulate;
        dataSource.m_Parameter = new HashMap<String, Parameter>();
        for (Map.Entry<String, Parameter> object : this.m_Parameter.entrySet()) {
            dataSource.addParameter(object.getValue().deepCopy());
        }
        dataSource.m_Filter = new ArrayList<Filter>();
        for (Filter filter : this.m_Filter) {
            dataSource.addFilter(filter.deepCopy());
        }
    }
}

