/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.report2.raw.model;

import com.elixirtech.report2.raw.model.BarcodeBasicSAXOut;
import com.elixirtech.report2.raw.model.QRCode;
import com.elixirtech.sax.IBean;
import com.elixirtech.sax.ISAXOut;
import org.xml.sax.helpers.AttributesImpl;

public class QRCodeSAXOut
extends BarcodeBasicSAXOut {
    @Override
    public String getTagName() {
        return "type-barcode-qrcode";
    }

    @Override
    public void output(ISAXOut iSAXOut, IBean iBean) {
        QRCode qRCode = (QRCode)iBean;
        AttributesImpl attributesImpl = new AttributesImpl();
        this.buildAttributes(qRCode, attributesImpl);
        iSAXOut.startElement(iBean.getTagName(), attributesImpl);
        this.outputChild(iSAXOut, qRCode);
        this.outputChildren(iSAXOut, qRCode);
        iSAXOut.endElement(iBean.getTagName());
    }

    @Override
    public void output(ISAXOut iSAXOut, IBean iBean, String string) {
        QRCode qRCode = (QRCode)iBean;
        AttributesImpl attributesImpl = new AttributesImpl();
        this.buildAttributes(qRCode, attributesImpl);
        iSAXOut.startElement(string, attributesImpl);
        this.outputChild(iSAXOut, qRCode);
        this.outputChildren(iSAXOut, qRCode);
        iSAXOut.endElement(string);
    }

    public void buildAttributes(QRCode qRCode, AttributesImpl attributesImpl) {
        Object object;
        String string = qRCode.getErrorCorrectionLevel();
        if (string != null) {
            object = "error-correction-level";
            attributesImpl.addAttribute("", (String)object, (String)object, "CDATA", string);
        }
        if ((string = qRCode.getCharacterSet()) != null) {
            object = "character-set";
            attributesImpl.addAttribute("", (String)object, (String)object, "CDATA", string);
        }
        string = "width";
        object = qRCode.getWidth();
        if (object != null) {
            attributesImpl.addAttribute("", string, string, "CDATA", ((Integer)object).toString());
        }
        super.buildAttributes(qRCode, attributesImpl);
    }

    public void outputChild(ISAXOut iSAXOut, QRCode qRCode) {
        super.outputChild(iSAXOut, qRCode);
    }

    public void outputChildren(ISAXOut iSAXOut, QRCode qRCode) {
        super.outputChildren(iSAXOut, qRCode);
    }
}

