/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.report2.raw.model;

import com.elixirtech.i18n.Name;
import com.elixirtech.jdom.Element;
import com.elixirtech.property.DefaultStyle;
import com.elixirtech.property.Property;
import com.elixirtech.property.PropertyImplementor;
import com.elixirtech.property.PropertyType;
import com.elixirtech.report2.raw.StyleManager;
import com.elixirtech.report2.raw.model.Chunk;
import com.elixirtech.report2.raw.model.IRawElementHolder;
import com.elixirtech.report2.raw.model.IRenderScriptHolder;
import com.elixirtech.report2.raw.model.IResourceProvider;
import com.elixirtech.report2.raw.model.IStyledElement;
import com.elixirtech.report2.raw.model.Script;
import com.elixirtech.report2.raw.model.Section;
import com.elixirtech.report2.raw.model.Shape;
import com.elixirtech.report2.raw.model.Style;
import com.elixirtech.report2.raw.model.StyledElement;
import com.elixirtech.sax.BeanUtil;
import com.elixirtech.sax.IBean;
import java.awt.Rectangle;
import java.util.Arrays;
import java.util.Set;

public abstract class RawModelElement
extends StyledElement
implements IBean,
PropertyImplementor,
IRenderScriptHolder {
    private IRawElementHolder m_Parent;
    private Shape m_Shape;
    protected Script m_RenderIf;
    protected Script m_OnRenderBegin;
    protected Script m_OnRenderEnd;
    protected Boolean m_LockHandles;
    private static String[] m_PropertyNameStrings = new String[]{"RawModelElement.LockHandles".intern(), "RawModelElement.RenderIf".intern(), "RawModelElement.OnRenderBegin".intern(), "RawModelElement.OnRenderEnd".intern()};
    private static String[] m_PropertyTypeStrings = new String[]{"Boolean", "Script", "Script", "Script"};
    private static int m_IndexOffset;
    private static Name[] m_PropertyNames;
    private static PropertyType[] m_PropertyTypes;

    public static boolean isHidden(String string) {
        return false;
    }

    @Override
    public String getTagName() {
        return "model-element";
    }

    public IRawElementHolder getParent() {
        return this.m_Parent;
    }

    public void setParent(IRawElementHolder iRawElementHolder) {
        this.m_Parent = iRawElementHolder;
    }

    @Override
    public void loaded() {
        super.loaded();
        if (this.m_RenderIf != null) {
            this.m_RenderIf.loaded();
        }
        if (this.m_OnRenderBegin != null) {
            this.m_OnRenderBegin.loaded();
        }
        if (this.m_OnRenderEnd != null) {
            this.m_OnRenderEnd.loaded();
        }
    }

    @Override
    public void dispose() {
        if (this.m_RenderIf != null) {
            if (this.m_RenderIf != null) {
                this.m_RenderIf.dispose();
            }
            this.m_RenderIf = null;
        }
        if (this.m_OnRenderBegin != null) {
            if (this.m_OnRenderBegin != null) {
                this.m_OnRenderBegin.dispose();
            }
            this.m_OnRenderBegin = null;
        }
        if (this.m_OnRenderEnd != null) {
            if (this.m_OnRenderEnd != null) {
                this.m_OnRenderEnd.dispose();
            }
            this.m_OnRenderEnd = null;
        }
    }

    @Override
    public void copyAttrs(Element element) {
        if (this.m_LockHandles != null) {
            element.setAttribute("lock-handles", this.m_LockHandles != false ? "Yes" : "No");
        }
        super.copyAttrs(element);
    }

    @Override
    public Object shallowCopy() throws InstantiationException, IllegalAccessException {
        RawModelElement rawModelElement = (RawModelElement)super.shallowCopy();
        return rawModelElement;
    }

    public boolean isFill() {
        return false;
    }

    public int getLeft() {
        return 0;
    }

    public int getTop() {
        return 0;
    }

    public int getWidth() {
        return 0;
    }

    public int getHeight() {
        return 0;
    }

    public void setLeft(int n) {
    }

    public void setTop(int n) {
    }

    public void setWidth(int n) {
    }

    public void setHeight(int n) {
    }

    public boolean isGrowable() {
        return false;
    }

    public boolean isShrinkable() {
        return false;
    }

    @Override
    public IResourceProvider getResourceProvider() {
        Section section;
        Chunk chunk = this.getChunk();
        if (chunk != null && (section = chunk.getSection()) != null) {
            return section.getRawReport();
        }
        return null;
    }

    @Override
    public IStyledElement getParentStyledElement() {
        return this.m_Parent;
    }

    public Chunk getChunk() {
        RawModelElement rawModelElement;
        for (rawModelElement = this; rawModelElement != null && !(rawModelElement instanceof Chunk); rawModelElement = (RawModelElement)((Object)rawModelElement.getParent())) {
        }
        return (Chunk)rawModelElement;
    }

    public Shape getShape() {
        return this.m_Shape;
    }

    public void setShape(Shape shape) {
        this.m_Shape = shape;
    }

    protected void doFill() {
        IRawElementHolder iRawElementHolder;
        if (this.m_Shape != null && (iRawElementHolder = this.getParent()) != null) {
            Rectangle rectangle = iRawElementHolder.getShape().getChildRect();
            this.m_Shape.setRect(rectangle);
        }
    }

    public Chunk.MyTreeModel getTreeModel() {
        if (this.m_Parent != null) {
            return this.m_Parent.getTreeModel();
        }
        return null;
    }

    @Override
    public void cacheProperties() {
        int n = this.getPropertyCount();
        for (int i = 0; i < n; ++i) {
            Object object = this.getLocalPropertyValue(i);
            if (object != null) continue;
            object = this.getDefaultPropertyValue(i);
            this.setPropertyValue(i, object);
        }
    }

    @Override
    public Script getRenderIf() {
        if (this.m_RenderIf != null) {
            return this.m_RenderIf;
        }
        return (Script)this.getDefaultPropertyValue(m_IndexOffset + 2 - 1);
    }

    @Override
    public void setRenderIf(Script script) {
        this.m_RenderIf = script;
        if (this.m_RenderIf != null) {
            this.m_RenderIf.setTagName("render-if");
        }
    }

    @Override
    public Script getOnRenderBegin() {
        if (this.m_OnRenderBegin != null) {
            return this.m_OnRenderBegin;
        }
        return (Script)this.getDefaultPropertyValue(m_IndexOffset + 3 - 1);
    }

    @Override
    public void setOnRenderBegin(Script script) {
        this.m_OnRenderBegin = script;
        if (this.m_OnRenderBegin != null) {
            this.m_OnRenderBegin.setTagName("on-render-begin");
        }
    }

    @Override
    public Script getOnRenderEnd() {
        if (this.m_OnRenderEnd != null) {
            return this.m_OnRenderEnd;
        }
        return (Script)this.getDefaultPropertyValue(m_IndexOffset + 4 - 1);
    }

    @Override
    public void setOnRenderEnd(Script script) {
        this.m_OnRenderEnd = script;
        if (this.m_OnRenderEnd != null) {
            this.m_OnRenderEnd.setTagName("on-render-end");
        }
    }

    public boolean isLockHandles() {
        Boolean bl = this.m_LockHandles;
        if (bl == null) {
            bl = (Boolean)this.getDefaultPropertyValue(m_IndexOffset + 1 - 1);
        }
        return bl;
    }

    public void setLockHandles(boolean bl) {
        this.m_LockHandles = bl;
    }

    public void setLockHandles(Boolean bl) {
        this.m_LockHandles = bl;
    }

    @Override
    public void getPropertyNames(Set<Name> set) {
        set.addAll(Arrays.asList(m_PropertyNames));
        super.getPropertyNames(set);
    }

    @Override
    public int getPropertyCount() {
        return m_IndexOffset + m_PropertyNameStrings.length;
    }

    public static int getStaticPropertyCount() {
        return m_IndexOffset + m_PropertyNameStrings.length;
    }

    @Override
    public int getPropertyIndex(String string) {
        int n = BeanUtil.indexOf(string, m_PropertyNameStrings);
        if (n < 0) {
            return super.getPropertyIndex(string);
        }
        return n += m_IndexOffset;
    }

    @Override
    public Property getProperty(Name name) {
        int n = BeanUtil.indexOf(name.getName(), m_PropertyNameStrings);
        if (n < 0) {
            return super.getProperty(name);
        }
        return new Property(this, n += m_IndexOffset);
    }

    @Override
    public Name getPropertyName(int n) {
        if (n < m_IndexOffset) {
            return super.getPropertyName(n);
        }
        return m_PropertyNames[n - m_IndexOffset];
    }

    @Override
    public PropertyType getPropertyType(int n) {
        if (n < m_IndexOffset) {
            return super.getPropertyType(n);
        }
        return m_PropertyTypes[n - m_IndexOffset];
    }

    @Override
    public void setPropertyValue(int n, Object object) {
        if (n < m_IndexOffset) {
            super.setPropertyValue(n, object);
        } else {
            try {
                switch (n -= m_IndexOffset) {
                    case 0: {
                        this.m_LockHandles = (Boolean)object;
                        break;
                    }
                    case 1: {
                        this.m_RenderIf = (Script)object;
                        if (this.m_RenderIf != null) {
                            this.m_RenderIf.setTagName("render-if");
                        }
                        break;
                    }
                    case 2: {
                        this.m_OnRenderBegin = (Script)object;
                        if (this.m_OnRenderBegin != null) {
                            this.m_OnRenderBegin.setTagName("on-render-begin");
                        }
                        break;
                    }
                    case 3: {
                        this.m_OnRenderEnd = (Script)object;
                        if (this.m_OnRenderEnd != null) {
                            this.m_OnRenderEnd.setTagName("on-render-end");
                        }
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("No such property index: " + n + " in " + this.getClass());
                    }
                }
            }
            catch (Exception exception) {
                throw new IllegalArgumentException("Error setting " + n + " with " + object + "(" + object.getClass() + ") : " + exception);
            }
        }
    }

    @Override
    public Object getPropertyValue(Name name) {
        String string = name.getName();
        int n = BeanUtil.indexOf(string, m_PropertyNameStrings);
        if (n < 0) {
            return super.getPropertyValue(name);
        }
        return this.getPropertyValue(m_IndexOffset + n);
    }

    @Override
    public boolean isLocalPropertyValue(int n) {
        return this.getLocalPropertyValue(n) != null;
    }

    @Override
    protected Object getLocalPropertyValue(int n) {
        if (n < m_IndexOffset) {
            return super.getLocalPropertyValue(n);
        }
        switch (n - m_IndexOffset) {
            case 0: {
                return this.m_LockHandles;
            }
            case 1: {
                return this.m_RenderIf;
            }
            case 2: {
                return this.m_OnRenderBegin;
            }
            case 3: {
                return this.m_OnRenderEnd;
            }
        }
        throw new IllegalArgumentException("No such property index " + n + " in " + this.getClass());
    }

    @Override
    protected Object getDefaultPropertyValue(int n) {
        Style style;
        Object object;
        if (n < m_IndexOffset) {
            return super.getDefaultPropertyValue(n);
        }
        Object object2 = null;
        Name name = m_PropertyNames[n - m_IndexOffset];
        if (this.m_Style != null) {
            object2 = this.m_Style.getValue(name);
        }
        if (object2 == null && StyleManager.isInherited(name) && (object = this.getParentStyledElement()) != null) {
            object2 = object.getPropertyValue(name);
        }
        if (object2 == null && (object = this.getResourceProvider()) != null && (style = object.getStyle(this.getDefaultStyle())) != null) {
            object2 = style.getValue(name);
        }
        if (object2 == null) {
            object2 = DefaultStyle.current().getValue(name);
        }
        return object2;
    }

    public static int getIndexOffset() {
        return m_IndexOffset;
    }

    @Override
    public abstract RawModelElement deepCopy();

    protected void copyInto(RawModelElement rawModelElement) {
        super.copyInto(rawModelElement);
        rawModelElement.m_LockHandles = this.m_LockHandles;
        if (this.m_RenderIf != null) {
            rawModelElement.m_RenderIf = this.m_RenderIf.deepCopy();
        }
        if (this.m_OnRenderBegin != null) {
            rawModelElement.m_OnRenderBegin = this.m_OnRenderBegin.deepCopy();
        }
        if (this.m_OnRenderEnd != null) {
            rawModelElement.m_OnRenderEnd = this.m_OnRenderEnd.deepCopy();
        }
    }

    static {
        try {
            m_IndexOffset = StyledElement.getStaticPropertyCount();
            int n = m_PropertyNameStrings.length;
            m_PropertyNames = new Name[n];
            m_PropertyTypes = new PropertyType[n];
            for (int i = 0; i < n; ++i) {
                RawModelElement.m_PropertyNames[i] = BeanUtil.getName(m_PropertyNameStrings[i]);
                RawModelElement.m_PropertyTypes[i] = BeanUtil.getType(m_PropertyTypeStrings[i]);
            }
        }
        catch (Throwable throwable) {
            RawModelElement.logError("Error in property initialization", throwable);
        }
    }
}

