/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.report2.raw.model;

import com.elixirtech.report2.raw.model.RawReport;
import com.elixirtech.report2.raw.model.StyledElementSAXOut;
import com.elixirtech.sax.IBean;
import com.elixirtech.sax.ISAXOut;
import java.util.Locale;
import org.xml.sax.helpers.AttributesImpl;

public class RawReportSAXOut
extends StyledElementSAXOut {
    @Override
    public String getTagName() {
        return "report";
    }

    @Override
    public void output(ISAXOut iSAXOut, IBean iBean) {
        RawReport rawReport = (RawReport)iBean;
        AttributesImpl attributesImpl = new AttributesImpl();
        this.buildAttributes(rawReport, attributesImpl);
        iSAXOut.startElement(iBean.getTagName(), attributesImpl);
        this.outputChild(iSAXOut, rawReport);
        this.outputChildren(iSAXOut, rawReport);
        iSAXOut.endElement(iBean.getTagName());
    }

    @Override
    public void output(ISAXOut iSAXOut, IBean iBean, String string) {
        RawReport rawReport = (RawReport)iBean;
        AttributesImpl attributesImpl = new AttributesImpl();
        this.buildAttributes(rawReport, attributesImpl);
        iSAXOut.startElement(string, attributesImpl);
        this.outputChild(iSAXOut, rawReport);
        this.outputChildren(iSAXOut, rawReport);
        iSAXOut.endElement(string);
    }

    public void buildAttributes(RawReport rawReport, AttributesImpl attributesImpl) {
        String string = "locale";
        Object object = rawReport.getLocale();
        if (object != null) {
            attributesImpl.addAttribute("", string, string, "CDATA", ((Locale)object).toString());
        }
        string = "keep-page-count";
        attributesImpl.addAttribute("", string, string, "CDATA", rawReport.isKeepPageCount() ? "Yes" : "No");
        string = "cache-all-properties";
        attributesImpl.addAttribute("", string, string, "CDATA", rawReport.isCacheAllProperties() ? "Yes" : "No");
        string = rawReport.getRepositoryBase();
        if (string != null) {
            object = "repository-base";
            attributesImpl.addAttribute("", (String)object, (String)object, "CDATA", string);
        }
        string = "grid-enabled";
        attributesImpl.addAttribute("", string, string, "CDATA", rawReport.isGridEnabled() ? "Yes" : "No");
        string = "grid-visible";
        attributesImpl.addAttribute("", string, string, "CDATA", rawReport.isGridVisible() ? "Yes" : "No");
        string = "grid-x";
        attributesImpl.addAttribute("", string, string, "CDATA", Integer.toString(rawReport.getGridX()));
        string = "grid-y";
        attributesImpl.addAttribute("", string, string, "CDATA", Integer.toString(rawReport.getGridY()));
        string = rawReport.getDescription();
        if (string != null) {
            object = "description";
            attributesImpl.addAttribute("", (String)object, (String)object, "CDATA", string);
        }
        string = "disable-csv-auto-wrap";
        attributesImpl.addAttribute("", string, string, "CDATA", rawReport.isDisableCSVAutoWrap() ? "Yes" : "No");
        string = "disable-excel-auto-wrap";
        attributesImpl.addAttribute("", string, string, "CDATA", rawReport.isDisableExcelAutoWrap() ? "Yes" : "No");
        super.buildAttributes(rawReport, attributesImpl);
    }

    public void outputChild(ISAXOut iSAXOut, RawReport rawReport) {
        super.outputChild(iSAXOut, rawReport);
        iSAXOut.output(rawReport.getMetadata(), "metadata");
        iSAXOut.output(rawReport.getSecurity(), "security");
        int n = RawReport.getIndexOffset();
        IBean iBean = (IBean)rawReport.getLocalPropertyValue(n + 1 - 1);
        if (iBean != null) {
            iSAXOut.output(iBean, "function-definitions");
        }
        if ((iBean = (IBean)rawReport.getLocalPropertyValue((n = RawReport.getIndexOffset()) + 2 - 1)) != null) {
            iSAXOut.output(iBean, "on-render-begin");
        }
        if ((iBean = (IBean)rawReport.getLocalPropertyValue((n = RawReport.getIndexOffset()) + 3 - 1)) != null) {
            iSAXOut.output(iBean, "on-render-end");
        }
    }

    public void outputChildren(ISAXOut iSAXOut, RawReport rawReport) {
        super.outputChildren(iSAXOut, rawReport);
        iSAXOut.startElement("layout-master-set", new AttributesImpl());
        iSAXOut.output(rawReport.getPageSetupIterator());
        iSAXOut.endElement("layout-master-set");
        iSAXOut.startElement("parameters", new AttributesImpl());
        iSAXOut.output(rawReport.getParameterIterator());
        iSAXOut.endElement("parameters");
        iSAXOut.startElement("datasources", new AttributesImpl());
        iSAXOut.output(rawReport.getDataSourceIterator());
        iSAXOut.endElement("datasources");
        iSAXOut.startElement("styles", new AttributesImpl());
        iSAXOut.output(rawReport.getStyleIterator());
        iSAXOut.endElement("styles");
        iSAXOut.startElement("stylesheets", new AttributesImpl());
        iSAXOut.output(rawReport.getStylesheetIterator());
        iSAXOut.endElement("stylesheets");
        iSAXOut.startElement("sections", new AttributesImpl());
        iSAXOut.output(rawReport.getSectionIterator());
        iSAXOut.endElement("sections");
        iSAXOut.startElement("sequence", new AttributesImpl());
        iSAXOut.output(rawReport.getSequenceStepIterator());
        iSAXOut.endElement("sequence");
        iSAXOut.startElement("rendering", new AttributesImpl());
        iSAXOut.output(rawReport.getRenderDetailsIterator());
        iSAXOut.endElement("rendering");
    }
}

