/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.report2.raw.model;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.arch.IAdaptable;
import com.elixirtech.jdom.Element;
import com.elixirtech.report2.raw.IStyleManager;
import com.elixirtech.report2.raw.StylesheetManager;
import com.elixirtech.report2.raw.model.IResourceProvider;
import com.elixirtech.report2.raw.model.Style;
import com.elixirtech.repository.RMLFileObject;
import com.elixirtech.sax.ChangeListener;
import com.elixirtech.sax.ChangeNotifier;
import com.elixirtech.sax.IBean;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class Stylesheet
implements IBean,
ChangeNotifier,
IAdaptable {
    private static ElxLoggerJ m_Log = ElxLoggerJ.getLogger(Stylesheet.class);
    protected boolean m_IsLoaded;
    protected Map<String, Style> m_Style = new HashMap<String, Style>();
    protected transient RMLFileObject m_FileObject;
    protected transient IResourceProvider m_ResourceProvider;
    private Set<ChangeListener> m_ChangeListeners;

    protected static void logError(String string) {
        m_Log.error((Object)string);
    }

    protected static void logError(String string, Throwable throwable) {
        m_Log.error((Object)string, throwable);
    }

    protected static void logInfo(String string) {
        m_Log.info((Object)string);
    }

    public static boolean isHidden(String string) {
        return false;
    }

    @Override
    public String getTagName() {
        return "stylesheet";
    }

    @Override
    public void loaded() {
        this.m_IsLoaded = true;
        for (IBean iBean : this.m_Style.values()) {
            iBean.loaded();
        }
    }

    @Override
    public void dispose() {
        if (this.m_Style != null) {
            for (IBean iBean : this.m_Style.values()) {
                iBean.dispose();
            }
        }
        this.m_Style = null;
    }

    public void copyAttrs(Element element) {
    }

    public Object shallowCopy() throws InstantiationException, IllegalAccessException {
        Stylesheet stylesheet = (Stylesheet)this.getClass().newInstance();
        stylesheet.m_FileObject = this.m_FileObject;
        stylesheet.m_ResourceProvider = this.m_ResourceProvider;
        return stylesheet;
    }

    @Override
    public <T> T getAdapter(Class<T> clazz) {
        if (clazz == IResourceProvider.class) {
            return clazz.cast(this.m_ResourceProvider);
        }
        if (clazz == IStyleManager.class) {
            return clazz.cast(new StylesheetManager(this));
        }
        if (clazz == IAdaptable.class) {
            return clazz.cast(this);
        }
        return null;
    }

    public void addStyle(Style style) {
        String string = style.getName();
        this.m_Style.put(string, style);
        style.setParent(this);
        this.notifyChanged("Stylesheet.Style");
    }

    public void removeStyle(Style style) {
        String string = style.getName();
        this.m_Style.remove(string);
        style.setParent(null);
        this.notifyChanged("Stylesheet.Style");
    }

    public Style getStyle(String string) {
        return this.m_Style.get(string);
    }

    public Iterator<Style> getStyleIterator() {
        return this.m_Style.values().iterator();
    }

    public int getStyleCount() {
        return this.m_Style.size();
    }

    public Map<String, Style> getStyleMap() {
        return this.m_Style;
    }

    public void setStyleMap(Map<String, Style> map) {
        this.m_Style = map;
        this.notifyChanged("Stylesheet.Style");
    }

    public RMLFileObject getFileObject() {
        return this.m_FileObject;
    }

    public void setFileObject(RMLFileObject rMLFileObject) {
        this.m_FileObject = rMLFileObject;
    }

    public IResourceProvider getResourceProvider() {
        return this.m_ResourceProvider;
    }

    public void setResourceProvider(IResourceProvider iResourceProvider) {
        this.m_ResourceProvider = iResourceProvider;
    }

    @Override
    public void addChangeListener(ChangeListener changeListener) {
        if (this.m_ChangeListeners == null) {
            this.m_ChangeListeners = new HashSet<ChangeListener>();
        }
        this.m_ChangeListeners.add(changeListener);
    }

    @Override
    public void removeChangeListener(ChangeListener changeListener) {
        this.m_ChangeListeners.remove(changeListener);
        if (this.m_ChangeListeners.size() == 0) {
            this.m_ChangeListeners = null;
        }
    }

    public void notifyChanged(String string) {
        if (this.m_ChangeListeners != null) {
            for (ChangeListener changeListener : this.m_ChangeListeners) {
                changeListener.beanChanged(this, string);
            }
        }
    }

    public Stylesheet deepCopy() {
        Stylesheet stylesheet = new Stylesheet();
        this.copyInto(stylesheet);
        return stylesheet;
    }

    protected void copyInto(Stylesheet stylesheet) {
        stylesheet.m_FileObject = this.m_FileObject;
        stylesheet.m_ResourceProvider = this.m_ResourceProvider;
        stylesheet.m_Style = new HashMap<String, Style>();
        for (Map.Entry<String, Style> entry : this.m_Style.entrySet()) {
            stylesheet.addStyle(entry.getValue().deepCopy());
        }
    }
}

