/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.report2.raw.property;

import com.elixirtech.arch.StringUtil;
import com.elixirtech.property.PropertyType;
import com.elixirtech.report2.raw.model.ControlSource;
import com.elixirtech.report2.raw.model.Format;
import com.elixirtech.report2.raw.model.Script;
import com.elixirtech.sax.BeanUtil;
import java.util.Locale;

public final class PropertyTypes {
    public static final int TYPE_CONTROL_SOURCE = 200;
    public static final int TYPE_LOCALE = 201;
    public static final int TYPE_SCRIPT = 202;
    public static final int TYPE_FILE_PATH = 203;
    public static final int TYPE_WIZARD = 204;
    public static final int TYPE_FORMAT = 205;
    public static final int TYPE_STRING_SYNTAX = 206;
    public static final PropertyType CONTROL_SOURCE = new ControlSourcePropertyType();
    public static final PropertyType LOCALE = new LocalePropertyType();
    public static final PropertyType SCRIPT = new ScriptPropertyType();
    public static final PropertyType FILE_PATH = new FilePathPropertyType();
    public static final PropertyType WIZARD = new WizardPropertyType();
    public static final PropertyType FORMAT = new FormatPropertyType();
    public static final PropertyType STRING_SYNTAX = new StringSyntaxPropertyType();

    private static void register(String string, PropertyType propertyType) {
        BeanUtil.registerType(string, propertyType);
    }

    static {
        PropertyTypes.register("ControlSource", CONTROL_SOURCE);
        PropertyTypes.register("Locale", LOCALE);
        PropertyTypes.register("Script", SCRIPT);
        PropertyTypes.register("FilePath", FILE_PATH);
        PropertyTypes.register("Wizard", WIZARD);
        PropertyTypes.register("Format", FORMAT);
        PropertyTypes.register("StringSyntax", STRING_SYNTAX);
    }

    private static class ControlSourcePropertyType
    extends PropertyType {
        public ControlSourcePropertyType() {
            super(200, "ControlSource");
        }

        @Override
        public String toString(Object object) {
            return ((ControlSource)object).getText();
        }

        @Override
        public Object toType(String string) {
            return new ControlSource(string);
        }
    }

    private static class LocalePropertyType
    extends PropertyType {
        public LocalePropertyType() {
            super(201, "Locale");
        }

        @Override
        public String toString(Object object) {
            if (object == null) {
                return "";
            }
            return ((Locale)object).toString();
        }

        @Override
        public Object toType(String string) {
            if (string == null || string.trim().length() == 0) {
                return Locale.getDefault();
            }
            String[] stringArray = StringUtil.arrayOfSubstrings(string, '_');
            if (stringArray.length == 1) {
                return new Locale(stringArray[0]);
            }
            if (stringArray.length == 2) {
                return new Locale(stringArray[0], stringArray[1]);
            }
            return new Locale(stringArray[0], stringArray[1], stringArray[2]);
        }
    }

    private static class ScriptPropertyType
    extends PropertyType {
        public ScriptPropertyType() {
            super(202, "Script");
        }

        @Override
        public String toString(Object object) {
            if (object == null) {
                return "";
            }
            return ((Script)object).getText();
        }

        @Override
        public Object toType(String string) {
            return new Script("javascript", string);
        }
    }

    private static class FilePathPropertyType
    extends PropertyType {
        public FilePathPropertyType() {
            super(203, "FilePath");
        }

        @Override
        public String toString(Object object) {
            return (String)object;
        }

        @Override
        public Object toType(String string) {
            return string;
        }
    }

    private static class WizardPropertyType
    extends PropertyType {
        public WizardPropertyType() {
            super(204, "Wizard");
        }

        @Override
        public String toString(Object object) {
            return (String)object;
        }

        @Override
        public Object toType(String string) {
            return string;
        }
    }

    private static class FormatPropertyType
    extends PropertyType {
        public FormatPropertyType() {
            super(205, "Format");
        }

        @Override
        public String toString(Object object) {
            Format format = (Format)object;
            return format.getType();
        }

        @Override
        public Object toType(String string) {
            return string;
        }
    }

    private static class StringSyntaxPropertyType
    extends PropertyType {
        public StringSyntaxPropertyType() {
            super(206, "StringSyntax");
        }

        @Override
        public String toString(Object object) {
            Format format = (Format)object;
            return format.getType();
        }

        @Override
        public Object toType(String string) {
            return string;
        }
    }
}

