/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.report2.script;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.js.CompiledScript;
import com.elixirtech.js.JavaScriptEngine;
import com.elixirtech.js.ScriptException;
import org.mozilla.javascript.Scriptable;

public class JSEngine {
    private JavaScriptEngine m_JavaScriptEngine = JavaScriptEngine.getInstance();
    private boolean m_Debug;
    private static final ElxLoggerJ m_Log = ElxLoggerJ.getLogger(JSEngine.class);
    private static final ElxLoggerJ m_JSLog = ElxLoggerJ.getLogger((String)"JavaScript");

    public boolean isDebug() {
        return this.m_Debug;
    }

    public JavaScriptEngine getEngine() {
        return this.m_JavaScriptEngine;
    }

    public void declareBean(String string, Object object) {
        this.m_JavaScriptEngine.declareBean(string, object);
    }

    public void declareBean(String string, Object object, Class<?> clazz) {
        this.m_JavaScriptEngine.declareBean(string, object, clazz);
    }

    public void undeclareBean(String string) {
        this.m_JavaScriptEngine.undeclareBean(string);
    }

    public CompiledScript compile(String string, String string2) {
        return this.m_JavaScriptEngine.compile(string, string2);
    }

    public Object evaluate(CompiledScript compiledScript) {
        try {
            Object object = compiledScript.eval(this.m_JavaScriptEngine.getScope());
            return object;
        }
        catch (ScriptException scriptException) {
            m_JSLog.error((Object)("JavaScript eval: " + scriptException));
            if (this.m_Debug) {
                scriptException.printStackTrace();
            }
            return null;
        }
    }

    public Object evaluate(String string, String string2) {
        try {
            Object object = this.m_JavaScriptEngine.evaluate(string, string2);
            return object;
        }
        catch (ScriptException scriptException) {
            m_JSLog.error((Object)("JavaScript eval: " + scriptException));
            if (this.m_Debug) {
                scriptException.printStackTrace();
            }
            return null;
        }
    }

    public void pushScope(Object object) {
        if (object instanceof Scriptable) {
            this.m_JavaScriptEngine.pushScope((Scriptable)object);
        } else {
            this.m_JavaScriptEngine.pushScope(this.m_JavaScriptEngine.toScriptable(object));
        }
    }

    public void pushScope() {
        this.m_JavaScriptEngine.pushScope();
    }

    public void popScope() {
        this.m_JavaScriptEngine.popScope();
    }

    public Scriptable getScope() {
        return this.m_JavaScriptEngine.getScope();
    }

    public void dumpScope() {
        Scriptable scriptable;
        m_Log.debug((Object)("dumpScope " + scriptable));
        for (scriptable = this.m_JavaScriptEngine.getScope(); scriptable != null; scriptable = scriptable.getParentScope()) {
            m_Log.debug((Object)("dumpScope parent=" + scriptable));
        }
    }
}

