/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.report2.util;

import com.elixirtech.jdom.Element;
import org.xml.sax.Attributes;

public class PageSetup {
    public static final int PORTRAIT = 1;
    public static final int LANDSCAPE = 2;
    public static final int DOWN_ACROSS = 3;
    public static final int ACROSS_DOWN = 4;
    public int top;
    public int left;
    public int bottom;
    public int right;
    public int orientation;
    public int width;
    public int height;
    public int noColumns;
    public int columnSpacing;
    public int rowSpacing;
    public int columnLayout;
    public String size;
    public boolean paintMargin;

    public PageSetup(Attributes attributes) {
        this.top = (int)Double.parseDouble(attributes.getValue("Top"));
        this.left = (int)Double.parseDouble(attributes.getValue("Left"));
        this.bottom = (int)Double.parseDouble(attributes.getValue("Bottom"));
        this.right = (int)Double.parseDouble(attributes.getValue("Right"));
        this.width = (int)Double.parseDouble(attributes.getValue("Width"));
        this.height = (int)Double.parseDouble(attributes.getValue("Height"));
        this.orientation = attributes.getValue("Orientation").equals("Portrait") ? 1 : 2;
        this.noColumns = Integer.parseInt(attributes.getValue("Number_of_Columns"));
        this.columnSpacing = (int)Double.parseDouble(attributes.getValue("Column_Spacing"));
        this.columnSpacing = (int)Double.parseDouble(attributes.getValue("Row_Spacing"));
        this.columnLayout = attributes.getValue("Column_Layout").equals("Down, then Across") ? 3 : 4;
        this.size = attributes.getValue("Size");
        this.paintMargin = "Yes".equals(attributes.getValue("Paint_Margin"));
    }

    public PageSetup(Element element) {
        this.top = (int)Double.parseDouble(element.getAttributeValue("Top"));
        this.left = (int)Double.parseDouble(element.getAttributeValue("Left"));
        this.bottom = (int)Double.parseDouble(element.getAttributeValue("Bottom"));
        this.right = (int)Double.parseDouble(element.getAttributeValue("Right"));
        this.width = (int)Double.parseDouble(element.getAttributeValue("Width"));
        this.height = (int)Double.parseDouble(element.getAttributeValue("Height"));
        this.orientation = element.getAttributeValue("Orientation").equals("Portrait") ? 1 : 2;
        this.noColumns = Integer.parseInt(element.getAttributeValue("Number_of_Columns"));
        this.columnSpacing = (int)Double.parseDouble(element.getAttributeValue("Column_Spacing"));
        this.rowSpacing = (int)Double.parseDouble(element.getAttributeValue("Row_Spacing"));
        this.columnLayout = element.getAttributeValue("Column_Layout").equals("Down, then Across") ? 3 : 4;
        this.size = element.getAttributeValue("Size");
        this.paintMargin = "Yes".equals(element.getAttributeValue("Paint_Margin"));
    }

    public int getUsableHeight() {
        return this.height - this.top - this.bottom;
    }

    public int getUsableWidth() {
        return this.width - this.left - this.right;
    }

    public boolean isPaintMargin() {
        return this.paintMargin;
    }
}

