/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.rtf;

import com.elixirtech.rtf.RTFChunk;
import com.elixirtech.rtf.RTFConstants;
import com.elixirtech.rtf.RTFWriter;
import java.awt.Color;
import java.io.IOException;

public class RTFLine
extends RTFChunk
implements RTFConstants {
    private String m_LineStyle;
    private int m_LineWidth;
    private Color m_LineColor;
    private int m_X1;
    private int m_Y1;
    private int m_X2;
    private int m_Y2;

    public void setLineStyle(String string) {
        this.m_LineStyle = string;
    }

    public void setLineColor(Color color) {
        this.m_LineColor = color;
    }

    public void setLineWidth(int n) {
        this.m_LineWidth = n;
    }

    public void setEnds(int n, int n2, int n3, int n4) {
        this.m_X1 = n;
        this.m_Y1 = n2;
        this.m_X2 = n3;
        this.m_Y2 = n4;
    }

    @Override
    public void write(RTFWriter rTFWriter) throws IOException {
        if (this.m_LineColor != null) {
            String string = null;
            if ("Solid".equals(this.m_LineStyle)) {
                string = "dplinesolid";
            } else if ("Dashes".equals(this.m_LineStyle)) {
                string = "dplinedash";
            } else if ("Dots".equals(this.m_LineStyle)) {
                string = "dplinedot";
            }
            int n = Math.min(this.m_X1, this.m_X2);
            int n2 = Math.min(this.m_Y1, this.m_Y2);
            int n3 = Math.max(this.m_X1, this.m_X2);
            int n4 = Math.max(this.m_Y1, this.m_Y2);
            rTFWriter.push();
            rTFWriter.command("*\\do");
            rTFWriter.command("dobxpage");
            rTFWriter.command("dobypage");
            rTFWriter.command("dpline");
            rTFWriter.command("dpx" + n);
            rTFWriter.command("dpy" + n2);
            rTFWriter.command("dpxsize" + (n3 - n));
            rTFWriter.command("dpysize" + (n4 - n2));
            rTFWriter.command("dpptx" + this.m_X1);
            rTFWriter.command("dppty" + this.m_Y1);
            rTFWriter.command("dpptx" + this.m_X2);
            rTFWriter.command("dppty" + this.m_Y2);
            rTFWriter.command("dplinew" + this.m_LineWidth);
            rTFWriter.command("dplinecor" + this.m_LineColor.getRed());
            rTFWriter.command("dplinecog" + this.m_LineColor.getGreen());
            rTFWriter.command("dplinecob" + this.m_LineColor.getBlue());
            rTFWriter.command(string);
            rTFWriter.pop();
        }
    }
}

