/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.rtf;

import com.elixirtech.rtf.RtfGroup;
import com.elixirtech.rtf.RtfNode;
import com.elixirtech.rtf.RtfToken;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;

public class RtfFontTable
implements RtfNode.IVisitor {
    private List<String> m_Fonts = new ArrayList<String>();
    private List<Charset> m_CharSets = new ArrayList<Charset>();

    public String getFontName(int n) {
        return this.m_Fonts.get(n);
    }

    public Charset getFontCharset(int n) {
        return this.m_CharSets.get(n);
    }

    public int getFontCount() {
        return this.m_Fonts.size();
    }

    @Override
    public boolean pushScope(RtfGroup rtfGroup) {
        return true;
    }

    @Override
    public boolean visit(RtfNode rtfNode) {
        RtfToken rtfToken = rtfNode.getToken();
        if ("fonttbl".equals(rtfToken.getName())) {
            RtfGroup rtfGroup = rtfNode.getParent();
            int n = rtfGroup.getChildCount();
            for (int i = 1; i < n; ++i) {
                RtfGroup rtfGroup2 = (RtfGroup)rtfGroup.getChild(i);
                this.addFont(rtfGroup2);
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean popScope(RtfGroup rtfGroup) {
        return true;
    }

    private void addFont(RtfGroup rtfGroup) {
        int n = rtfGroup.getChildCount();
        RtfToken rtfToken = rtfGroup.getChild(n - 1).getToken();
        String string = rtfToken.getData();
        if (string.endsWith(";")) {
            string = string.substring(0, string.length() - 1);
        }
        this.m_Fonts.add(string);
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            RtfToken rtfToken2 = rtfGroup.getChild(i).getToken();
            if (!"fcharset".equals(rtfToken2.getName())) continue;
            try {
                n2 = Integer.parseInt(rtfToken2.getData());
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.m_CharSets.add(RtfFontTable.getCharset(n2));
    }

    public static Charset getCharset(int n) {
        switch (n) {
            case 128: {
                return Charset.forName("Shift-JIS");
            }
            case 130: {
                return Charset.forName("CP1361");
            }
            case 134: {
                return Charset.forName("GB2312");
            }
            case 136: {
                return Charset.forName("Big5");
            }
            case 161: {
                return Charset.forName("CP1253");
            }
            case 162: {
                return Charset.forName("CP1254");
            }
            case 163: {
                return Charset.forName("CP1258");
            }
            case 177: {
                return Charset.forName("CP1255");
            }
            case 178: {
                return Charset.forName("CP1256");
            }
            case 186: {
                return Charset.forName("CP1257");
            }
            case 222: {
                return Charset.forName("CP874");
            }
            case 238: {
                return Charset.forName("CP1250");
            }
        }
        return Charset.forName("US-ASCII");
    }
}

