/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.rtf;

import com.elixirtech.rtf.RtfGroup;
import com.elixirtech.rtf.RtfNode;
import com.elixirtech.rtf.RtfToken;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;

public class RtfReader {
    private PushbackInputStream m_In;
    private StringBuffer m_Buffer;
    private int m_Depth;
    private Charset m_Charset = Charset.forName("US-ASCII");

    public RtfReader(InputStream inputStream) {
        this.m_In = new PushbackInputStream(inputStream, 4);
        this.m_Buffer = new StringBuffer();
        this.m_Depth = 0;
    }

    public void setCharset(Charset charset) {
        this.m_Charset = charset;
    }

    public void setLang(int n) {
        if (n == 1033) {
            this.m_Charset = Charset.forName("US-ASCII");
        } else if (n == 2052) {
            this.m_Charset = Charset.forName("GB2312");
        } else if (n == 1041) {
            this.m_Charset = Charset.forName("Shift-JIS");
        }
    }

    public RtfGroup getTreeRoot() throws IOException {
        RtfToken rtfToken;
        RtfGroup rtfGroup;
        RtfGroup rtfGroup2 = rtfGroup = new RtfGroup(null);
        while ((rtfToken = this.getNextToken()) != null) {
            if ("lang".equals(rtfToken.getName()) || "deflang".equals(rtfToken.getName())) {
                this.setLang(Integer.parseInt(rtfToken.getData()));
            }
            if (rtfToken.getType() == 5) {
                rtfGroup2 = new RtfGroup(rtfGroup2);
                continue;
            }
            if (rtfToken.getType() == 6) {
                rtfGroup2 = rtfGroup2.getParent();
                continue;
            }
            new RtfNode(rtfGroup2, rtfToken);
        }
        return rtfGroup;
    }

    public RtfToken getNextToken() throws IOException {
        this.m_Buffer = new StringBuffer();
        int n;
        while ((n = this.m_In.read()) != -1) {
            if (n == 92) {
                if (this.m_Buffer.length() > 0) {
                    this.m_In.unread(n);
                    String string = this.m_Buffer.toString();
                    this.m_Buffer.setLength(0);
                    return new RtfToken(string);
                }
                n = this.m_In.read();
                if (n == 42) {
                    return new RtfToken(8);
                }
                if (n == 39) {
                    Object[] objectArray;
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    while (n == 39) {
                        objectArray = new char[]{(char)this.m_In.read(), (char)this.m_In.read()};
                        int n2 = Integer.parseInt(new String((char[])objectArray), 16);
                        byteArrayOutputStream.write(n2);
                        n = this.m_In.read();
                        if (n != 92) {
                            this.m_In.unread(n);
                            break;
                        }
                        n = this.m_In.read();
                        if (n == 39) continue;
                        this.m_In.unread(n);
                        this.m_In.unread(92);
                    }
                    objectArray = byteArrayOutputStream.toByteArray();
                    ByteBuffer byteBuffer = ByteBuffer.wrap((byte[])objectArray);
                    CharBuffer charBuffer = this.m_Charset.decode(byteBuffer);
                    this.m_Buffer.append(charBuffer.array());
                    String string = this.m_Buffer.toString();
                    return new RtfToken(string);
                }
                if (n == 92) {
                    return new RtfToken("\\");
                }
                if (n == 126) {
                    return new RtfToken("\u00a0");
                }
                if (n == 45) {
                    return new RtfToken("\u2010");
                }
                if (n == 95) {
                    return new RtfToken("\u2011");
                }
                if (n == 123) {
                    return new RtfToken("{");
                }
                if (n == 125) {
                    return new RtfToken("}");
                }
                while (Character.isLetter((char)n)) {
                    this.m_Buffer.append((char)n);
                    n = this.m_In.read();
                }
                String string = this.m_Buffer.toString();
                this.m_Buffer.setLength(0);
                if (n == 45) {
                    this.m_Buffer.append((char)n);
                    n = this.m_In.read();
                }
                while (Character.isDigit((char)n)) {
                    this.m_Buffer.append((char)n);
                    n = this.m_In.read();
                }
                if (!Character.isSpaceChar((char)n)) {
                    this.m_In.unread(n);
                }
                String string2 = this.m_Buffer.toString();
                this.m_Buffer.setLength(0);
                return new RtfToken(2, string, string2);
            }
            if (n == 123) {
                if (this.m_Buffer.length() > 0) {
                    this.m_In.unread(n);
                    String string = this.m_Buffer.toString();
                    return new RtfToken(string);
                }
                ++this.m_Depth;
                return new RtfToken(5);
            }
            if (n == 125) {
                if (this.m_Buffer.length() > 0) {
                    this.m_In.unread(n);
                    String string = this.m_Buffer.toString();
                    return new RtfToken(string);
                }
                --this.m_Depth;
                return new RtfToken(6);
            }
            if (n == 13 || n == 10) continue;
            this.m_Buffer.append((char)n);
        }
        return null;
    }

    public int getDepth() {
        return this.m_Depth;
    }
}

