/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.rtf;

import com.elixirtech.arch.StringUtil;
import com.elixirtech.rtf.RTFChunk;
import com.elixirtech.rtf.RTFWriter;
import java.io.IOException;

public class TextLine
extends RTFChunk {
    private String m_Line;
    private int m_FontId;
    private int m_FontStyle;
    private int m_FontSize;
    private int m_FontColor;
    private String m_Alignment;
    private boolean m_Underline;
    private boolean m_Strikethrough;
    private int m_X;
    private int m_Y;
    private int m_Width;
    private String m_URL;

    public void setFont(int n, int n2, int n3) {
        this.m_FontId = n;
        this.m_FontStyle = n2;
        this.m_FontSize = n3;
    }

    public void setFontColor(int n) {
        this.m_FontColor = n;
    }

    public void setBounds(int n, int n2, int n3) {
        this.m_X = n;
        this.m_Y = n2;
        this.m_Width = n3;
    }

    public void setAlignment(String string) {
        if ("Left".equals(string)) {
            this.m_Alignment = "ql";
        } else if ("Right".equals(string)) {
            this.m_Alignment = "qr";
        } else if ("Center".equals(string)) {
            this.m_Alignment = "qc";
        } else if ("Justify".equals(string)) {
            this.m_Alignment = "qj";
        }
    }

    public void setUnderline(boolean bl) {
        this.m_Underline = bl;
    }

    public void setStrikethrough(boolean bl) {
        this.m_Strikethrough = bl;
    }

    public void setLine(String string) {
        this.m_Line = string;
    }

    public void setURL(String string) {
        this.m_URL = string;
    }

    @Override
    public void write(RTFWriter rTFWriter) throws IOException {
        if (StringUtil.notEmpty(this.m_URL)) {
            rTFWriter.push();
            rTFWriter.command("field");
            rTFWriter.push();
            rTFWriter.command("*\\fldinst");
            rTFWriter.push();
            rTFWriter.text("HYPERLINK \"" + this.m_URL + "\"");
            rTFWriter.pop();
            rTFWriter.pop();
            rTFWriter.push();
            rTFWriter.command("fldrslt");
        }
        rTFWriter.push();
        rTFWriter.command("pard");
        rTFWriter.command("pvpg");
        rTFWriter.command("phpg");
        rTFWriter.command("posx" + this.m_X);
        rTFWriter.command("posy" + this.m_Y);
        rTFWriter.command("absw" + this.m_Width);
        rTFWriter.command("f" + this.m_FontId);
        rTFWriter.command("fs" + this.m_FontSize / 10);
        if ((this.m_FontStyle & 1) != 0) {
            rTFWriter.command("b");
        }
        if ((this.m_FontStyle & 2) != 0) {
            rTFWriter.command("i");
        }
        if (this.m_Underline) {
            rTFWriter.command("ul");
        }
        if (this.m_Strikethrough) {
            rTFWriter.command("strike");
        }
        if (this.m_Alignment != null) {
            rTFWriter.command(this.m_Alignment);
        }
        rTFWriter.command("cf" + this.m_FontColor);
        rTFWriter.text(this.m_Line);
        rTFWriter.command("par");
        rTFWriter.pop();
        if (StringUtil.notEmpty(this.m_URL)) {
            rTFWriter.pop();
            rTFWriter.pop();
        }
    }
}

