/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.sax;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.sax.SAXDelegate;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public abstract class BasicSAXDelegate
extends DefaultHandler
implements SAXDelegate {
    protected SAXDelegate m_Delegate;
    protected int m_Count;
    protected boolean m_AttributesInitialized;
    protected static final ElxLoggerJ m_Log = ElxLoggerJ.getLogger(BasicSAXDelegate.class);

    @Override
    public abstract Object getObject();

    protected void initAttributes(Attributes attributes) {
        this.m_AttributesInitialized = true;
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        int n = string3.indexOf(":");
        string2 = n >= 0 ? string3.substring(n + 1) : string3;
        if (this.m_Delegate != null) {
            ++this.m_Count;
            this.m_Delegate.startElement(string, string2, string3, attributes);
        } else {
            this.doStart(string2, attributes);
            if (this.m_Delegate != null) {
                this.m_Delegate.startElement(string, string2, string3, attributes);
                this.m_Count = 1;
            }
        }
    }

    protected void doStart(String string, Attributes attributes) {
    }

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
        int n = string3.indexOf(":");
        string2 = n >= 0 ? string3.substring(n + 1) : string3;
        if (this.m_Count > 1) {
            this.m_Delegate.endElement(string, string2, string3);
            --this.m_Count;
        } else if (this.m_Count == 1) {
            this.doEnd(string2);
            this.m_Delegate = null;
            this.m_Count = 0;
        }
    }

    protected void doEnd(String string) {
    }

    @Override
    public void characters(char[] cArray, int n, int n2) throws SAXException {
        if (this.m_Delegate != null) {
            this.m_Delegate.characters(cArray, n, n2);
        }
    }

    protected static int getInt(Attributes attributes, String string) {
        String string2 = attributes.getValue(string);
        if (string2 != null) {
            try {
                return Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                m_Log.warn((Object)("Can't read attribute " + string + " : " + string2));
            }
        }
        return 0;
    }
}

